/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.mojang.datafixers.util.Either;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidContainerIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class PneumaticCraftAddon {
    public static final String MODID = "pneumaticcraft";

    static String NAME(String name) {
        return "PneumaticCraft" + name + "Mapper";
    }

    @ConversionProvider(value="pneumaticcraft")
    public static class PCRConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)builder.comment("Default conversions for PneumaticCraft")).before((Fluid)ModFluids.OIL.get(), 1L).conversion((ItemLike)ModItems.PLASTIC).ingredient((Fluid)ModFluids.PLASTIC.get(), 1000);
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRFluidMixerMapper
    extends ARecipeTypeMapper<FluidMixerRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("FluidMixer");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.FLUID_MIXER.get();
        }

        @Override
        public NSSOutput getOutput(FluidMixerRecipe recipe) {
            return this.mapOutputs(recipe.getOutputFluid(), recipe.getOutputItem());
        }

        @Override
        public NSSInput getInput(FluidMixerRecipe recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertFluidIngredient(recipe.getInput1().amount(), Arrays.asList(recipe.getInput1().getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            this.convertFluidIngredient(recipe.getInput2().amount(), Arrays.asList(recipe.getInput2().getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRThermoPlantMapper
    extends ARecipeTypeMapper<ThermoPlantRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("ThermopneumaticProcessingPlant");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.THERMO_PLANT.get();
        }

        @Override
        public NSSOutput getOutput(ThermoPlantRecipe recipe) {
            boolean fluidEmpty;
            ItemStack outputItem = recipe.getOutputItem();
            FluidStack outputFluid = recipe.getOutputFluid();
            boolean itemEmpty = outputItem == null || outputItem.isEmpty();
            boolean bl = fluidEmpty = outputFluid == null || outputFluid.isEmpty();
            if (itemEmpty && fluidEmpty) {
                return NSSOutput.EMPTY;
            }
            if (fluidEmpty) {
                return new NSSOutput(outputItem);
            }
            if (itemEmpty) {
                return new NSSOutput(outputFluid);
            }
            return this.mapOutputs(outputItem, outputFluid);
        }

        @Override
        public NSSInput getInput(ThermoPlantRecipe recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            recipe.getInputItem().ifPresent(arg_0 -> this.lambda$getInput$0((Object2IntMap)ingMap, fakeGroupData, arg_0));
            recipe.getInputFluid().ifPresent(arg_0 -> this.lambda$getInput$1((Object2IntMap)ingMap, fakeGroupData, arg_0));
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, recipe.getInputFluid().isPresent() || recipe.getInputItem().isPresent());
        }

        private /* synthetic */ void lambda$getInput$1(Object2IntMap ingMap, List fakeGroupData, SizedFluidIngredient ingredient) {
            this.convertFluidIngredient(ingredient.amount(), Arrays.asList(ingredient.getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
        }

        private /* synthetic */ void lambda$getInput$0(Object2IntMap ingMap, List fakeGroupData, Ingredient ingredient) {
            this.convertIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRRefineryMapper
    extends ARecipeTypeMapper<RefineryRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("Refinery");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.REFINERY.get();
        }

        @Override
        public NSSInput getInput(RefineryRecipe recipe) {
            return this.convertSingleIngredient(recipe.getInput().amount(), Arrays.asList(recipe.getInput().ingredient().getStacks()));
        }

        @Override
        public NSSOutput getOutput(RefineryRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRPressureChamberMapper
    extends ARecipeTypeMapper<PressureChamberRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("PressureChamber");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.PRESSURE_CHAMBER.get();
        }

        @Override
        public NSSInput getInput(PressureChamberRecipe recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            for (SizedIngredient ingredient : recipe.getInputs()) {
                this.convertIngredient(ingredient.count(), ingredient.ingredient(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }

        @Override
        public NSSOutput getOutput(PressureChamberRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRHeatFrameCoolingMapper
    extends ARecipeTypeMapper<HeatFrameCoolingRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("HeatFrameCooling");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.HEAT_FRAME_COOLING.get();
        }

        @Override
        public NSSInput getInput(HeatFrameCoolingRecipe recipe) {
            Either eitherInput = recipe.getInput();
            if (eitherInput.right().isPresent()) {
                Either fluidIng = ((FluidContainerIngredient)eitherInput.right().get()).either();
                if (fluidIng.right().isPresent()) {
                    return this.convertSingleIngredient(((FluidContainerIngredient)eitherInput.right().get()).amount(), StreamSupport.stream(BuiltInRegistries.FLUID.getTagOrEmpty(((FluidContainerIngredient.TagWithAmount)fluidIng.right().get()).tag()).spliterator(), false).map(i -> new FluidStack((Fluid)i.value(), 1)).toList());
                }
                if (fluidIng.left().isPresent()) {
                    return this.convertSingleIngredient(1, Collections.singletonList((FluidStack)fluidIng.left().get()));
                }
            } else if (eitherInput.left().isPresent()) {
                return this.convertSingleIngredient(1, (Ingredient)eitherInput.left().get());
            }
            return null;
        }

        @Override
        public NSSOutput getOutput(HeatFrameCoolingRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRExplosionCraftingMapper
    extends ARecipeTypeMapper<ExplosionCraftingRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("ExplosionCrafting");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default because this mapper ignore loss rate.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.EXPLOSION_CRAFTING.get();
        }

        @Override
        public NSSInput getInput(ExplosionCraftingRecipe recipe) {
            return this.convertSingleIngredient(recipe.getInput().count(), recipe.getInput().ingredient());
        }

        @Override
        public NSSOutput getOutput(ExplosionCraftingRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRAssemblyMapper
    extends ARecipeTypeMapper<AssemblyRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("Assembly");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.ASSEMBLY_DRILL.get() || recipeType == ModRecipeTypes.ASSEMBLY_LASER.get() || recipeType == ModRecipeTypes.ASSEMBLY_DRILL_LASER.get();
        }

        @Override
        public NSSInput getInput(AssemblyRecipe recipe) {
            Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertIngredient(recipe.getInputAmount(), recipe.getInput().ingredient(), (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(AssemblyRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"pneumaticcraft"}, priority=1)
    public static class PCRAmadronRecipeMapper
    extends ARecipeTypeMapper<AmadronRecipe> {
        @Override
        public String getName() {
            return PneumaticCraftAddon.NAME("AmadronRecipe");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.AMADRON.get();
        }

        @Override
        public NSSOutput getOutput(AmadronRecipe recipe) {
            AmadronTradeResource output = recipe.getOutput();
            if (output.isEmpty()) {
                return NSSOutput.EMPTY;
            }
            return (NSSOutput)output.resource().map(NSSOutput::new, NSSOutput::new);
        }

        @Override
        public NSSInput getInput(AmadronRecipe recipe) {
            AmadronTradeResource input = recipe.getInput();
            if (input.isEmpty()) {
                return null;
            }
            return (NSSInput)input.resource().map(x$0 -> this.convertSingleItemStack((ItemStack)x$0), x$0 -> this.convertSingleFluidStack((FluidStack)x$0));
        }
    }
}

