/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ACustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.CustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.Constants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class Utils {
    private static final Type CUSTOM_RECIPE_MAPPER_TYPE = Type.getType(CustomRecipeMapper.class);

    public static Map<? extends ACustomRecipeMapper<?>, String> getCustomRecipeMappers() {
        ModList modList = ModList.get();
        HashMap<ACustomRecipeMapper, String> recipeTypeMappers = new HashMap<ACustomRecipeMapper, String>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                ACustomRecipeMapper mapper;
                if (!CUSTOM_RECIPE_MAPPER_TYPE.equals((Object)data.annotationType()) || !Utils.checkRequiredMod(data) || (mapper = Utils.createOrGetInstance(data.memberName(), ACustomRecipeMapper.class)) == null) continue;
                recipeTypeMappers.put(mapper, (String)Utils.getAnnotationData(data, "value"));
                PEIntegration.LOGGER.info("Instantiated custom recipe mapper: {}", (Object)mapper.getName());
            }
        }
        return recipeTypeMappers;
    }

    public static <T> T createOrGetInstance(String className, Class<T> baseClass) {
        try {
            Class<T> subClass = Class.forName(className).asSubclass(baseClass);
            return subClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
            PEIntegration.LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            return null;
        }
    }

    public static boolean checkRequiredMod(ModFileScanData.AnnotationData data) {
        return Utils.checkRequiredMod(data, "value");
    }

    public static boolean checkRequiredMod(ModFileScanData.AnnotationData data, String key) {
        String modId = (String)Utils.getAnnotationData(data, key);
        if (modId != null && !ModList.get().isLoaded(modId)) {
            PEIntegration.debugLog("Skipped checking class {}, as its required mod ({}) is not loaded.", data.memberName(), modId);
            return false;
        }
        return true;
    }

    public static <T> T getAnnotationData(ModFileScanData.AnnotationData data, String key) {
        Map annotationData = data.annotationData();
        if (annotationData.containsKey(key)) {
            try {
                return (T)annotationData.get(key);
            }
            catch (ClassCastException e) {
                PEIntegration.LOGGER.fatal("Annotation Data {}:{} was casted to an invalid class", (Object)key, annotationData.get(key), (Object)e);
            }
        }
        return null;
    }

    public static boolean convertFluidIngredient(int amount, List<FluidStack> fluidIngredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap, INSSFakeGroupManager fakeGroupManager, String recipeID) {
        if (fluidIngredient == null) {
            return false;
        }
        if (fluidIngredient.size() == 1) {
            return !Utils.addIngredient(ingredientMap, fluidIngredient.getFirst());
        }
        if (!fluidIngredient.isEmpty()) {
            HashSet<NSSFluid> rawNSSMatches = new HashSet<NSSFluid>();
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (FluidStack match : fluidIngredient) {
                if (match.isEmpty()) continue;
                rawNSSMatches.add(NSSFluid.createFluid((FluidStack)match));
                fluids.add(match);
            }
            int count = fluids.size();
            if (count == 1) {
                return !Utils.addIngredient(ingredientMap, (FluidStack)fluids.getFirst());
            }
            if (count > 1) {
                INSSFakeGroupManager.FakeGroupData group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = group.dummy();
                ingredientMap.put((Object)dummy, Math.max(amount, 1));
                if (group.created()) {
                    ArrayList<Object2IntOpenHashMap> groupIngredientMaps = new ArrayList<Object2IntOpenHashMap>();
                    Iterator iterator = fluids.iterator();
                    while (iterator.hasNext()) {
                        Object2IntOpenHashMap groupIngredientMap = new Object2IntOpenHashMap();
                        FluidStack fluid = (FluidStack)iterator.next();
                        if (Utils.addIngredient((Object2IntMap<NormalizedSimpleStack>)groupIngredientMap, fluid.copy())) {
                            return false;
                        }
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
        }
        return true;
    }

    public static boolean convertIngredient(int amount, Ingredient ingredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap, INSSFakeGroupManager fakeGroupManager, String recipeID) {
        ItemStack[] matches = Utils.getMatchingStacks(ingredient, recipeID);
        if (matches == null) {
            return false;
        }
        if (matches.length == 1) {
            return !Utils.addIngredient(ingredientMap, Utils.getStack(matches[0], amount), recipeID);
        }
        if (matches.length > 0) {
            HashSet<NSSItem> rawNSSMatches = new HashSet<NSSItem>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack match : matches) {
                if (match.isEmpty()) continue;
                rawNSSMatches.add(NSSItem.createItem((ItemStack)match));
                stacks.add(match);
            }
            int count = stacks.size();
            if (count == 1) {
                return !Utils.addIngredient(ingredientMap, Utils.getStack((ItemStack)stacks.getFirst(), amount), recipeID);
            }
            if (count > 1) {
                INSSFakeGroupManager.FakeGroupData group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = group.dummy();
                ingredientMap.mergeInt((Object)dummy, Math.max(amount, 1), Constants.INT_SUM);
                if (group.created()) {
                    ArrayList<Object2IntOpenHashMap> groupIngredientMaps = new ArrayList<Object2IntOpenHashMap>();
                    Iterator iterator = stacks.iterator();
                    while (iterator.hasNext()) {
                        Object2IntOpenHashMap groupIngredientMap = new Object2IntOpenHashMap();
                        ItemStack stack = (ItemStack)iterator.next();
                        if (Utils.addIngredient((Object2IntMap<NormalizedSimpleStack>)groupIngredientMap, stack.copy(), recipeID)) {
                            return false;
                        }
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
        }
        return true;
    }

    public static boolean addIngredient(Object2IntMap<NormalizedSimpleStack> ingredientMap, ItemStack stack, String recipeID) {
        stack = stack.copy();
        Item item = stack.getItem();
        boolean hasContainerItem = false;
        try {
            hasContainerItem = item.hasCraftingRemainingItem(stack);
            if (hasContainerItem) {
                ingredientMap.mergeInt((Object)NSSItem.createItem((ItemStack)item.getCraftingRemainingItem(stack)), -1, Constants.INT_SUM);
            }
        }
        catch (Exception e) {
            ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)item);
            if (hasContainerItem) {
                if (Utils.isTagException(e)) {
                    PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.getNamespace(), (Object)e);
                } else {
                    PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item based on the stack in the recipe. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.getNamespace(), (Object)e);
                }
            } else if (Utils.isTagException(e)) {
                PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack has a container item, due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.getNamespace(), (Object)e);
            } else {
                PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack in the recipe has a container item. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.getNamespace(), (Object)e);
            }
            return true;
        }
        ingredientMap.mergeInt((Object)NSSItem.createItem((ItemStack)stack), stack.getCount(), Constants.INT_SUM);
        return false;
    }

    public static boolean addIngredient(Object2IntMap<NormalizedSimpleStack> ingredientMap, FluidStack stack) {
        ingredientMap.put((Object)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
        return true;
    }

    public static boolean isTagException(Exception e) {
        return e instanceof IllegalStateException && e.getMessage().matches("Tag \\S*:\\S* used before it was bound");
    }

    public static NSSOutput mapOutputs(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, String recipeID, Object ... allOutputs) {
        List<Object> outputs = Arrays.asList(allOutputs);
        if (allOutputs.length == 1 && allOutputs[0] instanceof Collection) {
            outputs = new ArrayList<Object>((Collection)allOutputs[0]);
        }
        HashMap<Object, Integer> outputStacks = new HashMap<Object, Integer>(outputs.size());
        int totalOutputs = 0;
        Iterator<Object> iterator = outputs.iterator();
        block5: while (iterator.hasNext()) {
            Object output;
            Object object = output = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStack.class, FluidStack.class}, (Object)object, n)) {
                case -1: {
                    continue block5;
                }
                case 0: {
                    ItemStack item = (ItemStack)object;
                    if (item.isEmpty()) continue block5;
                    outputStacks.put(NSSItem.createItem((ItemStack)item), item.getCount());
                    totalOutputs += item.getCount();
                    continue block5;
                }
                case 1: {
                    FluidStack fluid = (FluidStack)object;
                    if (fluid.isEmpty()) continue block5;
                    outputStacks.put(NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                    totalOutputs += fluid.getAmount();
                    continue block5;
                }
            }
            PEIntegration.LOGGER.warn("Recipe ({}) has unsupported outputs: {}. Skipping...", (Object)recipeID, output);
        }
        NormalizedSimpleStack dummy = fakeGroupManager.getOrCreateFakeGroup(outputStacks.keySet()).dummy();
        for (Map.Entry entry : outputStacks.entrySet()) {
            mapper.addConversion(((Integer)entry.getValue()).intValue(), (Object)((NormalizedSimpleStack)entry.getKey()), Utils.getDummyMap(dummy, (Integer)entry.getValue()));
        }
        return new NSSOutput(totalOutputs, dummy);
    }

    public static NSSOutput mapOutput(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, String recipeID, Object ... outputVariants) {
        List<Object> outputs = Arrays.asList(outputVariants);
        if (outputVariants.length == 1 && outputVariants[0] instanceof Collection) {
            outputs = new ArrayList<Object>((Collection)outputVariants[0]);
        }
        HashMap<Object, Integer> outputStacks = new HashMap<Object, Integer>(outputs.size());
        for (Object output : outputs) {
            if (output == null) continue;
            if (output instanceof ItemStack) {
                ItemStack item = (ItemStack)output;
                if (item.isEmpty()) continue;
                outputStacks.put(NSSItem.createItem((ItemStack)item), item.getCount());
                continue;
            }
            if (output instanceof FluidStack) {
                FluidStack fluid = (FluidStack)output;
                if (fluid.isEmpty()) continue;
                outputStacks.put(NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                continue;
            }
            PEIntegration.LOGGER.warn("Recipe ({}) has unsupported output: {}. Skipping...", (Object)recipeID, output);
        }
        NormalizedSimpleStack dummy = fakeGroupManager.getOrCreateFakeGroup(outputStacks.keySet()).dummy();
        for (Map.Entry entry : outputStacks.entrySet()) {
            mapper.addConversion(((Integer)entry.getValue()).intValue(), (Object)((NormalizedSimpleStack)entry.getKey()), Utils.getDummyMap(dummy, 1));
        }
        return new NSSOutput(1, dummy);
    }

    public static ItemStack[] getMatchingStacks(Ingredient ingredient, String recipeID) {
        try {
            return ingredient.getItems();
        }
        catch (Exception e) {
            PEIntegration.LOGGER.fatal("Failed to map recipe ({}). Ingredient ({}) failed to get matching stacks", (Object)recipeID, (Object)ingredient.getClass().getName(), (Object)e);
            return null;
        }
    }

    public static ItemStack getStack(ItemStack item, int amount) {
        if (amount > 0) {
            return new ItemStack((ItemLike)item.getItem(), amount);
        }
        return item.copy();
    }

    public static Object2IntMap<NormalizedSimpleStack> getDummyMap(NormalizedSimpleStack dummy) {
        return Utils.getDummyMap(dummy, 1);
    }

    public static Object2IntMap<NormalizedSimpleStack> getDummyMap(NormalizedSimpleStack dummy, int amount) {
        Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
        ingredientMap.put((Object)dummy, amount);
        return ingredientMap;
    }

    public static <CLZ> Field getField(Class<CLZ> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<CLZ> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Utils.getField(superClass, fieldName);
        }
    }

    public static boolean addBlockToIngredientMap(Object2IntMap<NormalizedSimpleStack> ingredientMap, Block block) {
        NormalizedSimpleStack nss = Utils.getNSSFromBlock(block);
        if (nss == null) {
            return false;
        }
        int amount = block instanceof LiquidBlock ? 1000 : 1;
        ingredientMap.put((Object)nss, amount);
        return true;
    }

    public static NormalizedSimpleStack getNSSFromBlock(Block block) {
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return NSSFluid.createFluid((Fluid)liquidBlock.fluid);
        }
        if (block.asItem() == Items.AIR) {
            return null;
        }
        return NSSItem.createItem((ItemLike)block);
    }
}

