/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.Utils;
import com.tagnumelite.projecteintegration.api.recipe.IRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class ABaseRecipeMapper<R>
implements IRecipeMapper<R> {
    protected ResourceLocation recipeID;
    protected IMappingCollector<NormalizedSimpleStack, Long> mapper;
    protected INSSFakeGroupManager fakeGroupManager;
    protected RegistryAccess registryAccess;

    protected static boolean addIngredient(Object2IntMap<NormalizedSimpleStack> ingredientMap, FluidStack stack) {
        return Utils.addIngredient(ingredientMap, stack);
    }

    @Override
    public String getDescription() {
        return "ProjectE-Integration Recipe Mapper for " + this.getName().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2") + ". Required Mods: [" + String.join((CharSequence)",", this.getRequiredMods()) + "]";
    }

    @Override
    public boolean convertRecipe(R recipe) {
        NSSOutput output = this.getOutput(recipe);
        if (output == null || output.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no outputs: {}", this.recipeID, output);
            return false;
        }
        NSSInput input = this.getInput(recipe);
        if (input == null || !input.successful) {
            return this.addConversionsAndReturn(input != null ? input.fakeGroupMap : null, true);
        }
        this.mapper.addConversion(output.amount, (Object)output.nss, input.getMap());
        return this.addConversionsAndReturn(input.fakeGroupMap, true);
    }

    protected NSSInput convertFluidIngredients(List<List<FluidStack>> fluidIngredients) {
        if (fluidIngredients == null || fluidIngredients.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no inputs: {}", this.recipeID, fluidIngredients);
            return null;
        }
        ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
        Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
        for (List<FluidStack> ingredient : fluidIngredients) {
            if (this.convertFluidIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
        }
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
    }

    protected boolean convertFluidIngredient(FluidStack fluidIngredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return Utils.convertFluidIngredient(-1, Collections.singletonList(fluidIngredient), ingredientMap, fakeGroupMap, this.fakeGroupManager, this.recipeID.toString());
    }

    protected boolean convertFluidIngredient(List<FluidStack> fluidIngredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return this.convertFluidIngredient(-1, fluidIngredient, ingredientMap, fakeGroupMap);
    }

    protected boolean convertFluidIngredient(int amount, List<FluidStack> fluidIngredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return Utils.convertFluidIngredient(amount, fluidIngredient, ingredientMap, fakeGroupMap, this.fakeGroupManager, this.recipeID.toString());
    }

    protected NSSInput convertSingleItemStack(ItemStack stack) {
        return this.convertSingleIngredient(stack.getCount(), Ingredient.of((ItemStack[])new ItemStack[]{stack}));
    }

    protected NSSInput convertSingleFluidStack(FluidStack stack) {
        return this.convertSingleIngredient(stack.getAmount(), Collections.singletonList(stack));
    }

    protected NSSInput convertSingleIngredient(int amount, Ingredient ingredient) {
        Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
        ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
        boolean successful = this.convertIngredient(amount, ingredient, (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap);
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap, successful);
    }

    protected NSSInput convertSingleIngredient(int amount, List<FluidStack> fluidIngredient) {
        Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
        ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
        boolean successful = this.convertFluidIngredient(amount, fluidIngredient, (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap);
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap, successful);
    }

    protected boolean convertItemStack(ItemStack stack, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return this.convertIngredient(stack.getCount(), Ingredient.of((ItemStack[])new ItemStack[]{stack}), ingredientMap, fakeGroupMap);
    }

    protected boolean convertIngredient(Ingredient ingredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return this.convertIngredient(-1, ingredient, ingredientMap, fakeGroupMap);
    }

    protected boolean convertIngredient(int amount, Ingredient ingredient, Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap) {
        return Utils.convertIngredient(amount, ingredient, ingredientMap, fakeGroupMap, this.fakeGroupManager, this.recipeID.toString());
    }

    protected NSSOutput mapOutputs(Object ... allOutputs) {
        return Utils.mapOutputs(this.mapper, this.fakeGroupManager, this.recipeID.toString(), allOutputs);
    }

    protected NSSOutput mapOutput(Object ... outputVariants) {
        return Utils.mapOutput(this.mapper, this.fakeGroupManager, this.recipeID.toString(), outputVariants);
    }

    protected boolean addConversionsAndReturn(List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> dummyGroupInfos, boolean returnValue) {
        if (dummyGroupInfos != null) {
            for (Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>> dummyGroupInfo : dummyGroupInfos) {
                for (Object2IntMap groupIngredientMap : (List)dummyGroupInfo.getB()) {
                    this.mapper.addConversion(1, (Object)((NormalizedSimpleStack)dummyGroupInfo.getA()), groupIngredientMap);
                }
            }
        }
        return returnValue;
    }

    protected INSSFakeGroupManager.FakeGroupData getFakeGroup(NormalizedSimpleStack ... stacks) {
        return this.fakeGroupManager.getOrCreateFakeGroup(new HashSet<NormalizedSimpleStack>(Arrays.asList(stacks)));
    }

    public NSSOutput.Builder getOutputBuilder() {
        return new NSSOutput.Builder(this.mapper, this.fakeGroupManager, this.recipeID);
    }

    public abstract String[] getRequiredMods();
}

