/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ABaseRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.CustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class ACustomRecipeMapper<R>
extends ABaseRecipeMapper<R> {
    public abstract List<R> getRecipes();

    protected abstract List<Ingredient> getIngredients(R var1);

    protected abstract ItemStack getResult(R var1);

    @Override
    public NSSInput getInput(R recipe) {
        List<Ingredient> ingredients = this.getIngredients(recipe);
        if (ingredients == null || ingredients.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no inputs: {}", recipe, ingredients);
            return null;
        }
        ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
        Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
        for (Ingredient ingredient : ingredients) {
            if (this.convertIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
        }
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
    }

    @Override
    public NSSOutput getOutput(R recipe) {
        ItemStack output = this.getResult(recipe);
        if (output.isEmpty()) {
            return null;
        }
        return new NSSOutput(output);
    }

    public final boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Object recipe, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        this.recipeID = ResourceLocation.fromNamespaceAndPath((String)this.getRequiredMods()[0], (String)this.getName().toLowerCase());
        this.mapper = mapper;
        this.fakeGroupManager = fakeGroupManager;
        this.registryAccess = registryAccess;
        try {
            return this.convertRecipe(recipe);
        }
        catch (ClassCastException e) {
            PEIntegration.LOGGER.fatal("RecipeMapper ({}) is unable to handle recipe ({}), expected ({})", (Object)this.getClass().getName(), (Object)recipe.getClass().getName(), (Object)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getTypeName());
        }
        catch (Exception e) {
            PEIntegration.LOGGER.fatal("RecipeMapper ({}) failed unexpectedly during the handling of recipe '{}' ({}).", (Object)this.getClass().getName(), (Object)this.recipeID, (Object)recipe.getClass().getName(), (Object)e);
        }
        return false;
    }

    @Override
    public String[] getRequiredMods() {
        CustomRecipeMapper recipeTypeMapperAnnotation = this.getClass().getAnnotation(CustomRecipeMapper.class);
        if (recipeTypeMapperAnnotation != null) {
            return new String[]{recipeTypeMapperAnnotation.value()};
        }
        return new String[]{"unregistered_mapper"};
    }
}

