/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe.nss;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.Constants;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class NSSInput {
    public final Object2IntMap<NormalizedSimpleStack> ingredientMap;
    public final List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap;
    public final boolean successful;

    public NSSInput(Object2IntMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap, boolean successful) {
        this.ingredientMap = ingredientMap;
        this.fakeGroupMap = fakeGroupMap;
        this.successful = successful;
    }

    public NSSInput(Object2IntMap<NormalizedSimpleStack> ingredientMap, boolean successful) {
        this(ingredientMap, new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>(), successful);
    }

    public static NSSInput createFluid(FluidStack fluid) {
        Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
        ingMap.mergeInt((Object)NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount(), Constants.INT_SUM);
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, true);
    }

    public static NSSInput createItem(ItemStack item) {
        Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
        ingMap.mergeInt((Object)NSSItem.createItem((ItemStack)item), item.getCount(), Constants.INT_SUM);
        return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, true);
    }

    public Object2IntMap<NormalizedSimpleStack> getMap() {
        return this.ingredientMap;
    }
}

