/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe.nss;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class NSSOutput {
    public static final NSSOutput EMPTY = new NSSOutput(0, null);
    public final NormalizedSimpleStack nss;
    public final int amount;

    public NSSOutput(int amount, NormalizedSimpleStack nss) {
        this.amount = amount;
        this.nss = nss;
    }

    public NSSOutput(ItemStack item) {
        this(item, false);
    }

    public NSSOutput(ItemStack item, boolean forceCopyNBT) {
        this.amount = item.getCount();
        this.nss = forceCopyNBT ? NSSItem.createItem((ItemLike)item.getItem(), (DataComponentPatch)item.getComponentsPatch()) : NSSItem.createItem((ItemStack)item);
    }

    public NSSOutput(FluidStack fluid) {
        this.amount = fluid.getAmount();
        this.nss = NSSFluid.createFluid((FluidStack)fluid);
    }

    public NSSOutput(BlockState state) {
        this.amount = 1;
        this.nss = NSSItem.createItem((ItemLike)state.getBlock());
    }

    public static Builder builder(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, ResourceLocation recipeId) {
        return new Builder(mapper, fakeGroupManager, recipeId);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.amount <= 0 || this.nss == null;
    }

    public String toString() {
        return "NSSOutput{amount=" + this.amount + ";nss=" + String.valueOf(this.nss) + "}";
    }

    public static class Builder {
        private final IMappingCollector<NormalizedSimpleStack, Long> mapper;
        private final INSSFakeGroupManager fakeGroupManager;
        private final ResourceLocation recipeID;
        private final HashMap<NormalizedSimpleStack, Integer> outputStacks;
        private int totalOutputs;

        public Builder(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, ResourceLocation recipeID) {
            this.mapper = mapper;
            this.fakeGroupManager = fakeGroupManager;
            this.recipeID = recipeID;
            this.outputStacks = new HashMap();
            this.totalOutputs = 0;
        }

        public void addOutput(Object ... variants) {
            if (variants.length <= 0) {
                return;
            }
            this.addOutput(Arrays.asList(variants));
        }

        public void addOutput(List<?> variants) {
            if (variants == null || variants.isEmpty()) {
                return;
            }
            HashMap<Object, Integer> outputStacks = new HashMap<Object, Integer>(variants.size());
            for (Object variant : variants) {
                if (variant == null) continue;
                if (variant instanceof ItemStack) {
                    ItemStack item = (ItemStack)variant;
                    if (item.isEmpty()) {
                        PEIntegration.debugLog("ItemStack ({}) came up empty during recipe '{}'", item, this.recipeID);
                        continue;
                    }
                    outputStacks.put(NSSItem.createItem((ItemStack)item), item.getCount());
                    continue;
                }
                if (variant instanceof FluidStack) {
                    FluidStack fluid = (FluidStack)variant;
                    if (fluid.isEmpty()) {
                        PEIntegration.debugLog("FluidStack ({}) came up empty during recipe '{}'", fluid, this.recipeID);
                        continue;
                    }
                    outputStacks.put(NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                    continue;
                }
                PEIntegration.LOGGER.warn("Recipe ({}) has unsupported output variant: {}. Skipping...", (Object)this.recipeID, variant);
            }
            NormalizedSimpleStack dummy = this.fakeGroupManager.getOrCreateFakeGroup(outputStacks.keySet()).dummy();
            for (Map.Entry entry : outputStacks.entrySet()) {
                this.mapper.addConversion(((Integer)entry.getValue()).intValue(), (Object)((NormalizedSimpleStack)entry.getKey()), Utils.getDummyMap(dummy, 1));
            }
            this.outputStacks.put(dummy, 1);
            ++this.totalOutputs;
        }

        public void addOutputs(Object ... outputs) {
            if (outputs.length <= 0) {
                return;
            }
            this.addOutputs(Arrays.asList(outputs));
        }

        public void addOutputs(List<?> outputs) {
            if (outputs == null || outputs.isEmpty()) {
                return;
            }
            for (Object output : outputs) {
                if (output == null) continue;
                if (output instanceof ItemStack) {
                    ItemStack item = (ItemStack)output;
                    if (item.isEmpty()) {
                        PEIntegration.debugLog("ItemStack ({}) came up empty during recipe '{}'", item, this.recipeID);
                        continue;
                    }
                    this.outputStacks.put((NormalizedSimpleStack)NSSItem.createItem((ItemStack)item), item.getCount());
                    this.totalOutputs += item.getCount();
                    continue;
                }
                if (output instanceof FluidStack) {
                    FluidStack fluid = (FluidStack)output;
                    if (fluid.isEmpty()) {
                        PEIntegration.debugLog("FluidStack ({}) came up empty during recipe '{}'", fluid, this.recipeID);
                        continue;
                    }
                    this.outputStacks.put((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                    this.totalOutputs += fluid.getAmount();
                    continue;
                }
                PEIntegration.LOGGER.warn("Recipe ({}) has unsupported output: {}. Skipping...", (Object)this.recipeID, output);
            }
        }

        public NSSOutput toOutput() {
            if (this.totalOutputs <= 0 || this.outputStacks.isEmpty()) {
                PEIntegration.LOGGER.warn("NSSOutput.Builder resulted in {} outputs from recipe ({}): {}", (Object)this.totalOutputs, (Object)this.recipeID, this.outputStacks);
                return EMPTY;
            }
            NormalizedSimpleStack dummy = this.fakeGroupManager.getOrCreateFakeGroup(this.outputStacks.keySet()).dummy();
            for (Map.Entry<NormalizedSimpleStack, Integer> entry : this.outputStacks.entrySet()) {
                this.mapper.addConversion(entry.getValue().intValue(), (Object)entry.getKey(), Utils.getDummyMap(dummy, entry.getValue()));
            }
            return new NSSOutput(this.totalOutputs, dummy);
        }

        public boolean isEmpty() {
            return this.outputStacks.isEmpty();
        }
    }
}

