/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.datagen;

import com.tagnumelite.projecteintegration.datagen.PEIBlockTagsProvider;
import com.tagnumelite.projecteintegration.datagen.PEICustomConversionProvider;
import com.tagnumelite.projecteintegration.datagen.PEIItemTagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="projecteintegration", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PEIBlockTagsProvider blockTagsProvider = new PEIBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        gen.addProvider(event.includeServer(), (DataProvider)new PEIItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new PEICustomConversionProvider(packOutput, lookupProvider));
    }
}

