/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.datagen;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.data.CustomConversionProvider;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public class PEICustomConversionProvider
extends CustomConversionProvider {
    private static final Type CONVERSION_PROVIDER_TYPE = Type.getType(ConversionProvider.class);

    protected PEICustomConversionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, "projecteintegration");
    }

    private static NormalizedSimpleStack gemTag(String gem) {
        return PEICustomConversionProvider.tag("c:gems/" + gem);
    }

    private static NormalizedSimpleStack tag(String tag) {
        return NSSItem.createTag((ResourceLocation)ResourceLocation.parse((String)tag));
    }

    private static NormalizedSimpleStack ingotTag(String ingot) {
        return PEICustomConversionProvider.tag("c:ingots/" + ingot);
    }

    private Map<AConversionProvider, String> getConversionProviders() {
        ModList modList = ModList.get();
        HashMap<AConversionProvider, String> conversionProviders = new HashMap<AConversionProvider, String>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                Map annotationData;
                AConversionProvider provider;
                if (!CONVERSION_PROVIDER_TYPE.equals((Object)data.annotationType()) || (provider = this.createInstance(data.memberName())) == null || !(annotationData = data.annotationData()).containsKey("value")) continue;
                conversionProviders.put(provider, (String)annotationData.get("value"));
            }
        }
        return conversionProviders;
    }

    private AConversionProvider createInstance(String className) {
        try {
            return Class.forName(className).asSubclass(AConversionProvider.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            PEIntegration.LOGGER.error("Failed to load conversion provider: {}", (Object)className, (Object)e);
            return null;
        }
    }

    protected void addCustomConversions(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.createConversionBuilder(PEIntegration.RL("pei_metals")).before(PEICustomConversionProvider.ingotTag("zinc"), 128L).before(PEICustomConversionProvider.ingotTag("cobalt"), 412L).before(PEICustomConversionProvider.ingotTag("tungsten"), 356L).before(new FluidStack((Fluid)Fluids.WATER, 250), 1L);
        this.createConversionBuilder(PEIntegration.RL("pei_fluids")).before((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"milk")), 1L).before(PEICustomConversionProvider.tag("foods/milk"), 16L);
        for (Map.Entry<AConversionProvider, String> entry : this.getConversionProviders().entrySet()) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)entry.getValue(), (String)(entry.getValue() + "_default"));
            PEIntegration.debugLog("Add custom conversions for {}", resourceLocation);
            CustomConversionBuilder builder = this.createConversionBuilder(resourceLocation);
            entry.getKey().convert(builder);
        }
    }
}

