/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.datagen;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.datagen.APEIItemTagsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class PEIItemTagsProvider
extends ItemTagsProvider {
    private static final Type PROVIDER_TYPE = Type.getType(com.tagnumelite.projecteintegration.api.datagen.PEIItemTagsProvider.class);

    public PEIItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "projecteintegration", existingFileHelper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        for (APEIItemTagsProvider tagProvider : this.getItemTagProviders()) {
            tagProvider.addTags(provider, x$0 -> this.tag((TagKey)x$0));
        }
    }

    private List<APEIItemTagsProvider> getItemTagProviders() {
        ModList modList = ModList.get();
        ArrayList<APEIItemTagsProvider> providers = new ArrayList<APEIItemTagsProvider>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                APEIItemTagsProvider instance;
                if (!PROVIDER_TYPE.equals((Object)data.annotationType()) || (instance = this.createInstance(data.memberName())) == null) continue;
                providers.add(instance);
            }
        }
        return providers;
    }

    private APEIItemTagsProvider createInstance(String className) {
        try {
            return Class.forName(className).asSubclass(APEIItemTagsProvider.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            PEIntegration.LOGGER.error("Failed to load item tags provider: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

