/*
 * Decompiled with CFR 0.152.
 */
package gungun974.dynamicprojector;

import gungun974.dynamicprojector.DynamicProjectorSourceInterface;
import gungun974.dynamicprojector.IRenderGlobal;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.core.entity.Entity;

public class DynamicProjectorManager {
    private static final LinkedList<DynamicProjectorSourceInterface> DynamicProjectorSources = new LinkedList();

    private static void updateAllDynamicProjectorSourcesCache() {
        DynamicProjectorSources.clear();
        for (Entity entity : Minecraft.getMinecraft().currentWorld.loadedEntityList) {
            if (!(entity instanceof DynamicProjectorSourceInterface)) continue;
            DynamicProjectorSources.add((DynamicProjectorSourceInterface)entity);
        }
    }

    public static int calculateDynamicLightmapForPos(double x, double y, double z, int lightmapCoord) {
        double maxLightLevel = 0.0;
        for (DynamicProjectorSourceInterface source : DynamicProjectorSources) {
            double dist = Math.sqrt(Math.pow(source.bta_dynamic_projector$getX() - x, 2.0) + Math.pow(source.bta_dynamic_projector$getY() - y, 2.0) + Math.pow(source.bta_dynamic_projector$getZ() - z, 2.0));
            double multiplier = 1.0 - dist / 11.625;
            double lightLevel = multiplier * source.bta_dynamic_projector$calculateDynamicLightLevel();
            if (!(maxLightLevel < lightLevel)) continue;
            maxLightLevel = lightLevel;
        }
        int skylight = lightmapCoord >> 20;
        int blocklight = lightmapCoord >> 4 & 0xFFFF;
        if ((double)blocklight < maxLightLevel) {
            return LightmapHelper.getLightmapCoord((int)skylight, (int)((int)maxLightLevel));
        }
        return lightmapCoord;
    }

    public static void updateWorld() {
        DynamicProjectorManager.updateAllDynamicProjectorSourcesCache();
        for (DynamicProjectorSourceInterface source : DynamicProjectorSources) {
            if (!source.bta_dynamic_projector$shouldRefreshLight()) continue;
            double x = source.bta_dynamic_projector$getX();
            double y = source.bta_dynamic_projector$getY();
            double z = source.bta_dynamic_projector$getZ();
            ((IRenderGlobal)Minecraft.getMinecraft().renderGlobal).bta_dynamic_projector$markDirtyDynamicLight((int)(x - 11.625), (int)(y - 11.625), (int)(z - 11.625), (int)(x + 11.625), (int)(y + 11.625), (int)(z + 11.625));
        }
    }
}

