/*
 * Decompiled with CFR 0.152.
 */
package gungun974.dynamicprojector.mixins;

import gungun974.dynamicprojector.DynamicProjectorManager;
import gungun974.dynamicprojector.DynamicProjectorMode;
import gungun974.dynamicprojector.DynamicProjectorSourceInterface;
import gungun974.dynamicprojector.IGameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.entity.projectile.ProjectileFireball;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ProjectileFireball.class}, remap=false)
public class ProjectileFireballMixin
extends Projectile
implements DynamicProjectorSourceInterface {
    @Unique
    double oldX = 0.0;
    @Unique
    double oldY = 0.0;
    @Unique
    double oldZ = 0.0;
    @Unique
    double oldLightLevel = 0.0;

    public ProjectileFireballMixin(World world) {
        super(world);
    }

    @Override
    public double bta_dynamic_projector$calculateDynamicLightLevel() {
        if (((IGameSettings)Minecraft.getMinecraft().gameSettings).bta_dynamic_projector$getDynamicProjectorMode().value == DynamicProjectorMode.OFF) {
            return 0.0;
        }
        if (this.removed) {
            return 0.0;
        }
        return 14.0;
    }

    public void remove() {
        super.remove();
        DynamicProjectorManager.updateWorld();
    }

    @Override
    public double bta_dynamic_projector$getX() {
        return this.x - 0.5;
    }

    @Override
    public double bta_dynamic_projector$getY() {
        return this.y - 0.5;
    }

    @Override
    public double bta_dynamic_projector$getZ() {
        return this.z - 0.5;
    }

    @Unique
    private boolean equalsWithTwoDecimals(double a, double b) {
        return Math.round(a * 100.0) != Math.round(b * 100.0);
    }

    @Override
    public boolean bta_dynamic_projector$shouldRefreshLight() {
        double newLight = this.bta_dynamic_projector$calculateDynamicLightLevel();
        double newX = this.bta_dynamic_projector$getX();
        double newY = this.bta_dynamic_projector$getY();
        double newZ = this.bta_dynamic_projector$getZ();
        boolean dirty = this.equalsWithTwoDecimals(this.oldLightLevel, newLight);
        if (Math.round(newLight * 100.0) > 0L) {
            if (this.equalsWithTwoDecimals(this.oldX, newX)) {
                dirty = true;
            }
            if (this.equalsWithTwoDecimals(this.oldY, newY)) {
                dirty = true;
            }
            if (this.equalsWithTwoDecimals(this.oldZ, newZ)) {
                dirty = true;
            }
        }
        this.oldX = newX;
        this.oldY = newY;
        this.oldZ = newZ;
        this.oldLightLevel = newLight;
        return dirty;
    }
}

