/*
 * Decompiled with CFR 0.152.
 */
package gungun974.dynamicprojector.mixins;

import gungun974.dynamicprojector.DynamicProjectorMode;
import gungun974.dynamicprojector.IGameSettings;
import gungun974.dynamicprojector.IRenderGlobal;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.core.util.helper.MathHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderGlobal.class}, remap=false)
public class RenderGlobalMixin
implements IRenderGlobal {
    @Shadow
    private ChunkRenderer[] chunkRenderers;
    @Shadow
    private int renderChunksTall;
    @Shadow
    private int renderChunksDeep;
    @Shadow
    private int renderChunksWide;
    @Shadow
    @Final
    private Minecraft mc;
    @Unique
    private final Queue<ChunkRenderer> lightChunkRenderersToUpdate = new ArrayDeque<ChunkRenderer>();
    @Unique
    int cooldown = 0;

    @Override
    public void bta_dynamic_projector$markDirtyDynamicLight(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int wrMinX = MathHelper.bucketInt((int)minX, (int)16);
        int wrMinY = MathHelper.bucketInt((int)minY, (int)16);
        int wrMinZ = MathHelper.bucketInt((int)minZ, (int)16);
        int wrMaxX = MathHelper.bucketInt((int)maxX, (int)16);
        int wrMaxY = MathHelper.bucketInt((int)maxY, (int)16);
        int wrMaxZ = MathHelper.bucketInt((int)maxZ, (int)16);
        for (int wrX = wrMinX; wrX <= wrMaxX; ++wrX) {
            int realWrX = wrX % this.renderChunksWide;
            if (realWrX < 0) {
                realWrX += this.renderChunksWide;
            }
            for (int wrY = wrMinY; wrY <= wrMaxY; ++wrY) {
                int realWrY = wrY % this.renderChunksTall;
                if (realWrY < 0) {
                    realWrY += this.renderChunksTall;
                }
                for (int wrZ = wrMinZ; wrZ <= wrMaxZ; ++wrZ) {
                    int realWrZ = wrZ % this.renderChunksDeep;
                    if (realWrZ < 0) {
                        realWrZ += this.renderChunksDeep;
                    }
                    int i = (realWrZ * this.renderChunksTall + realWrY) * this.renderChunksWide + realWrX;
                    ChunkRenderer worldrenderer = this.chunkRenderers[i];
                    if (worldrenderer.dirty || this.lightChunkRenderersToUpdate.contains(worldrenderer)) continue;
                    this.lightChunkRenderersToUpdate.add(worldrenderer);
                }
            }
        }
    }

    @Inject(method={"updateRenderers"}, at={@At(value="TAIL")})
    public void clearChunkPriority(ICamera camera, CallbackInfoReturnable<Boolean> cir) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = ((IGameSettings)this.mc.gameSettings).bta_dynamic_projector$getDynamicProjectorMode().value == DynamicProjectorMode.FAST ? 40 : 4;
        for (int i = 0; i < 12; ++i) {
            if (this.lightChunkRenderersToUpdate.isEmpty()) {
                return;
            }
            ChunkRenderer chunkRenderer = this.lightChunkRenderersToUpdate.remove();
            if (!chunkRenderer.visible) {
                --i;
                continue;
            }
            chunkRenderer.setDirty();
            chunkRenderer.rebuild();
            chunkRenderer.dirty = false;
        }
    }
}

