package net.davdeo.itemmagnetmod.event.custom;

import net.davdeo.itemmagnetmod.ItemMagnetMod;
import net.davdeo.itemmagnetmod.item.ModItems;
import net.davdeo.itemmagnetmod.util.ItemMagnetHelper;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public interface PickupItemEvent {
    Event<PickupItemEvent> EVENT = EventFactory.createArrayBacked(PickupItemEvent.class,
            listeners -> (player, count) -> {
                for(PickupItemEvent listener : listeners) {
                    class_1269 result = listener.onPickup(player, count);

                    if (result != class_1269.field_5811) {
                        return result;
                    }
                }

                return class_1269.field_5811;
            });

    class_1269 onPickup(class_1657 player, int count);

    static class_1269 onPickupEvent(class_1657 player, int pickedUpItemsCount) {
        ItemMagnetMod.LOGGER.debug("On pickup event");
        int activeMagnetInventoryIndex = ItemMagnetHelper.getFirstActiveMagnetInventoryIndex(player);

        if (activeMagnetInventoryIndex == -1) {
            return class_1269.field_5811;
        }

        class_1799 activeMagnet = player.method_31548().method_5438(activeMagnetInventoryIndex);

        if (player.method_31549().field_7477) {
            return class_1269.field_5811;
        }

        class_3222 serverPlayer = null;
        if (player instanceof class_3222 serverPlayerEntity) {
            serverPlayer = serverPlayerEntity;
        }

        int newDamage = activeMagnet.method_7919() + pickedUpItemsCount;

        if (serverPlayer != null && pickedUpItemsCount != 0) {
            class_174.field_1185.method_8960(serverPlayer, activeMagnet, newDamage);
        }

        activeMagnet.method_7974(newDamage);

        if (newDamage >= activeMagnet.method_7936()) {
            activeMagnet.method_7934(1);

            player.method_31548().method_5447(activeMagnetInventoryIndex, new class_1799(ModItems.ITEM_MAGNET_BROKEN));
            if (serverPlayer != null && !serverPlayer.method_51469().method_8608()) {
                serverPlayer.method_51469().method_8396(
                        null,
                        serverPlayer.method_24515(),
                        class_3417.field_15075.comp_349(),
                        class_3419.field_15248,
                        1f, 1f
                );
            }
        }

        return class_1269.field_5811;
    }
}
