package net.davdeo.itemmagnetmod.mixin;

import net.davdeo.itemmagnetmod.event.custom.PickupItemEvent;
import net.davdeo.itemmagnetmod.util.ItemMagnetHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_8046;
import net.minecraft.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(value = class_1542.class, priority = 1002)
public abstract class ItemEntityMixin extends class_1297 implements class_8046 {
	@Unique
	private static final double PICKUP_DISTANCE = 32.0;
	@Unique
	private static final double SQUARED_PICKUP_DISTANCE = PICKUP_DISTANCE * PICKUP_DISTANCE;
	@Unique
	private class_1657 target;

	protected ItemEntityMixin(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	/*
	 * Updates the target of the ItemEntity.
	 * It searches all players for the closest player with an active magnet in its inventory.
	 * As soon as an ItemEntity has a target, it tries to move towards it.
	 */
	@Unique
	private void updateTarget() {
		class_1542 thisObj = (class_1542)(Object)this;

		class_1657 nextTarget = ItemMagnetHelper.getClosestPlayerWithActiveMagnet(thisObj.method_37908(), thisObj);

		if (nextTarget != null && (nextTarget.method_7325() || nextTarget.method_29504())) {
			this.target = null;

			return;
		}

		if (
			this.target == null
			|| this.target.method_5858(thisObj) > SQUARED_PICKUP_DISTANCE
			|| this.target != nextTarget
		) {
			this.target = nextTarget;
		}
	}

	/**
	 * Injects movement logic in tick method, before call of getStandingEyeHeight.
	 * Method is responsible for updating the target every 20 ticks and moving the ItemEntity towards the target.
	 * The velocity towards the target is getting higher the closer the entity is to the target.
	 * The logic used here is inspired by the behaviour of the ExperienceOrbEntity.
	 *
	 *  public void tick() {
	 * ...
	 * 		this.prevX = this.getX();
	 * 		this.prevY = this.getY();
	 * 		this.prevZ = this.getZ();
	 * 		Vec3d vec3d = this.getVelocity();
	 *
	 * ---> Inject here. After call to getVelocity and before applying any movement
	 *
	 *      if (this.isTouchingWater() && this.getFluidHeight(FluidTags.WATER) > 0.10000000149011612) {
	 *          this.applyWaterBuoyancy();
	 *      } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > 0.10000000149011612) {
	 *          this.applyLavaBuoyancy();
	 *      } else {
	 *          this.applyGravity();
	 *      }
	 * ...
	 */
	@Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;isTouchingWater()Z"))
	private void moveToTarget(CallbackInfo info) {
		class_1542 thisObj = (class_1542)(Object)this;

		if (thisObj.field_6012 % 20 == 1) {
			this.updateTarget();
		}

		// add to velocity depending on how far the items are away -> increased velocity, the closer the items get#
		// Following logic was taken from ExperienceOrbEntity and slightly modified.
		if (this.target != null) {
			class_243 targetEyeVector = new class_243(this.target.method_23317() - thisObj.method_23317(), this.target.method_23318() + this.target.method_5751() / 2.0 - thisObj.method_23318(), this.target.method_23321() - thisObj.method_23321());
			double squaredTargetEyeDistance = targetEyeVector.method_1027();

			if (squaredTargetEyeDistance < SQUARED_PICKUP_DISTANCE) {
				double relativeTargetEyeDistance = 1.0 - Math.sqrt(squaredTargetEyeDistance) / PICKUP_DISTANCE;
				thisObj.method_18799(thisObj.method_18798().method_1019(targetEyeVector.method_1029().method_1021(relativeTargetEyeDistance * relativeTargetEyeDistance * 0.1)));
			}
		}

		if (
			this.target != null &&
			this.method_24828() &&
			this.method_18798().method_37268() > 1.0E-5f &&
			(this.field_6012 + this.method_5628()) % 4 == 0
		) {
			thisObj.method_5784(class_1313.field_6308, thisObj.method_18798());
		}
	}

	/**
	 * Redirects the call of insertStack in the onPlayerCollision method.
	 * Invokes the PickupItemEvent when a PlayerEntity picks up an ItemEntity.
	 * Event is invoked with the player picking up the item and the stack that is picked up.
	 */
	@Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;insertStack(Lnet/minecraft/item/ItemStack;)Z"), method = "onPlayerCollision")
	private boolean redirectedInsertStack(class_1661 instance, class_1799 stack) {
		int stackSizeBeforePickup = stack.method_7947();
		boolean fullyPickedUp = instance.method_7394(stack);
		int stackSizeAfterPickup = stack.method_7947();

		if (stackSizeBeforePickup == stackSizeAfterPickup) {
			// Only triggered if no item was picked up, therefore fullyPickedUp should always be false here.
			return fullyPickedUp;
		}

		int pickedUpItemsCount = stackSizeBeforePickup - stackSizeAfterPickup;

		PickupItemEvent.EVENT.invoker().onPickup(instance.field_7546, pickedUpItemsCount);

		return fullyPickedUp;
	}
}
