/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.autosow;

import com.nenio.autosow.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod(value="autosow")
public class AutoSow {
    public static final String MODID = "autosow";

    public AutoSow() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AutoSow::onCommonSetup);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        int age;
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!((Boolean)Config.ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block == Blocks.SWEET_BERRY_BUSH && state.hasProperty((Property)BlockStateProperties.AGE_3) && (age = ((Integer)state.getValue((Property)BlockStateProperties.AGE_3)).intValue()) >= 2 && age <= 3) {
            int min;
            int count = min + level.random.nextInt((switch (age) {
                case 2 -> {
                    min = 1;
                    yield 2;
                }
                default -> {
                    min = 2;
                    yield 3;
                }
            }) - min + 1);
            if (((Boolean)Config.DIRECT_TO_INVENTORY.get()).booleanValue()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.SWEET_BERRIES, count));
            } else {
                Block.popResource((Level)((ServerLevel)level), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.SWEET_BERRIES, count));
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)), 3);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (!AutoSow.isWhitelistedBlock(block)) {
            return;
        }
        if (!AutoSow.isMature(state)) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (held.isEmpty() || !AutoSow.heldMatchesBlock(held, block)) {
            return;
        }
        Block target = AutoSow.resolveTargetReplantBlock(block);
        if (target == Blocks.AIR) {
            return;
        }
        boolean directToInv = (Boolean)Config.DIRECT_TO_INVENTORY.get();
        if (directToInv) {
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)held);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            if (((Boolean)Config.CONSUME_ITEM.get()).booleanValue() && !player.getAbilities().instabuild) {
                held.shrink(1);
            }
            AutoSow.replant(level, pos, state, target);
            for (ItemStack drop : drops) {
                if (drop.isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop.copy());
            }
        } else {
            boolean destroyed = level.destroyBlock(pos, true, (Entity)player);
            if (!destroyed) {
                return;
            }
            if (((Boolean)Config.CONSUME_ITEM.get()).booleanValue() && !player.getAbilities().instabuild) {
                held.shrink(1);
            }
            AutoSow.replant(level, pos, state, target);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private static void replant(Level level, BlockPos pos, BlockState previousState, Block target) {
        if (target instanceof CropBlock) {
            CropBlock crop = (CropBlock)target;
            BlockPos soilPos = pos.below();
            if (!level.getBlockState(soilPos).is(Blocks.FARMLAND)) {
                level.setBlock(soilPos, Blocks.FARMLAND.defaultBlockState(), 3);
            }
            level.setBlock(pos, crop.getStateForAge(0), 3);
        } else if (target == Blocks.NETHER_WART) {
            BlockPos soilPos = pos.below();
            if (!level.getBlockState(soilPos).is(Blocks.SOUL_SAND)) {
                level.setBlock(soilPos, Blocks.SOUL_SAND.defaultBlockState(), 3);
            }
            level.setBlock(pos, (BlockState)Blocks.NETHER_WART.defaultBlockState().setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)), 3);
        } else if (target == Blocks.COCOA) {
            Direction facing = previousState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)previousState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : Direction.NORTH;
            BlockPos supportPos = pos.relative(facing.getOpposite());
            BlockState support = level.getBlockState(supportPos);
            if (!AutoSow.isValidCocoaSupport(support.getBlock())) {
                return;
            }
            BlockState cocoa0 = (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            level.setBlock(pos, cocoa0, 3);
        }
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DefaultDispenseItemBehavior shearsBehavior = new DefaultDispenseItemBehavior(){

                protected ItemStack execute(BlockSource source, ItemStack stack) {
                    int age;
                    ServerLevel level = source.level();
                    Direction dir = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                    BlockPos targetPos = source.pos().relative(dir);
                    BlockState state = level.getBlockState(targetPos);
                    Block block = state.getBlock();
                    if (!(level instanceof ServerLevel)) {
                        return super.execute(source, stack);
                    }
                    ServerLevel server = level;
                    if (block == Blocks.MELON) {
                        server.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 3);
                        if (((Boolean)Config.WHOLE_MELON_DROP.get()).booleanValue()) {
                            Block.popResource((Level)server, (BlockPos)targetPos, (ItemStack)new ItemStack((ItemLike)Items.MELON));
                        } else {
                            List<ItemStack> drops = Block.getDrops((BlockState)state, (ServerLevel)server, (BlockPos)targetPos, null, null, (ItemStack)ItemStack.EMPTY);
                            if (drops.isEmpty()) {
                                int count = 3 + server.random.nextInt(5);
                                drops = List.of(new ItemStack((ItemLike)Items.MELON_SLICE, count));
                            }
                            for (ItemStack drop : drops) {
                                if (drop.isEmpty()) continue;
                                Block.popResource((Level)server, (BlockPos)targetPos, (ItemStack)drop);
                            }
                        }
                        stack.hurtAndBreak(1, server, null, null);
                        return stack;
                    }
                    if (block == Blocks.PUMPKIN) {
                        server.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 3);
                        Block.popResource((Level)server, (BlockPos)targetPos, (ItemStack)new ItemStack((ItemLike)Items.PUMPKIN));
                        stack.hurtAndBreak(1, server, null, null);
                        return stack;
                    }
                    if (block == Blocks.SWEET_BERRY_BUSH && state.hasProperty((Property)BlockStateProperties.AGE_3) && (age = ((Integer)state.getValue((Property)BlockStateProperties.AGE_3)).intValue()) >= 1 && age <= 3) {
                        int min;
                        int count = min + server.random.nextInt((switch (age) {
                            case 1 -> {
                                min = 1;
                                yield 1;
                            }
                            case 2 -> {
                                min = 1;
                                yield 2;
                            }
                            default -> {
                                min = 2;
                                yield 3;
                            }
                        }) - min + 1);
                        Block.popResource((Level)server, (BlockPos)targetPos, (ItemStack)new ItemStack((ItemLike)Items.SWEET_BERRIES, count));
                        server.setBlock(targetPos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)), 3);
                        stack.hurtAndBreak(1, server, null, null);
                        return stack;
                    }
                    return super.execute(source, stack);
                }
            };
            DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)shearsBehavior);
        });
    }

    private static boolean isWhitelistedBlock(Block block) {
        if (block == Blocks.WHEAT) {
            return (Boolean)Config.ALLOW_WHEAT.get();
        }
        if (block == Blocks.CARROTS) {
            return (Boolean)Config.ALLOW_CARROTS.get();
        }
        if (block == Blocks.POTATOES) {
            return (Boolean)Config.ALLOW_POTATOES.get();
        }
        if (block == Blocks.BEETROOTS) {
            return (Boolean)Config.ALLOW_BEETROOTS.get();
        }
        if (block == Blocks.TORCHFLOWER_CROP || block == Blocks.TORCHFLOWER) {
            return (Boolean)Config.ALLOW_TORCHFLOWER.get();
        }
        if (block == Blocks.NETHER_WART) {
            return (Boolean)Config.ALLOW_NETHER_WART.get();
        }
        if (block == Blocks.COCOA) {
            return (Boolean)Config.ALLOW_COCOA.get();
        }
        return false;
    }

    private static boolean heldMatchesBlock(ItemStack stack, Block block) {
        if (block == Blocks.WHEAT) {
            return stack.is(Items.WHEAT_SEEDS);
        }
        if (block == Blocks.CARROTS) {
            return stack.is(Items.CARROT);
        }
        if (block == Blocks.POTATOES) {
            return stack.is(Items.POTATO);
        }
        if (block == Blocks.BEETROOTS) {
            return stack.is(Items.BEETROOT_SEEDS);
        }
        if (block == Blocks.TORCHFLOWER || block == Blocks.TORCHFLOWER_CROP) {
            return stack.is(Items.TORCHFLOWER_SEEDS);
        }
        if (block == Blocks.NETHER_WART) {
            return stack.is(Items.NETHER_WART);
        }
        if (block == Blocks.COCOA) {
            return stack.is(Items.COCOA_BEANS);
        }
        return false;
    }

    private static boolean isMature(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof CropBlock) {
            CropBlock crop = (CropBlock)b;
            return crop.isMaxAge(state);
        }
        if (b == Blocks.TORCHFLOWER) {
            return true;
        }
        if (b == Blocks.NETHER_WART) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_3) == 3;
        }
        if (b == Blocks.COCOA) {
            return (Integer)state.getValue((Property)BlockStateProperties.AGE_2) == 2;
        }
        return false;
    }

    private static Block resolveTargetReplantBlock(Block block) {
        if (block instanceof CropBlock) {
            return block;
        }
        if (block == Blocks.TORCHFLOWER) {
            return Blocks.TORCHFLOWER_CROP;
        }
        if (block == Blocks.NETHER_WART) {
            return Blocks.NETHER_WART;
        }
        if (block == Blocks.COCOA) {
            return Blocks.COCOA;
        }
        return Blocks.AIR;
    }

    private static boolean isValidCocoaSupport(Block b) {
        return b == Blocks.JUNGLE_LOG || b == Blocks.STRIPPED_JUNGLE_LOG || b == Blocks.JUNGLE_WOOD || b == Blocks.STRIPPED_JUNGLE_WOOD;
    }
}

