/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import space.atmo.vortex.VortexTracker;

public class VortexCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode modUsageCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vortex").requires(source -> source.hasPermission(2))).executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"summary").executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"clear").executes(context -> {
            VortexTracker.clearAllData();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Vortex: All collected usage data has been cleared."), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"vx").redirect((CommandNode)modUsageCommand));
    }

    private static int displayMostUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String topMods = data.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Most Used " + type + " ---\n" + topMods)), false);
        return 1;
    }

    private static int displayLeastUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String leastMods = data.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).sorted(Map.Entry.comparingByValue()).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        if (leastMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("Vortex: All " + type + " mods have significant usage, or no usage at all (after filtering for > 0 usage).")), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Least Used " + type + " (with some usage) ---\n" + leastMods)), false);
        return 1;
    }

    private static int displayAllSummaries(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"--- Vortex: Comprehensive Mod Usage Summary ---"), false);
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        VortexCommands.displayLeastUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        VortexCommands.displayLeastUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        return 1;
    }
}

