/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import space.atmo.vortex.VortexTracker;

@EventBusSubscriber(modid="vortex")
public class DataExporter {
    private static final String BASE_FILE_NAME = "vtx_usage_data";
    private static final String FILE_EXTENSION = ".csv";
    private static final String CONFIG_SUB_DIR = "vortex";

    public static void exportCommand(MinecraftServer server) {
        Path configDir = server.getServerDirectory().resolve("config").resolve(CONFIG_SUB_DIR);
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                System.out.println("Vortex: Created config directory: " + String.valueOf(configDir.toAbsolutePath()));
            }
            catch (IOException e) {
                System.err.println("Vortex: Failed to create config directory for mod usage data: " + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        String dateTimeString = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd.HH-mm"));
        String fileNameWithDate = "vtx_usage_data_" + dateTimeString + FILE_EXTENSION;
        Path outputFile = configDir.resolve(fileNameWithDate);
        try (FileWriter writer = new FileWriter(outputFile.toFile());){
            writer.append("Category,ModID,Count\n");
            DataExporter.writeMapToCSV(writer, VortexTracker.blockRightClickCounts, "BlockRightClick");
            DataExporter.writeMapToCSV(writer, VortexTracker.itemRightClickCounts, "ItemRightClick");
            DataExporter.writeMapToCSV(writer, VortexTracker.recipeCraftCounts, "CraftingOutput");
            DataExporter.writeMapToCSV(writer, VortexTracker.entityDamageCounts, "EntityDamage");
            System.out.println("Vortex: Mod usage data successfully saved to: " + String.valueOf(outputFile.toAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println("Vortex: Error saving mod usage data to CSV: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppingEvent event) {
        DataExporter.exportCommand(event.getServer());
    }

    private static void writeMapToCSV(FileWriter writer, Map<String, Integer> map, String category) throws IOException {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            writer.append(category).append(",").append(entry.getKey()).append(",").append(String.valueOf(entry.getValue())).append("\n");
        }
    }
}

