/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import space.atmo.vortex.VortexTracker;

@EventBusSubscriber(modid="vortex")
public class VortexEventHandler {
    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        String modId;
        if (event.getLevel().isClientSide) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockState blockState = event.getLevel().getBlockState(event.getPos());
        ResourceLocation blockRegistryName = event.getLevel().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)blockState.getBlock());
        if (blockRegistryName != null && !"minecraft".equals(modId = blockRegistryName.getNamespace())) {
            VortexTracker.incrementCount(VortexTracker.blockRightClickCounts, modId);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        String modId;
        if (event.getLevel().isClientSide) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        ResourceLocation itemRegistryName = event.getLevel().registryAccess().registryOrThrow(Registries.ITEM).getKey((Object)itemStack.getItem());
        if (itemRegistryName != null && !"minecraft".equals(modId = itemRegistryName.getNamespace())) {
            VortexTracker.incrementCount(VortexTracker.itemRightClickCounts, modId);
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        String modId;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        ItemStack craftedItem = event.getCrafting();
        ResourceLocation itemRegistryName = event.getEntity().level().registryAccess().registryOrThrow(Registries.ITEM).getKey((Object)craftedItem.getItem());
        if (itemRegistryName != null && !"minecraft".equals(modId = itemRegistryName.getNamespace())) {
            VortexTracker.incrementCount(VortexTracker.recipeCraftCounts, modId);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        String modId;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (!(damageSource.getEntity() instanceof ServerPlayer)) {
            return;
        }
        LivingEntity damagedEntity = event.getEntity();
        EntityType entityType = damagedEntity.getType();
        ResourceLocation entityRegistryName = event.getEntity().level().registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getKey((Object)entityType);
        if (entityRegistryName != null && !"minecraft".equals(modId = entityRegistryName.getNamespace())) {
            VortexTracker.incrementCount(VortexTracker.entityDamageCounts, modId);
        }
    }
}

