/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModList;
import space.atmo.vortex.DataExporter;
import space.atmo.vortex.VortexTracker;

public class VortexCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode modUsageCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vortex").requires(source -> source.hasPermission(2))).executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"summary").executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"clear").executes(context -> {
            VortexTracker.clearAllData();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Vortex: All collected usage data has been cleared."), true);
            return 1;
        }))).then(Commands.literal((String)"help").executes(context -> VortexCommands.displayHelpMessage((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"export").executes(context -> VortexCommands.exportDataCommand((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"unused").executes(context -> VortexCommands.getUnusedModsCommand((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"dataviewer").executes(context -> VortexCommands.exportToDataViewer((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vx").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).redirect((CommandNode)modUsageCommand));
    }

    private static int displayMostUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String topMods = data.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Most Used " + type + " ---\n" + topMods)), false);
        return 1;
    }

    private static int displayLeastUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String leastMods = data.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).sorted(Map.Entry.comparingByValue()).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        if (leastMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("Vortex: All " + type + " mods have significant usage, or no usage at all (after filtering for > 0 usage).")), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Least Used " + type + " (with some usage) ---\n" + leastMods)), false);
        return 1;
    }

    private static int displayAllSummaries(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"--- Vortex: Comprehensive Mod Usage Summary ---"), false);
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        VortexCommands.displayLeastUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        VortexCommands.displayLeastUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        return 1;
    }

    private static int displayHelpMessage(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"--- Vortex Mod Help ---"), false);
        source.sendSuccess(() -> Component.literal((String)"Vortex helps server administrators understand and optimize their modded servers."), false);
        source.sendSuccess(() -> Component.literal((String)"Available Commands:"), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx summary: Same as /vx"), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx clear: Resets all in-memory usage statistics."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx export: Exports current tracking data to a csv file in your config directory."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx unused: Lists mods with no tracked interactions."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx help: Displays this help message."), false);
        return 1;
    }

    private static int exportDataCommand(CommandSourceStack source) {
        DataExporter.exportCommand(source.getServer());
        source.sendSuccess(() -> Component.literal((String)"Vortex data exported to content directory."), false);
        return 1;
    }

    private static int getUnusedModsCommand(CommandSourceStack source) {
        Set<String> allInstalledModIds = ModList.get().getMods().stream().map(mod -> mod.getModId()).collect(Collectors.toSet());
        allInstalledModIds.remove("minecraft");
        allInstalledModIds.remove("vortex");
        allInstalledModIds.remove("neoforge");
        Set<String> unusedMods = VortexTracker.getUnusedModIds(allInstalledModIds);
        if (unusedMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"Vortex: No unused mods found."), false);
        } else {
            String modList = String.join((CharSequence)",", unusedMods);
            source.sendSuccess(() -> Component.literal((String)("Vortex: Unused mods: " + modList)), false);
        }
        return 1;
    }

    private static int exportToDataViewer(CommandSourceStack source) {
        HashMap<String, Map<String, Integer>> dataByCategory = new HashMap<String, Map<String, Integer>>();
        dataByCategory.put("Block Right Clicks", VortexTracker.blockRightClickCounts);
        dataByCategory.put("Item Right Clicks", VortexTracker.itemRightClickCounts);
        dataByCategory.put("Recipe Crafts", VortexTracker.recipeCraftCounts);
        dataByCategory.put("Entity Damage", VortexTracker.entityDamageCounts);
        dataByCategory.put("Chunks Generated", VortexTracker.chunkGenerationCounts);
        dataByCategory.put("Command Interactions", VortexTracker.commandUsageCounts);
        HashMap<String, ModInteractionDetails> dataByMod = new HashMap<String, ModInteractionDetails>();
        for (Map.Entry categoryEntry : dataByCategory.entrySet()) {
            String categoryName = (String)categoryEntry.getKey();
            Map categoryData = (Map)categoryEntry.getValue();
            if (categoryData == null || categoryData.isEmpty()) continue;
            for (Map.Entry modEntry : categoryData.entrySet()) {
                String modId = (String)modEntry.getKey();
                int countInThisCategory = (Integer)modEntry.getValue();
                ModInteractionDetails modDetails = dataByMod.computeIfAbsent(modId, k -> new ModInteractionDetails());
                modDetails.totalInteractions += countInThisCategory;
                modDetails.interactionBreakdown.put(categoryName, countInThisCategory);
            }
        }
        String jsonPayload = new Gson().toJson(dataByMod);
        String vercelApiUrl = "https://vortex-dataview.vercel.app/api/submit";
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(vercelApiUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
        source.sendSuccess(() -> Component.literal((String)"Vortex: Uploading data..."), false);
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                return (String)response.body();
            }
            throw new RuntimeException("Failed to upload report. Server responded with " + response.statusCode() + ": " + (String)response.body());
        })).thenAccept(responseBody -> {
            try {
                Map responseMap = (Map)new Gson().fromJson(responseBody, Map.class);
                String reportId = (String)responseMap.get("id");
                if (reportId == null || reportId.isEmpty()) {
                    throw new RuntimeException("Vercel API did not return a report ID.");
                }
                String finalUrl = "https://vortex-dataview.vercel.app/?id=" + reportId;
                MutableComponent linkComponent = Component.literal((String)finalUrl).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, finalUrl)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view report"))).withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)));
                source.sendSuccess(() -> VortexCommands.lambda$exportToDataViewer$38((Component)linkComponent), true);
            }
            catch (Exception e) {
                source.sendFailure((Component)Component.literal((String)("Vortex: Error processing response from Vercel: " + e.getMessage())));
                System.err.println("Vortex: Error parsing Vercel response: " + responseBody + " | Exception: " + String.valueOf(e));
            }
        })).exceptionally(e -> {
            source.sendFailure((Component)Component.literal((String)("Vortex: Failed to generate web report. Check server console. " + e.getMessage())));
            System.err.println("Vortex: Failed to send data to Vercel: " + String.valueOf(e));
            return null;
        });
        return 1;
    }

    private static /* synthetic */ Component lambda$exportToDataViewer$38(Component linkComponent) {
        return Component.literal((String)"Vortex Report Link: ").append(linkComponent);
    }

    public static class ModInteractionDetails {
        public int totalInteractions = 0;
        public Map<String, Integer> interactionBreakdown = new HashMap<String, Integer>();
    }
}

