/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import space.atmo.vortex.DataExporter;
import space.atmo.vortex.VortexTracker;

public class VortexCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode modUsageCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vortex").requires(source -> source.hasPermission(2))).executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"summary").executes(context -> VortexCommands.displayAllSummaries((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"clear").executes(context -> {
            VortexTracker.clearAllData();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Vortex: All collected usage data has been cleared."), true);
            return 1;
        }))).then(Commands.literal((String)"help").executes(context -> VortexCommands.displayHelpMessage((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"export").executes(context -> VortexCommands.exportDataCommand((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"unused").executes(context -> VortexCommands.getUnusedModsCommand((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vx").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).redirect((CommandNode)modUsageCommand));
    }

    private static int displayMostUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String topMods = data.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Most Used " + type + " ---\n" + topMods)), false);
        return 1;
    }

    private static int displayLeastUsed(CommandSourceStack source, Map<String, Integer> data, String type) {
        if (data.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("No " + type + " data collected yet.")), false);
            return 0;
        }
        String leastMods = data.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).sorted(Map.Entry.comparingByValue()).limit(10L).map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        if (leastMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("Vortex: All " + type + " mods have significant usage, or no usage at all (after filtering for > 0 usage).")), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("--- Vortex: Least Used " + type + " (with some usage) ---\n" + leastMods)), false);
        return 1;
    }

    private static int displayAllSummaries(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"--- Vortex: Comprehensive Mod Usage Summary ---"), false);
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.blockRightClickCounts, "Block Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        VortexCommands.displayLeastUsed(source, VortexTracker.itemRightClickCounts, "Item Right-Click");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        VortexCommands.displayLeastUsed(source, VortexTracker.recipeCraftCounts, "Crafting Output");
        source.sendSuccess(() -> Component.literal((String)"\n"), false);
        VortexCommands.displayMostUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        VortexCommands.displayLeastUsed(source, VortexTracker.entityDamageCounts, "Entity Damage");
        return 1;
    }

    private static int displayHelpMessage(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"--- Vortex Mod Help ---"), false);
        source.sendSuccess(() -> Component.literal((String)"Vortex helps server administrators understand and optimize their modded servers."), false);
        source.sendSuccess(() -> Component.literal((String)"Available Commands:"), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx summary: Same as /vx"), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx clear: Resets all in-memory usage statistics."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx export: Exports current tracking data to a csv file in your config directory."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx unused: Lists mods with no tracked interactions."), false);
        source.sendSuccess(() -> Component.literal((String)"- /vx help: Displays this help message."), false);
        return 1;
    }

    private static int exportDataCommand(CommandSourceStack source) {
        DataExporter.exportCommand(source.getServer());
        source.sendSuccess(() -> Component.literal((String)"Vortex data exported to content directory."), false);
        return 1;
    }

    private static int getUnusedModsCommand(CommandSourceStack source) {
        Set<String> allInstalledModIds = ModList.get().getMods().stream().map(mod -> mod.getModId()).collect(Collectors.toSet());
        allInstalledModIds.remove("minecraft");
        allInstalledModIds.remove("vortex");
        allInstalledModIds.remove("neoforge");
        Set<String> unusedMods = VortexTracker.getUnusedModIds(allInstalledModIds);
        if (unusedMods.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"Vortex: No unused mods found."), false);
        } else {
            String modList = String.join((CharSequence)",", unusedMods);
            source.sendSuccess(() -> Component.literal((String)("Vortex: Unused mods: " + modList)), false);
        }
        return 1;
    }
}

