/*
 * Decompiled with CFR 0.152.
 */
package space.atmo.vortex;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VortexTracker {
    public static final Map<String, Integer> blockRightClickCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> itemRightClickCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> recipeCraftCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> entityDamageCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> chunkGenerationCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> commandUsageCounts = new HashMap<String, Integer>();

    public static synchronized void incrementCount(Map<String, Integer> map, String modId) {
        map.put(modId, map.getOrDefault(modId, 0) + 1);
    }

    public static synchronized void clearAllData() {
        blockRightClickCounts.clear();
        itemRightClickCounts.clear();
        recipeCraftCounts.clear();
        entityDamageCounts.clear();
        chunkGenerationCounts.clear();
        commandUsageCounts.clear();
        System.out.println("Vortex: All collected usage data has been cleared.");
    }

    public static synchronized Set<String> getInteractedModIds() {
        HashSet<String> interactedMods = new HashSet<String>();
        interactedMods.addAll(blockRightClickCounts.keySet());
        interactedMods.addAll(itemRightClickCounts.keySet());
        interactedMods.addAll(recipeCraftCounts.keySet());
        interactedMods.addAll(entityDamageCounts.keySet());
        interactedMods.addAll(chunkGenerationCounts.keySet());
        interactedMods.addAll(commandUsageCounts.keySet());
        return interactedMods;
    }

    public static synchronized Set<String> getUnusedModIds(Set<String> allinstalledModIds) {
        if (allinstalledModIds == null) {
            System.err.println("Vortex:allInstalledModIds cannot be null.");
            return Collections.emptySet();
        }
        Set<String> interactedModIds = VortexTracker.getInteractedModIds();
        HashSet<String> unusedModIds = new HashSet<String>(allinstalledModIds);
        unusedModIds.removeAll(interactedModIds);
        return unusedModIds;
    }
}

