/*
 * Decompiled with CFR 0.152.
 */
package com.restonic4.fancyweather.utils;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3922;

public class WeatherHelper {
    private static final class_2338.class_2339 skyCacheBlockPos = new class_2338.class_2339();
    public static final int CAMPFIRE_POS_PLUS_X = 1;
    public static final int CAMPFIRE_POS_MINUS_X = 2;
    public static final int CAMPFIRE_POS_PLUS_Z = 4;
    public static final int CAMPFIRE_POS_MINUS_Z = 8;
    private static final class_2338.class_2339 spreadCacheBlockPos = new class_2338.class_2339();

    public static boolean isRainingOrThundering(class_3218 level) {
        return level.method_8419() || level.method_8546();
    }

    public static boolean canRainingAtPosition(class_3218 level, class_2338 pos) {
        class_1959 biome = (class_1959)level.method_23753(pos).comp_349();
        return biome.method_48163();
    }

    public static boolean hasSkyVisibility(class_3218 level, class_2338 blockPos) {
        return WeatherHelper.hasSkyVisibility(level, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static boolean hasSkyVisibility(class_3218 level, int x, int y, int z) {
        skyCacheBlockPos.method_10103(x, y, z);
        int skyLight = level.method_22336().method_15562(class_1944.field_9284).method_15543((class_2338)skyCacheBlockPos);
        return skyLight >= level.method_8315();
    }

    public static boolean isCloseEnoughToRain(class_3218 level, class_2338 blockPos) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        if (!WeatherHelper.hasSkyVisibility(level, blockPos)) {
            return false;
        }
        int count = 0;
        if (WeatherHelper.hasSkyVisibility(level, x + 1, y, z) && ++count >= 2) {
            return true;
        }
        if (WeatherHelper.hasSkyVisibility(level, x - 1, y, z) && ++count >= 2) {
            return true;
        }
        if (WeatherHelper.hasSkyVisibility(level, x, y, z + 1) && ++count >= 2) {
            return true;
        }
        return WeatherHelper.hasSkyVisibility(level, x, y, z - 1) && ++count >= 2;
    }

    public static int getNearbyCampfiresMask(class_3218 level, class_2338 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int mask = 0;
        spreadCacheBlockPos.method_10103(x + 1, y, z);
        class_2680 state = level.method_8320((class_2338)spreadCacheBlockPos);
        if (state.method_26204() instanceof class_3922 && !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            mask |= 1;
        }
        spreadCacheBlockPos.method_10103(x - 1, y, z);
        state = level.method_8320((class_2338)spreadCacheBlockPos);
        if (state.method_26204() instanceof class_3922 && !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            mask |= 2;
        }
        spreadCacheBlockPos.method_10103(x, y, z + 1);
        state = level.method_8320((class_2338)spreadCacheBlockPos);
        if (state.method_26204() instanceof class_3922 && !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            mask |= 4;
        }
        spreadCacheBlockPos.method_10103(x, y, z - 1);
        state = level.method_8320((class_2338)spreadCacheBlockPos);
        if (state.method_26204() instanceof class_3922 && !((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            mask |= 8;
        }
        return mask;
    }

    public static class_2338 getRandomCampfirePos(int mask, class_2338.class_2339 target) {
        if (mask == 0) {
            return null;
        }
        int count = Integer.bitCount(mask);
        if (count == 0) {
            return null;
        }
        int targetIndex = ThreadLocalRandom.current().nextInt(count);
        int index = 0;
        if ((mask & 1) != 0 && index++ == targetIndex) {
            target.method_10103(target.method_10263() + 1, target.method_10264(), target.method_10260());
            return target;
        }
        if ((mask & 2) != 0 && index++ == targetIndex) {
            target.method_10103(target.method_10263() - 1, target.method_10264(), target.method_10260());
            return target;
        }
        if ((mask & 4) != 0 && index++ == targetIndex) {
            target.method_10103(target.method_10263(), target.method_10264(), target.method_10260() + 1);
            return target;
        }
        if ((mask & 8) != 0 && index++ == targetIndex) {
            target.method_10103(target.method_10263(), target.method_10264(), target.method_10260() - 1);
            return target;
        }
        return null;
    }
}

