/*
 * Decompiled with CFR 0.152.
 */
package com.restonic4.fancyweather.mixin;

import com.restonic4.fancyweather.config.FancyWeatherMidnightConfig;
import com.restonic4.fancyweather.utils.RandomHelper;
import com.restonic4.fancyweather.utils.WeatherHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class CampfireMixin {
    @Unique
    private static int fancyWeather$tickRainCountdown = 0;
    @Unique
    private static int fancyWeather$tickSpreadCountdown = 0;
    @Unique
    private static BlockPos.MutableBlockPos fancyWeather$cacheSpreadBlockPos = new BlockPos.MutableBlockPos();

    @Inject(method={"cookTick"}, at={@At(value="TAIL")})
    private static void rainTick(Level level, BlockPos blockPos, BlockState blockState, CampfireBlockEntity campfireBlockEntity, CallbackInfo ci) {
        if (!FancyWeatherMidnightConfig.enableRainShouldExtinguishCampfires) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (WeatherHelper.isRainingOrThundering(serverLevel) && WeatherHelper.canRainingAtPosition(serverLevel, blockPos)) {
            if (fancyWeather$tickRainCountdown <= 0) {
                fancyWeather$tickRainCountdown = RandomHelper.getRandomInt(FancyWeatherMidnightConfig.campfireRainLookupMinTickRange, FancyWeatherMidnightConfig.campfireRainLookupMaxTickRange);
                if (WeatherHelper.isCloseEnoughToRain(serverLevel, blockPos)) {
                    CampfireBlock.dowse(null, (LevelAccessor)level, (BlockPos)blockPos, (BlockState)blockState);
                    BlockState newState = (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.setBlock(blockPos, newState, 11);
                    level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            }
            --fancyWeather$tickRainCountdown;
        }
    }

    @Inject(method={"cookTick"}, at={@At(value="TAIL")})
    private static void spreadTick(Level level, BlockPos blockPos, BlockState blockState, CampfireBlockEntity campfireBlockEntity, CallbackInfo ci) {
        if (!FancyWeatherMidnightConfig.enableCampfireFireSpread) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int neighborCampfiresMask = WeatherHelper.getNearbyCampfiresMask(serverLevel, blockPos);
        if (neighborCampfiresMask == 0) {
            return;
        }
        if (fancyWeather$tickSpreadCountdown <= 0) {
            fancyWeather$tickSpreadCountdown = RandomHelper.getRandomInt(FancyWeatherMidnightConfig.campfireSpreadLookupMinTickRange, FancyWeatherMidnightConfig.campfireSpreadLookupMaxTickRange);
            fancyWeather$cacheSpreadBlockPos.set((Vec3i)blockPos);
            BlockPos neighborCampfire = WeatherHelper.getRandomCampfirePos(neighborCampfiresMask, fancyWeather$cacheSpreadBlockPos);
            if (neighborCampfire == null) {
                return;
            }
            BlockState neighborBlockstate = serverLevel.getBlockState(neighborCampfire);
            BlockState newState = (BlockState)neighborBlockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true));
            serverLevel.setBlock(neighborCampfire, newState, 11);
            serverLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, neighborCampfire);
            serverLevel.playSound(null, neighborCampfire, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        --fancyWeather$tickSpreadCountdown;
    }
}

