/*
 * Decompiled with CFR 0.152.
 */
package com.restonic4.fancyweather.utils;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeatherHelper {
    private static final BlockPos.MutableBlockPos skyCacheBlockPos = new BlockPos.MutableBlockPos();
    public static final int CAMPFIRE_POS_PLUS_X = 1;
    public static final int CAMPFIRE_POS_MINUS_X = 2;
    public static final int CAMPFIRE_POS_PLUS_Z = 4;
    public static final int CAMPFIRE_POS_MINUS_Z = 8;
    private static final BlockPos.MutableBlockPos spreadCacheBlockPos = new BlockPos.MutableBlockPos();
    private static final Set<Class<?>> CROP_BLOCKS = Set.of(CropBlock.class, SaplingBlock.class, BambooStalkBlock.class, BambooSaplingBlock.class, SweetBerryBushBlock.class, StemBlock.class, CocoaBlock.class, SugarCaneBlock.class, MossBlock.class);

    public static boolean isRainingOrThundering(ServerLevel level) {
        return level.isRaining() || level.isThundering();
    }

    public static boolean canRainingAtPosition(ServerLevel level, BlockPos pos) {
        Biome biome = (Biome)level.getBiome(pos).value();
        return biome.hasPrecipitation();
    }

    public static boolean hasSkyVisibility(ServerLevel level, BlockPos blockPos) {
        return WeatherHelper.hasSkyVisibility(level, blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public static boolean hasSkyVisibility(ServerLevel level, int x, int y, int z) {
        skyCacheBlockPos.set(x, y, z);
        int skyLight = level.getLightEngine().getLayerListener(LightLayer.SKY).getLightValue((BlockPos)skyCacheBlockPos);
        return skyLight >= level.getMaxLightLevel();
    }

    public static boolean isCloseEnoughToRain(ServerLevel level, BlockPos blockPos) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        if (!WeatherHelper.hasSkyVisibility(level, blockPos)) {
            return false;
        }
        int count = 0;
        if (WeatherHelper.hasSkyVisibility(level, x + 1, y, z) && ++count >= 2) {
            return true;
        }
        if (WeatherHelper.hasSkyVisibility(level, x - 1, y, z) && ++count >= 2) {
            return true;
        }
        if (WeatherHelper.hasSkyVisibility(level, x, y, z + 1) && ++count >= 2) {
            return true;
        }
        return WeatherHelper.hasSkyVisibility(level, x, y, z - 1) && ++count >= 2;
    }

    public static int getNearbyCampfiresMask(ServerLevel level, BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int mask = 0;
        spreadCacheBlockPos.set(x + 1, y, z);
        BlockState state = level.getBlockState((BlockPos)spreadCacheBlockPos);
        if (state.getBlock() instanceof CampfireBlock && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            mask |= 1;
        }
        spreadCacheBlockPos.set(x - 1, y, z);
        state = level.getBlockState((BlockPos)spreadCacheBlockPos);
        if (state.getBlock() instanceof CampfireBlock && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            mask |= 2;
        }
        spreadCacheBlockPos.set(x, y, z + 1);
        state = level.getBlockState((BlockPos)spreadCacheBlockPos);
        if (state.getBlock() instanceof CampfireBlock && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            mask |= 4;
        }
        spreadCacheBlockPos.set(x, y, z - 1);
        state = level.getBlockState((BlockPos)spreadCacheBlockPos);
        if (state.getBlock() instanceof CampfireBlock && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            mask |= 8;
        }
        return mask;
    }

    public static BlockPos getRandomCampfirePos(int mask, BlockPos.MutableBlockPos target) {
        if (mask == 0) {
            return null;
        }
        int count = Integer.bitCount(mask);
        if (count == 0) {
            return null;
        }
        int targetIndex = ThreadLocalRandom.current().nextInt(count);
        int index = 0;
        if ((mask & 1) != 0 && index++ == targetIndex) {
            target.set(target.getX() + 1, target.getY(), target.getZ());
            return target;
        }
        if ((mask & 2) != 0 && index++ == targetIndex) {
            target.set(target.getX() - 1, target.getY(), target.getZ());
            return target;
        }
        if ((mask & 4) != 0 && index++ == targetIndex) {
            target.set(target.getX(), target.getY(), target.getZ() + 1);
            return target;
        }
        if ((mask & 8) != 0 && index++ == targetIndex) {
            target.set(target.getX(), target.getY(), target.getZ() - 1);
            return target;
        }
        return null;
    }

    public static boolean isCropBlock(Block block) {
        return CROP_BLOCKS.stream().anyMatch(clazz -> clazz.isInstance(block));
    }
}

