/*
 * Decompiled with CFR 0.152.
 */
package com.restonic4.fancyweather.mixin;

import com.restonic4.fancyweather.Constants;
import com.restonic4.fancyweather.config.FancyWeatherMidnightConfig;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class SleepRainResetMixin {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V")})
    private void beforeSetDayTime(BooleanSupplier pHasTimeLeft, CallbackInfo ci) {
        if (!FancyWeatherMidnightConfig.enableImprovedBedRainSkip) {
            return;
        }
        ServerLevel self = (ServerLevel)this;
        long startingTicks = self.getLevelData().getDayTime();
        long newTicks = startingTicks + 24000L;
        newTicks -= newTicks % 24000L;
        long difference = newTicks - startingTicks;
        Constants.LOG.info("Difference: {}", (Object)difference);
        this.serverLevelData.setRainTime((int)((long)this.serverLevelData.getRainTime() - difference));
        this.serverLevelData.setThunderTime((int)((long)this.serverLevelData.getThunderTime() - difference));
        if (this.serverLevelData.getRainTime() <= 0) {
            this.serverLevelData.setRaining(false);
        }
        if (this.serverLevelData.getThunderTime() <= 0) {
            this.serverLevelData.setThundering(false);
        }
    }

    @Inject(method={"resetWeatherCycle"}, at={@At(value="HEAD")}, cancellable=true)
    public void resetWeatherCycle(CallbackInfo ci) {
        if (!FancyWeatherMidnightConfig.enableImprovedBedRainSkip) {
            return;
        }
        ci.cancel();
    }
}

