/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3802;
import net.minecraft.class_3934;
import net.minecraft.class_3979;
import net.minecraft.class_466;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_486;
import net.minecraft.class_4894;
import net.minecraft.class_490;
import net.minecraft.class_494;
import red.jackf.chesttracker.api.ChestTrackerPlugin;
import red.jackf.chesttracker.api.ClientBlockSource;
import red.jackf.chesttracker.api.EventPhases;
import red.jackf.chesttracker.api.gui.GetCustomName;
import red.jackf.chesttracker.api.gui.ScreenBlacklist;
import red.jackf.chesttracker.api.memory.CommonKeys;
import red.jackf.chesttracker.api.providers.InteractionTracker;
import red.jackf.chesttracker.api.providers.MemoryBuilder;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.api.providers.context.ScreenCloseContext;
import red.jackf.chesttracker.api.providers.defaults.DefaultProvider;
import red.jackf.chesttracker.api.providers.defaults.DefaultProviderCommandSent;
import red.jackf.chesttracker.api.providers.defaults.DefaultProviderMemoryLocation;
import red.jackf.chesttracker.api.providers.defaults.DefaultProviderScreenClose;
import red.jackf.chesttracker.api.providers.defaults.DefaultProviderScreenOpen;
import red.jackf.chesttracker.impl.compat.mods.ShareEnderChestIntegration;
import red.jackf.chesttracker.impl.compat.servers.hypixel.HypixelProvider;
import red.jackf.chesttracker.impl.gui.util.CTTitleOverrideDuck;
import red.jackf.jackfredlib.api.base.ResultHolder;
import red.jackf.whereisit.api.search.ConnectedBlocksGrabber;

@Environment(value=EnvType.CLIENT)
public class DefaultChestTrackerPlugin
implements ChestTrackerPlugin {
    private final AtomicBoolean fromEnderChestCommand = new AtomicBoolean(false);

    @Override
    public void load() {
        GetCustomName.EVENT.register(EventPhases.FALLBACK_PHASE, screen -> {
            class_2561 title = ((CTTitleOverrideDuck)screen).chesttracker$getOriginalTitle();
            if (DefaultChestTrackerPlugin.containsTranslatable(title)) {
                return ResultHolder.pass();
            }
            return ResultHolder.value((Object)title);
        });
        ScreenBlacklist.add(class_3934.class, class_486.class, class_3802.class, class_4894.class, class_494.class, class_3979.class, class_466.class, class_479.class, class_490.class, class_481.class);
        ProviderUtils.registerProvider(DefaultProvider.INSTANCE);
        ProviderUtils.registerProvider(new HypixelProvider());
        Set<String> enderChestCommands = Set.of("ec", "ender", "enderchest", "echest");
        DefaultProviderCommandSent.EVENT.register((provider, command) -> this.fromEnderChestCommand.set(enderChestCommands.contains(command)));
        DefaultProviderScreenOpen.EVENT.register((provider, context) -> {
            if (this.fromEnderChestCommand.get()) {
                context.setMemoryLocation(MemoryLocation.override(CommonKeys.ENDER_CHEST_KEY, class_2338.field_10980));
                return true;
            }
            return false;
        });
        DefaultProviderScreenClose.EVENT.register(EventPhases.FALLBACK_PHASE, DefaultChestTrackerPlugin::defaultMemoryCreator);
        DefaultProviderScreenClose.EVENT.register(EventPhases.DEFAULT_PHASE, this::enderChestMemoryCreator);
        DefaultProviderMemoryLocation.EVENT.register(EventPhases.FALLBACK_PHASE, cbs -> {
            Optional<class_2960> current = ProviderUtils.getPlayersCurrentKey();
            if (current.isEmpty()) {
                return ResultHolder.pass();
            }
            if (!ProviderUtils.defaultShouldRemember(cbs)) {
                return ResultHolder.pass();
            }
            List connected = ConnectedBlocksGrabber.getConnected((class_1937)cbs.level(), (class_2680)cbs.blockState(), (class_2338)cbs.pos());
            class_2338 rootPos = (class_2338)connected.get(0);
            return ResultHolder.value((Object)MemoryLocation.inWorld(current.get(), rootPos));
        });
        DefaultProviderMemoryLocation.EVENT.register(EventPhases.DEFAULT_PHASE, cbs -> {
            if (cbs.blockState().method_26204() == class_2246.field_10443 || this.fromEnderChestCommand.get()) {
                return ResultHolder.value((Object)MemoryLocation.override(CommonKeys.ENDER_CHEST_KEY, class_2338.field_10980));
            }
            return ResultHolder.pass();
        });
        ShareEnderChestIntegration.setup();
    }

    private static boolean containsTranslatable(class_2561 component) {
        if (component.method_10851() instanceof class_2588) {
            return true;
        }
        for (class_2561 sibling : component.method_10855()) {
            if (!DefaultChestTrackerPlugin.containsTranslatable(sibling)) continue;
            return true;
        }
        return false;
    }

    private static ResultHolder<DefaultProviderScreenClose.Result> defaultMemoryCreator(ServerProvider provider, ScreenCloseContext context) {
        Optional<ClientBlockSource> cbs = InteractionTracker.INSTANCE.getLastBlockSource();
        if (cbs.isEmpty()) {
            return ResultHolder.pass();
        }
        Optional memoryLocation = InteractionTracker.INSTANCE.getLastBlockSource().flatMap(provider::getMemoryLocation);
        if (memoryLocation.isEmpty() || ((MemoryLocation)memoryLocation.get()).isOverride()) {
            return ResultHolder.pass();
        }
        List connectedBlocks = ConnectedBlocksGrabber.getConnected((class_1937)cbs.get().level(), (class_2680)cbs.get().blockState(), (class_2338)cbs.get().pos());
        class_2338 rootPos = (class_2338)connectedBlocks.get(0);
        return ResultHolder.value((Object)MemoryBuilder.create(context.getItems()).withCustomName(context.getCustomTitle().orElse(null)).inContainer(cbs.get().blockState().method_26204()).otherPositions(connectedBlocks.stream().filter(pos -> !pos.equals((Object)rootPos)).toList()).toResult(((MemoryLocation)memoryLocation.get()).memoryKey(), rootPos));
    }

    private ResultHolder<DefaultProviderScreenClose.Result> enderChestMemoryCreator(ServerProvider provider, ScreenCloseContext context) {
        if (!this.fromEnderChestCommand.getAndSet(false)) {
            Optional<ClientBlockSource> cbs = InteractionTracker.INSTANCE.getLastBlockSource();
            if (cbs.isEmpty()) {
                return ResultHolder.pass();
            }
            if (!cbs.get().blockState().method_27852(class_2246.field_10443)) {
                return ResultHolder.pass();
            }
        }
        return ResultHolder.value((Object)MemoryBuilder.create(context.getItemsWithEmpty()).inContainer(class_2246.field_10443).toResult(CommonKeys.ENDER_CHEST_KEY, class_2338.field_10980));
    }
}

