/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.screen;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.gui.screen.BaseUtilScreen;
import red.jackf.chesttracker.impl.gui.util.TextColours;
import red.jackf.chesttracker.impl.gui.widget.CustomEditBox;
import red.jackf.chesttracker.impl.gui.widget.TextWidget;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.chesttracker.impl.util.GuiUtil;
import red.jackf.chesttracker.impl.util.Strings;
import red.jackf.jackfredlib.client.api.gps.Coordinate;

@Environment(value=EnvType.CLIENT)
public class CreateMemoryBankScreen
extends BaseUtilScreen {
    private static final int CLOSE_BUTTON_SIZE = 12;
    private static final int CONTENT_TOP = 30;
    private final class_437 parent;
    private final Runnable afterBankLoaded;
    private String name = "";
    private String id;
    private CustomEditBox idEditBox = null;
    private CustomEditBox nameEditBox = null;
    private class_4185 loadButton;

    protected CreateMemoryBankScreen(@Nullable class_437 parent, Runnable afterBankLoaded) {
        super((class_2561)class_2561.method_43471((String)"chesttracker.gui.createMemoryBank"));
        this.parent = parent;
        this.afterBankLoaded = afterBankLoaded;
        this.id = this.getNextIdDefault();
    }

    private String getNextIdDefault() {
        String id;
        Collection<String> keys = Storage.getAllIds();
        int index = 1;
        while (keys.contains(id = this.makeUserId("custom" + index++))) {
        }
        return id;
    }

    private String makeUserId(String id) {
        return "user/" + Strings.sanitizeForPath(id);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_327 font = class_310.method_1551().field_1772;
        int workingWidth = this.menuWidth - 16;
        this.method_37063((class_364)GuiUtil.close(this.left + this.menuWidth - 17, this.top + 5, b -> this.method_25419()));
        int y = this.top + 30;
        class_5250 idLabel = class_2561.method_43471((String)"chesttracker.gui.id");
        this.method_37060(new TextWidget(this.left + 8, y, (class_2561)idLabel, TextColours.getLabelColour()));
        int n = this.left + 8 + font.method_27525((class_5348)idLabel) + 5;
        int n2 = workingWidth - 5 - font.method_27525((class_5348)idLabel);
        Objects.requireNonNull(font);
        this.idEditBox = (CustomEditBox)this.method_37063((class_364)new CustomEditBox(font, n, y - 2, n2, 9 + 3, this.idEditBox, class_5244.field_39003){

            public void method_25365(boolean focused) {
                String sanitized;
                super.method_25365(focused);
                if (!focused && !(sanitized = CreateMemoryBankScreen.this.sanitize(this.method_1882())).equals(this.method_1882())) {
                    this.method_1852(sanitized);
                }
            }
        });
        this.idEditBox.method_1852(this.id);
        this.idEditBox.method_1863(s -> {
            this.id = s;
            this.refreshValidity();
            this.refreshName();
        });
        class_5250 nameLabel = class_2561.method_43471((String)"mco.backup.entry.name");
        this.method_37060(new TextWidget(this.left + 8, y += 15, (class_2561)nameLabel, TextColours.getLabelColour()));
        int n3 = this.left + 8 + font.method_27525((class_5348)nameLabel) + 5;
        int n4 = workingWidth - 5 - font.method_27525((class_5348)nameLabel);
        Objects.requireNonNull(font);
        this.nameEditBox = (CustomEditBox)this.method_37063((class_364)new CustomEditBox(font, n3, y - 2, n4, 9 + 3, this.nameEditBox, class_5244.field_39003));
        this.nameEditBox.method_1852(this.name);
        this.nameEditBox.method_1863(s -> {
            this.name = s;
            this.refreshValidity();
            this.refreshName();
        });
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"chesttracker.gui.createMemoryBank.fillDefault"), this::loadDefault).method_46434(this.left + 8, y += 15, workingWidth, 20).method_46431());
        this.loadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_39003, this::createAndLoad).method_46434(this.left + 8, this.top + this.menuHeight - 20 - 8, workingWidth, 20).method_46431());
        this.refreshValidity();
        this.refreshName();
    }

    private String sanitize(String in) {
        in = in.trim();
        try {
            Path path = Path.of(in, new String[0]);
            ArrayList<String> builder = new ArrayList<String>();
            for (Path segment : path) {
                builder.add(Strings.sanitizeForPath(segment.toString()));
            }
            return String.join((CharSequence)"/", builder);
        }
        catch (InvalidPathException ex) {
            return Strings.sanitizeForPath(in);
        }
    }

    private void loadDefault(class_4185 button) {
        Optional coord = Coordinate.getCurrent();
        if (coord.isEmpty()) {
            return;
        }
        this.idEditBox.method_1852(((Coordinate)coord.get()).id());
        this.nameEditBox.method_1852(((Coordinate)coord.get()).userFriendlyName());
    }

    protected static String getNameFromId(String id) {
        return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{class_2561.method_43471((String)"generator.custom"), class_2561.method_43470((String)id)}).getString();
    }

    private void refreshName() {
        if (this.name.isEmpty()) {
            this.nameEditBox.method_47404((class_2561)class_2561.method_43470((String)CreateMemoryBankScreen.getNameFromId(this.id)));
            this.nameEditBox.method_1868(TextColours.getHintColour());
        } else {
            this.nameEditBox.method_47404(class_5244.field_39003);
            this.nameEditBox.method_1868(TextColours.getTextColour());
        }
    }

    private void refreshValidity() {
        if (Storage.exists(this.id)) {
            this.idEditBox.method_1868(TextColours.getErrorColour());
            this.loadButton.method_25355((class_2561)class_2561.method_43471((String)"chesttracker.gui.createMemoryBank.alreadyExists"));
            this.loadButton.field_22763 = false;
        } else if (this.id.isBlank()) {
            this.idEditBox.method_1868(TextColours.getErrorColour());
            this.loadButton.method_25355((class_2561)class_2561.method_43471((String)"chesttracker.gui.createMemoryBank.emptyId"));
            this.loadButton.field_22763 = false;
        } else {
            this.idEditBox.method_1868(TextColours.getTextColour());
            this.loadButton.method_25355((class_2561)class_2561.method_43471((String)"chesttracker.gui.createMemoryBank.createAndLoad"));
            this.loadButton.field_22763 = true;
        }
    }

    private void createAndLoad(class_4185 button) {
        this.id = this.sanitize(this.id);
        MemoryBankAccessImpl.INSTANCE.loadOrCreate(this.id, this.name.isEmpty() ? CreateMemoryBankScreen.getNameFromId(this.id) : this.name);
        this.afterBankLoaded.run();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }
}

