/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.screen;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.counting.StackMergeMode;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.screen.BaseUtilScreen;
import red.jackf.chesttracker.impl.gui.screen.CreateMemoryBankScreen;
import red.jackf.chesttracker.impl.gui.screen.EditMemoryKeysScreen;
import red.jackf.chesttracker.impl.gui.screen.MemoryBankView;
import red.jackf.chesttracker.impl.gui.util.TextColours;
import red.jackf.chesttracker.impl.gui.widget.CustomEditBox;
import red.jackf.chesttracker.impl.gui.widget.EnumSlider;
import red.jackf.chesttracker.impl.gui.widget.HoldToConfirmButton;
import red.jackf.chesttracker.impl.gui.widget.SteppedSlider;
import red.jackf.chesttracker.impl.gui.widget.StringSelectorWidget;
import red.jackf.chesttracker.impl.gui.widget.TextWidget;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.CompatibilitySettings;
import red.jackf.chesttracker.impl.memory.metadata.FilteringSettings;
import red.jackf.chesttracker.impl.memory.metadata.IntegritySettings;
import red.jackf.chesttracker.impl.memory.metadata.SearchSettings;
import red.jackf.chesttracker.impl.rendering.NameRenderMode;
import red.jackf.chesttracker.impl.storage.ConnectionSettings;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.chesttracker.impl.util.GuiUtil;
import red.jackf.chesttracker.impl.util.I18n;
import red.jackf.chesttracker.impl.util.Misc;
import red.jackf.jackfredlib.client.api.gps.Coordinate;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.client.WhereIsItClient;
import red.jackf.whereisit.client.render.Rendering;

@Environment(value=EnvType.CLIENT)
public class EditMemoryBankScreen
extends BaseUtilScreen {
    private static final int CLOSE_BUTTON_SIZE = 12;
    private static final int BUTTON_HEIGHT = 20;
    private static final int ID_TOP = 30;
    private static final int NAME_TOP = 45;
    private static final int SETTINGS_TOP = 60;
    private static final int SETTINGS_TAB_SELECTOR_WIDTH = 65;
    private static final int SETTINGS_MAX_COLUMNS = 2;
    private final boolean isCurrentLoaded;
    @Nullable
    private class_342 nameEditBox = null;
    private final class_437 parent;
    private final Runnable afterBankLoaded;
    private final MemoryBankView memoryBank;
    private final Multimap<SettingsTab, class_339> settingsMap = LinkedListMultimap.create();
    @Nullable
    private StringSelectorWidget<SettingsTab> settingsTabSelector;
    @Nullable
    private class_4185 pruneWithinRange;
    @Nullable
    private class_4185 pruneOutsideRange;
    private static int manageWorkingRange = 256;

    protected EditMemoryBankScreen(@Nullable class_437 parent, Runnable afterBankLoaded, String memoryBankId) {
        super((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank"));
        this.parent = parent;
        this.afterBankLoaded = afterBankLoaded;
        MemoryBankImpl memoryBank = Storage.load(memoryBankId).orElse(null);
        if (memoryBank == null) {
            this.method_25419();
            this.isCurrentLoaded = false;
            this.memoryBank = MemoryBankView.empty();
        } else {
            this.isCurrentLoaded = memoryBank == MemoryBankAccessImpl.INSTANCE.getLoadedInternal().orElse(null);
            this.memoryBank = MemoryBankView.of(memoryBank);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        class_327 font = class_310.method_1551().field_1772;
        boolean inGame = class_310.method_1551().field_1687 != null;
        this.method_37063((class_364)GuiUtil.close(this.left + this.menuWidth - 17, this.top + 5, b -> this.method_25419()));
        this.method_37060(new TextWidget(this.left + 8, this.top + 8, this.menuWidth - 8 - 10 - 12, Storage.getBackendLabel(this.memoryBank.id()), TextColours.getLabelColour(), TextWidget.Alignment.RIGHT));
        class_5250 idLabel = class_2561.method_43471((String)"chesttracker.gui.id");
        this.method_37060(new TextWidget(this.left + 8, this.top + 30, (class_2561)idLabel, TextColours.getLabelColour()));
        class_5250 bankIdText = class_2561.method_43470((String)this.memoryBank.id());
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.hideMemoryIds) {
            bankIdText = bankIdText.method_27692(class_124.field_1051);
        }
        this.method_37060(new TextWidget(this.left + 8 + font.method_27525((class_5348)idLabel) + 4, this.top + 30, (class_2561)bankIdText, TextColours.getLabelColour()));
        class_5250 nameLabel = class_2561.method_43471((String)"mco.backup.entry.name");
        this.method_37060(new TextWidget(this.left + 8, this.top + 45, (class_2561)nameLabel, TextColours.getLabelColour()));
        int n = this.left + 8 + font.method_27525((class_5348)nameLabel) + 5;
        int n2 = this.menuWidth - 16 - font.method_27525((class_5348)nameLabel) - 5;
        Objects.requireNonNull(font);
        this.nameEditBox = (class_342)this.method_37063((class_364)new CustomEditBox(font, n, this.top + 45 - 2, n2, 9 + 3, this.nameEditBox, class_5244.field_39003));
        this.nameEditBox.method_1880(80);
        this.nameEditBox.method_1863(s -> {
            if (s.isEmpty() && !((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.hideMemoryIds) {
                this.nameEditBox.method_47404((class_2561)class_2561.method_43470((String)CreateMemoryBankScreen.getNameFromId(this.memoryBank.id())));
                this.nameEditBox.method_1868(TextColours.getHintColour());
            } else {
                this.nameEditBox.method_47404(class_5244.field_39003);
                this.nameEditBox.method_1868(TextColours.getTextColour());
            }
            this.memoryBank.metadata().setName(s.isEmpty() ? null : s);
        });
        this.nameEditBox.method_1852(Optional.ofNullable(this.memoryBank.metadata().getName()).orElse(""));
        ArrayList bottomButtons = new ArrayList();
        ArrayList<RenderableThingGetter<class_364>> managementButtons = new ArrayList<RenderableThingGetter<class_364>>();
        managementButtons.add((x, y, width, height) -> new HoldToConfirmButton(x, y, width, height, (class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), 30L, this::delete));
        managementButtons.add((x, y, width, height) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryKeys"), this::openEditMemoryKeys).method_46434(x, y, width, height).method_46431());
        bottomButtons.add(managementButtons);
        ArrayList<RenderableThingGetter<class_364>> saveCreateLoadRow = new ArrayList<RenderableThingGetter<class_364>>();
        bottomButtons.add(saveCreateLoadRow);
        if (inGame && !this.isCurrentLoaded) {
            saveCreateLoadRow.add((x, y, width, height) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)"structure_block.mode.load"), this::load).method_46434(x, y, width, height).method_46431());
        }
        saveCreateLoadRow.add((x, y, width, height) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectWorld.edit.save"), this::save).method_46434(x, y, width, height).method_46431());
        if (inGame) {
            Optional coord = Coordinate.getCurrent();
            coord.map(coordinate -> ConnectionSettings.get(coordinate.id())).ifPresent(connectionSettings -> saveCreateLoadRow.add((x, y, width, height) -> {
                if (connectionSettings.memoryBankIdOverride().orElse(((Coordinate)coord.get()).id()).equals(this.memoryBank.id())) {
                    class_4185 defaultButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.alreadyDefault"), b -> {}).method_46434(x, y, width, height).method_46431();
                    defaultButton.field_22763 = false;
                    return defaultButton;
                }
                return class_4185.method_46430((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.markDefault"), this::markDefault).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.markDefault.tooltip"))).method_46434(x, y, width, height).method_46431();
            }));
        }
        this.addBottomButtons(bottomButtons);
        this.setupSettings(this.menuHeight - 60 - 2 - 28 * bottomButtons.size());
    }

    private void openEditMemoryKeys(class_4185 ignored) {
        class_310.method_1551().method_1507((class_437)new EditMemoryKeysScreen(this, this.memoryBank));
    }

    private void setupSettings(int height) {
        this.settingsTabSelector = (StringSelectorWidget)this.method_37063((class_364)new StringSelectorWidget<SettingsTab>(this.left + 8, this.top + 60, 65, height, class_5244.field_39003, this::setSettingsTab));
        LinkedHashMap<SettingsTab, Object> selectorOptions = new LinkedHashMap<SettingsTab, Object>();
        selectorOptions.put(SettingsTab.COMPATIBILITY, class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility"));
        selectorOptions.put(SettingsTab.FILTERING, class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering"));
        selectorOptions.put(SettingsTab.INTEGRITY, class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity"));
        if (this.isCurrentLoaded) {
            selectorOptions.put(SettingsTab.MANAGE, class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.manage"));
        }
        selectorOptions.put(SettingsTab.SEARCH, class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search"));
        selectorOptions.put(SettingsTab.EMPTY, class_5244.field_39003);
        this.settingsTabSelector.setOptions(selectorOptions);
        this.setupCompatibilitySettings();
        this.setupFilteringSettings();
        this.setupIntegritySettings();
        if (this.isCurrentLoaded) {
            this.setupManagementSettings();
        }
        this.setupSearchSettings();
        this.addSetting((class_339)new class_7842(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43470((String)"^_^").method_27692(class_124.field_1067), this.field_22793).method_46438(0x4040FF), SettingsTab.EMPTY);
        this.setSettingsTab(SettingsTab.FILTERING);
    }

    private void setupCompatibilitySettings() {
        this.addSetting((class_339)class_5676.method_32606(mode -> mode.label).method_32618(mode -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode.tooltip").method_10852(class_5244.field_33849).method_10852(class_5244.field_33849).method_10852(mode.tooltip))).method_32624((Object[])CompatibilitySettings.NameFilterMode.values()).method_32619((Object)this.memoryBank.metadata().getCompatibilitySettings().nameFilterMode).method_32617(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameFilterMode"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getCompatibilitySettings().nameFilterMode = newValue;
        }), SettingsTab.COMPATIBILITY);
        this.addSetting((class_339)class_5676.method_32606(mode -> mode.label).method_32618(mode -> class_7919.method_47407((class_2561)mode.tooltip)).method_32624((Object[])NameRenderMode.values()).method_32619((Object)this.memoryBank.metadata().getCompatibilitySettings().nameRenderMode).method_32617(this.getSettingsX(0), this.getSettingsY(1), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.compatibility.nameRenderMode"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getCompatibilitySettings().nameRenderMode = newValue;
        }), SettingsTab.COMPATIBILITY);
    }

    private void setupFilteringSettings() {
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getFilteringSettings().manualMode).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.manualMode.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.manualMode"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getFilteringSettings().manualMode = newValue;
        }), SettingsTab.FILTERING);
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getFilteringSettings().onlyRememberNamed).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.onlyRemembedNamed.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(1), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.onlyRemembedNamed"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getFilteringSettings().onlyRememberNamed = newValue;
        }), SettingsTab.FILTERING);
        this.addSetting((class_339)class_5676.method_32606(remembered -> remembered.label).method_32616().method_32618(remembered -> class_7919.method_47407((class_2561)remembered.tooltip)).method_32624((Object[])FilteringSettings.RememberedContainers.values()).method_32619((Object)this.memoryBank.metadata().getFilteringSettings().rememberedContainers).method_32617(this.getSettingsX(1), this.getSettingsY(1), this.getSettingsWidth(1), 20, class_5244.field_39003, (cycleButton, remembered) -> {
            this.memoryBank.metadata().getFilteringSettings().rememberedContainers = remembered;
        }), SettingsTab.FILTERING);
        this.addSetting((class_339)class_5676.method_32606(remembered -> remembered.label).method_32624((Object[])FilteringSettings.AutoAddPlacedBlocks.values()).method_32619((Object)this.memoryBank.metadata().getFilteringSettings().autoAddPlacedBlocks).method_32617(this.getSettingsX(0), this.getSettingsY(2), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.autoAddPlacedBlocks"), (cycleButton, autoAdd) -> {
            this.memoryBank.metadata().getFilteringSettings().autoAddPlacedBlocks = autoAdd;
        }), SettingsTab.FILTERING);
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getFilteringSettings().rememberEnderChests).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.rememberEnderChests.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(3), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.filtering.rememberEnderChests"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getFilteringSettings().rememberEnderChests = newValue;
        }), SettingsTab.FILTERING);
    }

    private void setupIntegritySettings() {
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getIntegritySettings().preserveNamed).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.preserveNamed.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.preserveNamed"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getIntegritySettings().preserveNamed = newValue;
        }), SettingsTab.INTEGRITY);
        this.addSetting((class_339)class_5676.method_32606(mode -> mode.label).method_32624((Object[])IntegritySettings.LifetimeCountMode.values()).method_32619((Object)this.memoryBank.metadata().getIntegritySettings().lifetimeCountMode).method_32616().method_32617(this.getSettingsX(1), this.getSettingsY(0), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.lifetimeCountMode"), (cycleButton, countMode) -> {
            this.memoryBank.metadata().getIntegritySettings().lifetimeCountMode = countMode;
        }), SettingsTab.INTEGRITY);
        this.addSetting((class_339)new EnumSlider<IntegritySettings.MemoryLifetime>(this.getSettingsX(0), this.getSettingsY(1), this.getSettingsWidth(2), 20, IntegritySettings.MemoryLifetime.class, this.memoryBank.metadata().getIntegritySettings().memoryLifetime, lifetime -> lifetime.label){

            protected void method_25344() {
                EditMemoryBankScreen.this.memoryBank.metadata().getIntegritySettings().memoryLifetime = (IntegritySettings.MemoryLifetime)((Object)this.getSelected());
            }
        }, SettingsTab.INTEGRITY);
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getIntegritySettings().removeOnPlayerBlockBreak).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.blockBreak.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(2), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.blockBreak"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getIntegritySettings().removeOnPlayerBlockBreak = newValue;
        }), SettingsTab.INTEGRITY);
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getIntegritySettings().checkPeriodicallyForMissingBlocks).method_32618(b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.periodicCheck.tooltip"))).method_32617(this.getSettingsX(1), this.getSettingsY(2), this.getSettingsWidth(1), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.periodicCheck"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getIntegritySettings().checkPeriodicallyForMissingBlocks = newValue;
        }), SettingsTab.INTEGRITY);
    }

    private void setupManagementSettings() {
        this.pruneWithinRange = class_4185.method_46430((class_2561)class_5244.field_39003, b -> this.pruneWithinRange()).method_46434(this.getSettingsX(0), this.getSettingsY(1), this.getSettingsWidth(2), 20).method_46431();
        this.pruneOutsideRange = class_4185.method_46430((class_2561)class_5244.field_39003, b -> this.pruneOutsideRange()).method_46434(this.getSettingsX(0), this.getSettingsY(2), this.getSettingsWidth(2), 20).method_46431();
        this.addSetting((class_339)this.pruneWithinRange, SettingsTab.MANAGE);
        this.addSetting((class_339)this.pruneOutsideRange, SettingsTab.MANAGE);
        this.addSetting((class_339)new SteppedSlider<Integer>(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(2), 20, SearchSettings.SEARCH_RANGES_NO_INFINITE, Integer.valueOf(manageWorkingRange), range -> class_2561.method_43469((String)"chesttracker.gui.editMemoryBank.manage.workingRange", (Object[])new Object[]{I18n.blocks(range == Integer.MAX_VALUE ? class_2561.method_43471((String)"effect.duration.infinite") : range)})){

            protected void method_25344() {
                manageWorkingRange = (Integer)this.getSelected();
                EditMemoryBankScreen.this.refreshManagementButtons();
            }
        }, SettingsTab.MANAGE);
        this.addSetting((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.manage.highlightAll"), b -> this.highlightAll()).method_46434(this.getSettingsX(0), this.getSettingsY(3), this.getSettingsWidth(1), 20).method_46431(), SettingsTab.MANAGE);
        this.refreshManagementButtons();
    }

    private void highlightAll() {
        ProviderUtils.getPlayersCurrentKey().ifPresent(currentKey -> {
            MemoryKeyImpl currentMemories = this.memoryBank.getMemories((class_2960)currentKey);
            if (currentMemories == null) {
                return;
            }
            WhereIsItClient.closedScreenThisSearch = false;
            Rendering.resetSearchTime();
            WhereIsItClient.recieveResults(currentMemories.getMemories().entrySet().stream().map(e -> SearchResult.builder((class_2338)((class_2338)e.getKey())).name(((Memory)e.getValue()).renderName(), null).otherPositions(((Memory)e.getValue()).otherPositions()).build()).toList());
        });
    }

    private void refreshManagementButtons() {
        Pair<Set<class_2338>, Set<class_2338>> counts = this.partitionMemoriesInCurrentKey();
        if (this.pruneWithinRange != null) {
            this.pruneWithinRange.method_25355((class_2561)class_2561.method_43469((String)"chesttracker.gui.editMemoryBank.manage.deleteWithinRange", (Object[])new Object[]{manageWorkingRange, ((Set)counts.getFirst()).size()}));
        }
        if (this.pruneOutsideRange != null) {
            this.pruneOutsideRange.method_25355((class_2561)class_2561.method_43469((String)"chesttracker.gui.editMemoryBank.manage.deleteOutsideRange", (Object[])new Object[]{manageWorkingRange, ((Set)counts.getSecond()).size()}));
        }
    }

    private Pair<Set<class_2338>, Set<class_2338>> partitionMemoriesInCurrentKey() {
        Pair empty = Pair.of(Collections.emptySet(), Collections.emptySet());
        if (class_310.method_1551().field_1724 == null) {
            return empty;
        }
        class_2960 currentKey = ProviderUtils.getPlayersCurrentKey().orElse(null);
        if (currentKey == null) {
            return empty;
        }
        MemoryKeyImpl currentMemories = this.memoryBank.getMemories(currentKey);
        if (currentMemories == null) {
            return empty;
        }
        double squareRange = (double)manageWorkingRange * (double)manageWorkingRange;
        class_243 origin = class_310.method_1551().field_1724.method_33571();
        HashSet<class_2338> within = new HashSet<class_2338>();
        HashSet<class_2338> outside = new HashSet<class_2338>();
        for (class_2338 pos : currentMemories.getMemories().keySet()) {
            if (origin.method_1025(pos.method_46558()) < squareRange) {
                within.add(pos);
                continue;
            }
            outside.add(pos);
        }
        return Pair.of(within, outside);
    }

    private void pruneOutsideRange() {
        ProviderUtils.getPlayersCurrentKey().ifPresent(currentKey -> {
            Pair<Set<class_2338>, Set<class_2338>> counts = this.partitionMemoriesInCurrentKey();
            for (class_2338 pos : (Set)counts.getSecond()) {
                this.memoryBank.remove((class_2960)currentKey, pos);
            }
            this.refreshManagementButtons();
        });
    }

    private void pruneWithinRange() {
        ProviderUtils.getPlayersCurrentKey().ifPresent(currentKey -> {
            Pair<Set<class_2338>, Set<class_2338>> counts = this.partitionMemoriesInCurrentKey();
            for (class_2338 pos : (Set)counts.getFirst()) {
                this.memoryBank.remove((class_2960)currentKey, pos);
            }
            this.refreshManagementButtons();
        });
    }

    private void setupSearchSettings() {
        this.addSetting((class_339)Misc.let(new SteppedSlider<Integer>(this.getSettingsX(0), this.getSettingsY(0), this.getSettingsWidth(2), 20, SearchSettings.SEARCH_RANGES, Integer.valueOf(this.memoryBank.metadata().getSearchSettings().itemListRange), range -> class_2561.method_43469((String)"chesttracker.gui.editMemoryBank.search.itemListRange", (Object[])new Object[]{I18n.blocks(range == Integer.MAX_VALUE ? class_2561.method_43471((String)"effect.duration.infinite") : range)})){

            protected void method_25344() {
                EditMemoryBankScreen.this.memoryBank.metadata().getSearchSettings().itemListRange = (Integer)this.getSelected();
            }
        }, slider -> slider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search.itemListRange.tooltip")))), SettingsTab.SEARCH);
        this.addSetting((class_339)new SteppedSlider<Integer>(this.getSettingsX(0), this.getSettingsY(1), this.getSettingsWidth(2), 20, SearchSettings.SEARCH_RANGES, Integer.valueOf(this.memoryBank.metadata().getSearchSettings().searchRange), range -> class_2561.method_43469((String)"chesttracker.gui.editMemoryBank.search.searchRange", (Object[])new Object[]{I18n.blocks(range == Integer.MAX_VALUE ? class_2561.method_43471((String)"effect.duration.infinite") : range)})){

            protected void method_25344() {
                EditMemoryBankScreen.this.memoryBank.metadata().getSearchSettings().searchRange = (Integer)this.getSelected();
            }
        }, SettingsTab.SEARCH);
        this.addSetting((class_339)class_5676.method_32606(mode -> mode.label).method_32624((Object[])StackMergeMode.values()).method_32618(ignored -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search.stackMergeMode.tooltip"))).method_32619((Object)this.memoryBank.metadata().getSearchSettings().stackMergeMode).method_32617(this.getSettingsX(0), this.getSettingsY(2), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search.stackMergeMode"), (cycleButton, stackMergeMode) -> {
            this.memoryBank.metadata().getSearchSettings().stackMergeMode = stackMergeMode;
        }), SettingsTab.SEARCH);
        this.addSetting((class_339)class_5676.method_32613((boolean)this.memoryBank.metadata().getSearchSettings().unpackNested).method_32618(ignored -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search.unpackNested.tooltip"))).method_32617(this.getSettingsX(0), this.getSettingsY(3), this.getSettingsWidth(2), 20, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.search.unpackNested"), (cycleButton, newValue) -> {
            this.memoryBank.metadata().getSearchSettings().unpackNested = newValue;
        }), SettingsTab.SEARCH);
    }

    private void addSetting(class_339 widget, SettingsTab tab) {
        this.method_37063((class_364)widget);
        widget.field_22764 = false;
        this.settingsMap.put((Object)tab, (Object)widget);
    }

    private void setSettingsTab(SettingsTab tab) {
        if (this.settingsTabSelector != null) {
            this.settingsTabSelector.setHighlight(tab);
        }
        for (Map.Entry entry : this.settingsMap.entries()) {
            ((class_339)entry.getValue()).field_22764 = entry.getKey() == tab;
        }
    }

    private int getSingleSettingsColumnWidth() {
        int settingsAreaWidth = this.menuWidth - 5 - 65 - 16;
        return (settingsAreaWidth - 5) / 2;
    }

    private int getSettingsX(int column) {
        int columnWidth = this.getSingleSettingsColumnWidth();
        int baseX = this.left + 8 + 65 + 5;
        return baseX + column * (columnWidth + 5);
    }

    private int getSettingsY(int row) {
        int baseY = this.top + 60;
        return baseY + row * 25;
    }

    private int getSettingsWidth(int columnsTaken) {
        int columnWidth = this.getSingleSettingsColumnWidth();
        return columnWidth * columnsTaken + 5 * (columnsTaken - 1);
    }

    private void addBottomButtons(List<List<RenderableThingGetter<?>>> buttons) {
        int rowWidth = this.menuWidth - 16;
        int startX = this.left + 8;
        int startY = this.top + this.menuHeight - 8 - 20;
        int yOffset = 25;
        for (int i = 0; i < buttons.size(); ++i) {
            List<RenderableThingGetter<?>> row = buttons.get(i);
            int buttonWidth = (rowWidth - 5 * (row.size() - 1)) / row.size();
            for (int buttonIndex = 0; buttonIndex < row.size(); ++buttonIndex) {
                this.method_37063((class_364)row.get(buttonIndex).get(startX + buttonIndex * (buttonWidth + 5), startY - i * 25, buttonWidth, 20));
            }
        }
    }

    private void markDefault(class_4185 button) {
        Optional ctx = Coordinate.getCurrent();
        if (ctx.isPresent()) {
            ConnectionSettings.put(((Coordinate)ctx.get()).id(), ConnectionSettings.getOrCreate(((Coordinate)ctx.get()).id()).setOverride(this.memoryBank.id().equals(((Coordinate)ctx.get()).id()) ? Optional.empty() : Optional.of(this.memoryBank.id())));
            button.field_22763 = false;
        }
    }

    private void load(class_4185 button) {
        MemoryBankAccessImpl.INSTANCE.loadOrCreate(this.memoryBank.id(), this.memoryBank.metadata().getName());
        this.afterBankLoaded.run();
    }

    private void delete(HoldToConfirmButton button) {
        if (this.isCurrentLoaded) {
            MemoryBankAccessImpl.INSTANCE.unload();
        }
        Storage.delete(this.memoryBank.id());
        this.method_25419();
    }

    private void save(class_4185 button) {
        this.memoryBank.save();
        this.method_25419();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface RenderableThingGetter<T extends class_364 & class_4068> {
        public T get(int var1, int var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum SettingsTab {
        COMPATIBILITY,
        FILTERING,
        INTEGRITY,
        MANAGE,
        SEARCH,
        EMPTY;

    }
}

