/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.widget;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class HoldToConfirmButton
extends class_4264 {
    private final Consumer<HoldToConfirmButton> callback;
    private final long holdToActivateTime;
    public static final int PROGRESS_TICKS = 5;
    private final Set<Integer> held = new HashSet<Integer>(4);
    private float progress = 0.0f;
    private int progressTicks = 0;

    public HoldToConfirmButton(int x, int y, int width, int height, class_2561 component, long holdToActivateTime, Consumer<HoldToConfirmButton> callback) {
        super(x, y, width, height, component);
        this.holdToActivateTime = holdToActivateTime;
        this.callback = callback;
    }

    public void method_25306(@NotNull class_11907 input) {
        this.playDownSound(this.getPitch());
        this.callback.accept(this);
    }

    private float getPitch() {
        return 1.0f + 0.2f * (this.progress / (float)this.holdToActivateTime);
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        if (this.progress > 0.0f) {
            graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, (int)((float)this.method_46426() + this.progress / (float)this.holdToActivateTime * (float)(this.field_22758 - 2)), this.method_46427() + this.method_25364() - 1, 0x40FF0000);
        }
        if (!this.held.isEmpty()) {
            int newProgressTicks;
            this.progress = Math.min((float)this.holdToActivateTime, this.progress + partialTick);
            if (this.progress >= (float)this.holdToActivateTime) {
                this.method_25306(new class_11907(this){

                    public int method_74228() {
                        return -1;
                    }

                    public int comp_4797() {
                        return 0;
                    }
                });
                this.progress = 0.0f;
                this.progressTicks = 0;
            }
            if ((newProgressTicks = (int)(this.progress * 5.0f / (float)this.holdToActivateTime)) > this.progressTicks) {
                this.playDownSound(this.getPitch());
            }
            this.progressTicks = newProgressTicks;
        } else {
            this.progress = Math.max(0.0f, this.progress - 2.0f * partialTick);
        }
    }

    public boolean method_25402(@NotNull class_11909 event, boolean isDoubleClick) {
        if (this.method_25405(event.comp_4798(), event.comp_4799()) && this.field_22763) {
            System.out.println("mouseClicked");
            this.playDownSound(1.0f);
            this.held.add(-1);
            return true;
        }
        return false;
    }

    public boolean method_25406(@NotNull class_11909 event) {
        this.held.remove(-1);
        return super.method_25406(event);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.field_22763 && !this.method_25405(mouseX, mouseY)) {
            this.held.remove(-1);
        }
        super.method_16014(mouseX, mouseY);
    }

    private static boolean isActivationKeybind(int keyCode) {
        return keyCode == 257 || keyCode == 32 || keyCode == 335;
    }

    public boolean method_25404(@NotNull class_11908 event) {
        if (!this.method_25370()) {
            return false;
        }
        int key = event.comp_4795();
        if (HoldToConfirmButton.isActivationKeybind(key)) {
            if (this.held.isEmpty()) {
                this.playDownSound(1.0f);
            }
            this.held.add(key);
            return true;
        }
        return false;
    }

    public boolean method_16803(@NotNull class_11908 event) {
        int key = event.comp_4795();
        if (HoldToConfirmButton.isActivationKeybind(key)) {
            this.held.remove(key);
        }
        return super.method_16803(event);
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    public void playDownSound(float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)pitch));
    }
}

