/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory.metadata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import red.jackf.chesttracker.api.providers.MemoryKeyIcon;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.impl.gui.GuiConstants;
import red.jackf.chesttracker.impl.util.Misc;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class VisualSettings {
    public static Codec<VisualSettings> CODEC = RecordCodecBuilder.create(instance -> {
        VisualSettings def = new VisualSettings();
        return instance.group((App)JFLCodecs.mutableList((Codec)MemoryKeyIcon.CODEC.listOf()).optionalFieldOf("icons").forGetter(meta -> Optional.of(meta.icons)), (App)Codec.BOOL.optionalFieldOf("useDefaultIconOrder").forGetter(visualSettings -> Optional.of(visualSettings.useDefaultIconOrder))).apply((Applicative)instance, (icons, useDefaultIconOrder) -> new VisualSettings(icons.orElse(def.icons), useDefaultIconOrder.orElse(def.useDefaultIconOrder)));
    });
    private List<MemoryKeyIcon> icons = new ArrayList<MemoryKeyIcon>();
    public boolean useDefaultIconOrder = true;

    public List<class_2960> getKeyOrder() {
        return this.icons.stream().map(MemoryKeyIcon::id).toList();
    }

    public void moveIcon(int from, int to) {
        this.icons.add(to, this.icons.remove(from));
        this.useDefaultIconOrder = false;
    }

    public class_1799 getOrCreateIcon(class_2960 key) {
        for (MemoryKeyIcon icon : this.icons) {
            if (!icon.id().equals((Object)key)) continue;
            return icon.icon();
        }
        MemoryKeyIcon newIcon = ProviderUtils.getCurrentProvider().flatMap(provider -> provider.getMemoryKeyIcons().stream().filter(icon -> icon.id().equals((Object)key)).findFirst()).orElseGet(() -> new MemoryKeyIcon(key, GuiConstants.UNKNOWN_ICON));
        this.icons.add(newIcon);
        this.reorderIfNecessary();
        return newIcon.icon();
    }

    public void setIcon(class_2960 key, class_1799 icon) {
        OptionalInt existingIndex = IntStream.range(0, this.icons.size()).filter(index -> this.icons.get(index).id().equals((Object)key)).findFirst();
        MemoryKeyIcon keyIcon = new MemoryKeyIcon(key, icon);
        if (existingIndex.isPresent()) {
            this.icons.set(existingIndex.getAsInt(), keyIcon);
        } else {
            this.icons.add(keyIcon);
        }
        this.reorderIfNecessary();
    }

    public void removeIcon(class_2960 key) {
        Iterator<MemoryKeyIcon> iter = this.icons.iterator();
        while (iter.hasNext()) {
            if (!iter.next().id().equals((Object)key)) continue;
            iter.remove();
            return;
        }
    }

    public void reorderIfNecessary() {
        if (!this.useDefaultIconOrder) {
            return;
        }
        ServerProvider provider = ProviderUtils.getCurrentProvider().orElse(null);
        if (provider == null) {
            return;
        }
        List<class_2960> iconKeys = provider.getMemoryKeyIcons().stream().map(MemoryKeyIcon::id).toList();
        this.icons = this.icons.stream().sorted(Comparator.comparing(MemoryKeyIcon::id, Misc.bringToFront(iconKeys))).collect(Collectors.toCollection(ArrayList::new));
    }

    VisualSettings() {
    }

    public VisualSettings(List<MemoryKeyIcon> icons, boolean useDefaultIconOrder) {
        this.icons = icons;
        this.useDefaultIconOrder = useDefaultIconOrder;
    }

    public VisualSettings copy() {
        return new VisualSettings(new ArrayList<MemoryKeyIcon>(this.icons), this.useDefaultIconOrder);
    }
}

