/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;

@Environment(value=EnvType.CLIENT)
public class Strings {
    private static final Character[] siSuffixes = new Character[]{Character.valueOf('k'), Character.valueOf('M'), Character.valueOf('G'), Character.valueOf('T'), Character.valueOf('P'), Character.valueOf('E'), Character.valueOf('Z'), Character.valueOf('Y'), Character.valueOf('R'), Character.valueOf('Q')};
    private static final Pattern RESERVED_WINDOWS_FILENAMES = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);

    private static String magnitude(long in, int decimalPlaces, boolean withSpace) {
        double total = in;
        int index = -1;
        while (total >= 1000.0) {
            total /= 1000.0;
            ++index;
        }
        if (index == -1) {
            return in + (withSpace ? " " : "");
        }
        index = Math.min(index, siSuffixes.length - 1);
        String formatStr = "%." + decimalPlaces + "f";
        if (withSpace) {
            formatStr = formatStr + " ";
        }
        formatStr = formatStr + "%s";
        return formatStr.formatted(total, siSuffixes[index]);
    }

    public static String magnitudeSpace(long in, int decimalPlaces) {
        return Strings.magnitude(in, decimalPlaces, true);
    }

    public static String magnitude(long in, int decimalPlaces) {
        return Strings.magnitude(in, decimalPlaces, false);
    }

    public static String commaSeparated(int number) {
        return "%,d".formatted(number);
    }

    public static String sanitizeForPath(String text) {
        char[] var3;
        if (text == null) {
            return null;
        }
        for (char c : var3 = class_155.field_1126) {
            text = ((String)text).replace(c, '_');
        }
        if (RESERVED_WINDOWS_FILENAMES.matcher((CharSequence)(text = ((String)text).replaceAll("[./\"]", "_"))).matches()) {
            text = "_" + (String)text + "_";
        }
        return text;
    }

    public static String formatPath(Path path) {
        StringBuilder builder = new StringBuilder();
        Iterator<Path> iter = path.iterator();
        while (iter.hasNext()) {
            Path name = iter.next();
            builder.append(name.getFileName());
            if (!iter.hasNext()) continue;
            builder.append("/");
        }
        return builder.toString();
    }
}

