/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory.metadata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import red.jackf.chesttracker.impl.util.I18n;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class IntegritySettings {
    protected static final Codec<IntegritySettings> CODEC = RecordCodecBuilder.create(instance -> {
        IntegritySettings def = new IntegritySettings();
        return instance.group((App)Codec.BOOL.optionalFieldOf("removeOnPlayerBlockBreak").forGetter(settings -> Optional.of(settings.removeOnPlayerBlockBreak)), (App)Codec.BOOL.optionalFieldOf("checkPeriodicallyForMissingBlocks").forGetter(settings -> Optional.of(settings.checkPeriodicallyForMissingBlocks)), (App)JFLCodecs.forEnum(MemoryLifetime.class).optionalFieldOf("memoryLifetime").forGetter(settings -> Optional.of(settings.memoryLifetime)), (App)Codec.BOOL.optionalFieldOf("preserveNamed").forGetter(settings -> Optional.of(settings.preserveNamed)), (App)JFLCodecs.forEnum(LifetimeCountMode.class).optionalFieldOf("lifetimeCountMode").forGetter(settings -> Optional.of(settings.lifetimeCountMode))).apply((Applicative)instance, (removeOnPlayerBlockBreak, checkPeriodicallyForMissingBlocks, memoryLifetime, preserveNamed, lifetimeCountMode) -> new IntegritySettings(removeOnPlayerBlockBreak.orElse(def.removeOnPlayerBlockBreak), checkPeriodicallyForMissingBlocks.orElse(def.checkPeriodicallyForMissingBlocks), memoryLifetime.orElse(def.memoryLifetime), preserveNamed.orElse(def.preserveNamed), lifetimeCountMode.orElse(def.lifetimeCountMode)));
    });
    public boolean removeOnPlayerBlockBreak = true;
    public boolean checkPeriodicallyForMissingBlocks = true;
    public MemoryLifetime memoryLifetime = MemoryLifetime.TWELVE_HOURS;
    public boolean preserveNamed = true;
    public LifetimeCountMode lifetimeCountMode = LifetimeCountMode.LOADED_TIME;

    IntegritySettings() {
    }

    public IntegritySettings(boolean removeOnPlayerBlockBreak, boolean checkPeriodicallyForMissingBlocks, MemoryLifetime memoryLifetime, boolean preserveNamed, LifetimeCountMode lifetimeCountMode) {
        this();
        this.removeOnPlayerBlockBreak = removeOnPlayerBlockBreak;
        this.checkPeriodicallyForMissingBlocks = checkPeriodicallyForMissingBlocks;
        this.memoryLifetime = memoryLifetime;
        this.preserveNamed = preserveNamed;
        this.lifetimeCountMode = lifetimeCountMode;
    }

    public IntegritySettings copy() {
        return new IntegritySettings(this.removeOnPlayerBlockBreak, this.checkPeriodicallyForMissingBlocks, this.memoryLifetime, this.preserveNamed, this.lifetimeCountMode);
    }

    private static class_2561 lifetimePrefix() {
        return class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.memoryLifetime");
    }

    @Environment(value=EnvType.CLIENT)
    public static enum MemoryLifetime {
        TEN_SECONDS(10L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.seconds(10))),
        FIVE_MINUTES(300L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.minutes(5))),
        TWENTY_MINUTES(900L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.minutes(15))),
        FORTY_MINUTES(1800L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.minutes(30))),
        ONE_HOUR(3600L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.hours(1))),
        TWO_HOURS(7200L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.hours(2))),
        FOUR_HOURS(14400L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.hours(4))),
        SIX_HOURS(21600L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.hours(6))),
        TWELVE_HOURS(43200L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.hours(12))),
        ONE_DAY(86400L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.days(1))),
        TWO_DAYS(172800L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.days(2))),
        FIVE_DAYS(432000L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.days(5))),
        SEVEN_DAYS(604800L, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), I18n.days(7))),
        NEVER(null, (class_2561)I18n.colon(IntegritySettings.lifetimePrefix(), class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.memoryLifetime.never")));

        public final Long seconds;
        public final class_2561 label;

        private MemoryLifetime(Long seconds, class_2561 label) {
            this.seconds = seconds;
            this.label = label;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum LifetimeCountMode {
        REAL_TIME((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.lifetimeCountMode.realTime")),
        WORLD_TIME((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.lifetimeCountMode.worldTime")),
        LOADED_TIME((class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity.lifetimeCountMode.loadedTime"));

        public final class_2561 label;

        private LifetimeCountMode(class_2561 label) {
            this.label = label;
        }
    }
}

