/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.Backend;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.chesttracker.impl.util.Strings;

@Environment(value=EnvType.CLIENT)
public abstract class FileBasedBackend
implements Backend {
    public static final Logger LOGGER = LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/File Storage"));

    @Override
    public Collection<String> getAllIds() {
        List<String> list;
        block9: {
            if (!Files.isDirectory(Constants.STORAGE_DIR, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.walk(Constants.STORAGE_DIR, new FileVisitOption[0]);
            try {
                list = stream.filter(path -> path.getFileName().toString().endsWith(this.metadataExtension())).map(path -> Strings.formatPath(Constants.STORAGE_DIR.relativize((Path)path))).map(s -> s.substring(0, s.length() - this.metadataExtension().length())).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    public void delete(String id) {
        this.getRelevantPaths(id).forEach(path -> {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                    LOGGER.info("Deleted {}", path);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        });
    }

    @Override
    public boolean saveMetadata(String id, Metadata metadata) {
        Path path = Constants.STORAGE_DIR.resolve(id + this.metadataExtension());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Optional metaJson = Metadata.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)metadata).resultOrPartial(class_156.method_29188((String)"Error encoding metadata", arg_0 -> ((Logger)LOGGER).error(arg_0)));
            if (metaJson.isPresent()) {
                FileUtils.write((File)path.toFile(), (CharSequence)FileUtil.gson().toJson((JsonElement)metaJson.get()), (Charset)StandardCharsets.UTF_8);
                return true;
            }
            LOGGER.error("Unknown error encoding metadata");
        }
        catch (IOException e) {
            LOGGER.error("Error saving memories", (Throwable)e);
        }
        return false;
    }

    @Override
    public Optional<Metadata> loadMetadata(String id) {
        Path path = Constants.STORAGE_DIR.resolve(id + this.metadataExtension());
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                String str = FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)FileUtil.gson().fromJson(str, JsonElement.class);
                AtomicReference<Object> metadata = new AtomicReference<Object>(null);
                Metadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(class_156.method_29188((String)("Invalid metadata JSON: " + id), arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(pair -> metadata.set(((Metadata)pair.getFirst())));
                if (metadata.get() != null) {
                    return Optional.ofNullable(metadata.get());
                }
            }
            catch (JsonParseException | IOException ex) {
                LOGGER.error("Error decoding metadata", ex);
                FileUtil.tryMove(path, path.resolveSibling(String.valueOf(path.getFileName()) + ".corrupt"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return Optional.empty();
    }

    @Override
    public class_2561 getDescriptionLabel(String memoryBankId) {
        long size = this.getRelevantPaths(memoryBankId).stream().mapToLong(FileBasedBackend::getSizeIfPresent).sum();
        return class_2561.method_43469((String)"chesttracker.storage.json.fileSize", (Object[])new Object[]{Strings.magnitudeSpace(size, 2) + "B"});
    }

    public abstract String extension();

    protected String metadataExtension() {
        return this.extension() + ".meta";
    }

    protected List<Path> getRelevantPaths(String id) {
        return List.of(Constants.STORAGE_DIR.resolve(id + this.extension()), Constants.STORAGE_DIR.resolve(id + this.metadataExtension()));
    }

    private static long getSizeIfPresent(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) ? FileUtils.sizeOf((File)path.toFile()) : 0L;
    }
}

