/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class ItemStacks {
    public static List<class_1799> flattenStacks(List<class_1799> in, boolean sortDescending) {
        HashMap<LightweightStack, Integer> counts = new HashMap<LightweightStack, Integer>();
        for (class_1799 itemStack : in) {
            counts.merge(new LightweightStack(itemStack), itemStack.method_7947(), Integer::sum);
        }
        Stream<class_1799> stream = counts.entrySet().stream().map(entry -> {
            class_1799 stack = ((LightweightStack)entry.getKey()).toStack();
            stack.method_7939(((Integer)entry.getValue()).intValue());
            return stack;
        });
        if (sortDescending) {
            stream = stream.sorted(Comparator.comparingInt(class_1799::method_7947).reversed());
        }
        return stream.toList();
    }

    private static boolean testLang(String key, String filter) {
        return class_2477.method_10517().method_4678(key) && class_2477.method_10517().method_48307(key).toLowerCase().contains(filter);
    }

    private static boolean testHolder(class_6880<?> holder, String filter) {
        return holder.method_40230().map(key -> key.method_29177().toString().toLowerCase().contains(filter)).orElse(false);
    }

    public static boolean defaultPredicate(class_1799 stack, String filter) {
        return ItemStacks.namePredicate(stack, filter) || ItemStacks.tagPredicate(stack, filter) || ItemStacks.lorePredicate(stack, filter) || ItemStacks.tooltipPredicate(stack, filter) || ItemStacks.enchantmentPredicate(stack, filter) || ItemStacks.potionOrEffectPredicate(stack, filter) || ItemStacks.countPredicate(stack, filter);
    }

    public static boolean namePredicate(class_1799 stack, String filter) {
        return StringUtils.containsIgnoreCase((CharSequence)stack.method_7964().getString(), (CharSequence)filter);
    }

    public static boolean tagPredicate(class_1799 stack, String filter) {
        return stack.method_41409().method_40228().anyMatch(tag -> tag.comp_327().method_12832().contains(filter));
    }

    private static boolean lorePredicate(class_1799 stack, String filter) {
        class_9290 lore = (class_9290)stack.method_58694(class_9334.field_49632);
        if (lore == null) {
            return false;
        }
        for (class_2561 line : lore.comp_2400()) {
            String str = line.getString().toLowerCase();
            if (!str.contains(filter)) continue;
            return true;
        }
        return false;
    }

    public static boolean tooltipPredicate(class_1799 stack, String filter) {
        class_1836.class_1837 flag = class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        for (class_2561 line : stack.method_7950(class_1792.class_9635.method_59528((class_1937)class_310.method_1551().field_1687), (class_1657)class_310.method_1551().field_1724, (class_1836)flag)) {
            if (!line.getString().toLowerCase().contains(filter)) continue;
            return true;
        }
        return false;
    }

    public static boolean enchantmentPredicate(class_1799 stack, String filter) {
        class_9304 enchantments = class_1890.method_57532((class_1799)stack);
        if (enchantments.method_57543()) {
            return false;
        }
        return enchantments.method_57534().stream().anyMatch(ench -> {
            if (((class_1887)ench.comp_349()).comp_2686().getString().toLowerCase().contains(filter)) {
                return true;
            }
            return ItemStacks.testHolder(ench, filter);
        });
    }

    public static boolean potionOrEffectPredicate(class_1799 stack, String filter) {
        class_1844 potionContents = (class_1844)stack.method_58694(class_9334.field_49651);
        if (potionContents == null) {
            return false;
        }
        if (potionContents.comp_2378().isPresent()) {
            String potionName = potionContents.comp_3209().or(() -> potionContents.comp_2378().map(holder -> ((class_1842)holder.comp_349()).method_63990())).orElse("empty");
            String langKey = stack.method_7909().method_7876() + ".effect." + potionName;
            if (ItemStacks.testLang(langKey, filter)) {
                return true;
            }
            class_2960 resloc = class_7923.field_41179.method_10221((Object)((class_1842)((class_6880)potionContents.comp_2378().get()).comp_349()));
            if (resloc != null && resloc.toString().contains(filter)) {
                return true;
            }
        }
        List effects = potionContents.comp_2380();
        for (class_1293 effect : effects) {
            String langKey = effect.method_5586();
            if (ItemStacks.testLang(langKey, filter)) {
                return true;
            }
            class_2960 resloc = class_7923.field_41174.method_10221((Object)((class_1291)effect.method_5579().comp_349()));
            if (resloc == null || !resloc.toString().contains(filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean countPredicate(class_1799 stack, String filter) {
        try {
            if (filter.startsWith(">=")) {
                return stack.method_7947() >= Integer.parseInt(filter.substring(2));
            }
            if (filter.startsWith(">")) {
                return stack.method_7947() > Integer.parseInt(filter.substring(1));
            }
            if (filter.startsWith("<=")) {
                return stack.method_7947() <= Integer.parseInt(filter.substring(2));
            }
            if (filter.startsWith("<")) {
                return stack.method_7947() < Integer.parseInt(filter.substring(1));
            }
            if (filter.startsWith("=")) {
                return stack.method_7947() == Integer.parseInt(filter.substring(1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private record LightweightStack(class_1792 item, class_9326 patch) {
        public LightweightStack(class_1799 stack) {
            this(stack.method_7909(), stack.method_57380());
        }

        public class_1799 toStack() {
            class_1799 stack = new class_1799((class_1935)this.item);
            stack.method_57366(this.patch);
            return stack;
        }
    }
}

