/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.widget;

import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.util.GuiUtil;

@Environment(value=EnvType.CLIENT)
public class ResizeWidget
extends class_339 {
    private static final class_2960 TEXTURE = GuiUtil.png("widgets/resize");
    private static final int SIZE = 10;
    private final int stepSize;
    private final int currentWidth;
    private final int currentHeight;
    private final int minWidth;
    private final int minHeight;
    private final int maxWidth;
    private final int maxHeight;
    private final BiConsumer<Integer, Integer> callback;
    private final int left;
    private final int top;
    @Nullable
    private Pair<Integer, Integer> target = null;

    public ResizeWidget(int x, int y, int screenLeft, int screenTop, int stepSize, int currentWidth, int currentHeight, int minWidth, int minHeight, int maxWidth, int maxHeight, BiConsumer<Integer, Integer> callback) {
        super(x, y, 10, 10, (class_2561)class_2561.method_43473());
        this.left = screenLeft;
        this.top = screenTop;
        if (currentWidth < minWidth || currentWidth > maxWidth) {
            throw new IllegalArgumentException("Resize width out of bounds: %d".formatted(currentWidth));
        }
        if (currentHeight < minHeight || currentHeight > maxHeight) {
            throw new IllegalArgumentException("Resize height out of bounds: %d".formatted(currentHeight));
        }
        this.stepSize = stepSize;
        this.currentWidth = currentWidth;
        this.currentHeight = currentHeight;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.callback = callback;
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.resize")));
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 10, 10, 10, 10);
        if (this.target != null) {
            int right = this.method_46426() + ((Integer)this.target.getLeft() - this.currentWidth) * this.stepSize + 10;
            int bottom = this.method_46427() + ((Integer)this.target.getRight() - this.currentHeight) * this.stepSize + 10;
            graphics.method_25294(this.left - 1, this.top - 1, right + 1, this.top, -65536);
            graphics.method_25294(this.left - 1, bottom, right + 1, bottom + 1, -65536);
            graphics.method_25294(this.left - 1, this.top, this.left, bottom, -65536);
            graphics.method_25294(right, this.top, right + 1, bottom, -65536);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"chesttracker.gui.resize"));
        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"chesttracker.gui.narration.drag"));
    }

    private void updateTarget(double mouseX, double mouseY) {
        this.target = Pair.of((Object)class_3532.method_15340((int)((int)((double)this.currentWidth + (mouseX - (double)this.method_46426()) / (double)this.stepSize)), (int)this.minWidth, (int)this.maxWidth), (Object)class_3532.method_15340((int)((int)((double)this.currentHeight + (mouseY - (double)this.method_46427()) / (double)this.stepSize)), (int)this.minHeight, (int)this.maxHeight));
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.updateTarget(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.target != null) {
            if ((Integer)this.target.getLeft() == this.currentWidth && (Integer)this.target.getRight() == this.currentHeight) {
                this.target = null;
            } else {
                this.callback.accept((Integer)this.target.getLeft(), (Integer)this.target.getRight());
            }
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        if (this.target != null) {
            this.updateTarget(mouseX, mouseY);
        }
    }
}

