/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.api.providers;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import red.jackf.chesttracker.api.ClientBlockSource;
import red.jackf.chesttracker.api.providers.MemoryKeyIcon;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.api.providers.defaults.DefaultIcons;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.providers.ProviderHandler;

@Environment(value=EnvType.CLIENT)
public interface ProviderUtils {
    public static <T extends ServerProvider> T registerProvider(T provider) {
        return ProviderHandler.INSTANCE.register(provider);
    }

    public static Optional<class_2960> getPlayersCurrentKey() {
        return ProviderHandler.INSTANCE.getCurrentProvider().flatMap(provider -> {
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if (level == null || player == null) {
                return Optional.empty();
            }
            return provider.getPlayersCurrentKey((class_1937)level, player);
        });
    }

    public static Optional<MemoryLocation> getLocationFor(ClientBlockSource cbs) {
        return ProviderUtils.getCurrentProvider().flatMap(provider -> provider.getMemoryLocation(cbs));
    }

    public static Optional<ServerProvider> getCurrentProvider() {
        return ProviderHandler.INSTANCE.getCurrentProvider();
    }

    public static List<MemoryKeyIcon> getDefaultIcons() {
        return DefaultIcons.getDefaultIcons();
    }

    public static boolean defaultShouldRemember(ClientBlockSource cbs) {
        return MemoryBankAccessImpl.INSTANCE.getLoadedInternal().map(bank -> bank.getMetadata().getFilteringSettings().rememberedContainers.predicate.test(cbs.blockState())).orElse(false);
    }

    public static boolean isPlayerSlot(class_1735 slot) {
        return slot.field_7871 instanceof class_1661;
    }
}

