/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.mods.searchables;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.formatter.FormattingContext;
import com.blamejared.searchables.lang.StringSearcher;
import com.blamejared.searchables.lang.expression.type.ComponentExpression;
import com.blamejared.searchables.lang.expression.type.GroupingExpression;
import com.blamejared.searchables.lang.expression.type.LiteralExpression;
import com.blamejared.searchables.lang.expression.type.PairedExpression;
import com.blamejared.searchables.lang.expression.visitor.ContextAwareVisitor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import red.jackf.chesttracker.impl.gui.util.TextColours;

@Environment(value=EnvType.CLIENT)
public class CustomSearchablesFormatter
implements ContextAwareVisitor<TokenRange, FormattingContext>,
Consumer<String>,
BiFunction<String, Integer, class_5481> {
    private final SearchableType<?> type;
    private final List<Pair<TokenRange, class_2583>> tokens = new ArrayList<Pair<TokenRange, class_2583>>();
    private TokenRange lastRange = TokenRange.at((int)0);

    public CustomSearchablesFormatter(SearchableType<?> type) {
        this.type = type;
    }

    public void reset() {
        this.tokens.clear();
        this.lastRange = TokenRange.at((int)0);
    }

    @NotNull
    public TokenRange visitGrouping(GroupingExpression expr, @NotNull FormattingContext context) {
        TokenRange leftRange = (TokenRange)expr.left().accept((ContextAwareVisitor)this, (Object)context);
        this.tokens.add((Pair<TokenRange, class_2583>)Pair.of((Object)this.getAndPushRange(), (Object)context.style()));
        TokenRange rightRange = (TokenRange)expr.right().accept((ContextAwareVisitor)this, (Object)context);
        return TokenRange.encompassing((TokenRange)leftRange, (TokenRange)rightRange);
    }

    @NotNull
    public TokenRange visitComponent(ComponentExpression expr, FormattingContext context) {
        boolean valid = context.valid() && expr.left() instanceof LiteralExpression && expr.right() instanceof LiteralExpression;
        TokenRange leftRange = (TokenRange)expr.left().accept((ContextAwareVisitor)this, (Object)FormattingContext.key((class_2583)class_2583.field_24360.method_36139(TextColours.getSearchKeyColour()), (boolean)valid));
        this.tokens.add((Pair<TokenRange, class_2583>)Pair.of((Object)this.getAndPushRange(), (Object)context.style(valid)));
        TokenRange rightRange = (TokenRange)expr.right().accept((ContextAwareVisitor)this, (Object)FormattingContext.literal((class_2583)class_2583.field_24360.method_36139(TextColours.getSearchTermColour()), (boolean)valid));
        return TokenRange.encompassing((TokenRange)leftRange, (TokenRange)rightRange);
    }

    @NotNull
    public TokenRange visitLiteral(@NotNull LiteralExpression expr, FormattingContext context) {
        class_2583 style = context.style();
        if (!context.valid() || context.isKey() && !this.type.components().containsKey(expr.value())) {
            style = class_2583.field_24360.method_36139(TextColours.getErrorColour()).method_30938(Boolean.valueOf(true));
        }
        TokenRange range = this.getAndPushRange(expr.displayValue().length());
        this.tokens.add((Pair<TokenRange, class_2583>)Pair.of((Object)range, (Object)style));
        return range;
    }

    @NotNull
    public TokenRange visitPaired(PairedExpression expr, @NotNull FormattingContext context) {
        TokenRange leftRange = (TokenRange)expr.first().accept((ContextAwareVisitor)this, (Object)context);
        TokenRange rightRange = (TokenRange)expr.second().accept((ContextAwareVisitor)this, (Object)context);
        return TokenRange.encompassing((TokenRange)leftRange, (TokenRange)rightRange);
    }

    private TokenRange getAndPushRange() {
        return this.getAndPushRange(1);
    }

    private TokenRange getAndPushRange(int end) {
        TokenRange oldRange = this.lastRange;
        this.lastRange = TokenRange.between((int)this.lastRange.end(), (int)(this.lastRange.end() + end));
        return TokenRange.between((int)oldRange.end(), (int)(oldRange.end() + end));
    }

    @Override
    public void accept(String search) {
        this.reset();
        StringSearcher.search((String)search, (ContextAwareVisitor)this, (Object)FormattingContext.empty());
    }

    @Override
    public class_5481 apply(String currentString, Integer offset) {
        Pair<TokenRange, class_2583> token;
        TokenRange range;
        int subEnd;
        ArrayList<class_5481> sequences = new ArrayList<class_5481>();
        int index = 0;
        Iterator<Pair<TokenRange, class_2583>> iterator = this.tokens.iterator();
        while (iterator.hasNext() && (subEnd = Math.max((range = (TokenRange)(token = iterator.next()).getFirst()).start() - offset, 0)) < currentString.length()) {
            int subStart = Math.min(range.end() - offset, currentString.length());
            if (subStart <= 0) continue;
            sequences.add(class_5481.method_30747((String)currentString.substring(index, subEnd), (class_2583)((class_2583)token.getSecond())));
            sequences.add(class_5481.method_30747((String)currentString.substring(subEnd, subStart), (class_2583)((class_2583)token.getSecond())));
            index = subStart;
        }
        sequences.add(class_5481.method_30747((String)currentString.substring(index), (class_2583)class_2583.field_24360));
        return class_5481.method_30749(sequences);
    }
}

