/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.mods.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import red.jackf.chesttracker.api.memory.CommonKeys;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryBank;
import red.jackf.chesttracker.api.memory.MemoryBankAccess;
import red.jackf.chesttracker.api.memory.MemoryKey;
import red.jackf.chesttracker.api.memory.counting.CountingPredicate;
import red.jackf.chesttracker.api.memory.counting.StackMergeMode;

@Environment(value=EnvType.CLIENT)
public class ClientEnderChestPreviewProvider
implements PreviewProvider {
    private static Optional<MemoryKey> getNonEmptyEnderChestMemoryKey() {
        return MemoryBankAccess.INSTANCE.getLoaded().flatMap(bank -> bank.getKey(CommonKeys.ENDER_CHEST_KEY)).filter(key -> !key.isEmpty());
    }

    public boolean shouldDisplay(@NotNull PreviewContext context) {
        return ClientEnderChestPreviewProvider.getNonEmptyEnderChestMemoryKey().isPresent();
    }

    public List<class_1799> getInventory(@NotNull PreviewContext context) {
        Optional<MemoryBank> bank = MemoryBankAccess.INSTANCE.getLoaded();
        if (bank.isEmpty()) {
            return Collections.emptyList();
        }
        if (ShulkerBoxTooltipApi.getCurrentPreviewType((boolean)true) == PreviewType.FULL) {
            return bank.get().getKey(CommonKeys.ENDER_CHEST_KEY).flatMap(key -> key.get(class_2338.field_10980)).map(Memory::fullItems).orElse(List.of());
        }
        return bank.get().getCounts(CommonKeys.ENDER_CHEST_KEY, CountingPredicate.TRUE, StackMergeMode.NEVER);
    }

    public int getInventoryMaxSize(@NotNull PreviewContext context) {
        return 27;
    }

    public int getPriority() {
        return 1500;
    }

    public boolean isFullPreviewAvailable(@NotNull PreviewContext context) {
        return true;
    }

    public ColorKey getWindowColorKey(@NotNull PreviewContext context) {
        return ColorKey.ENDER_CHEST;
    }

    public List<class_2561> addTooltip(@NotNull PreviewContext context) {
        if (ShulkerBoxTooltipApi.getCurrentPreviewType((boolean)true) == PreviewType.FULL && ClientEnderChestPreviewProvider.getNonEmptyEnderChestMemoryKey().isPresent()) {
            return List.of(class_2561.method_43469((String)"chesttracker.compatibility.brand", (Object[])new Object[]{class_2561.method_43471((String)"chesttracker.title").method_27692(class_124.field_1065)}).method_27692(class_124.field_1080));
        }
        return Collections.emptyList();
    }
}

