/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.widget;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.gui.util.TextColours;
import red.jackf.chesttracker.impl.util.GuiUtil;

@Environment(value=EnvType.CLIENT)
public class StringSelectorWidget<T>
extends class_339 {
    private static final int ROW_HEIGHT = 12;
    private final Consumer<T> onSelect;
    private Map<T, class_2561> options = Collections.emptyMap();
    @Nullable
    private T lastHovered = null;
    @Nullable
    private T highlight = null;

    public StringSelectorWidget(int x, int y, int width, int height, class_2561 message, Consumer<T> onSelect) {
        super(x, y, width, height, message);
        this.onSelect = onSelect;
    }

    public void setHighlight(@Nullable T highlight) {
        this.highlight = highlight;
    }

    public void setOptions(Map<T, class_2561> options) {
        this.options = options;
    }

    @Nullable
    private Integer getHoveredIndex(int mouseX, int mouseY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return null;
        }
        return Math.floorDiv(mouseY - 1 - this.method_46427(), 12);
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_52706(class_10799.field_56883, GuiUtil.SEARCH_BAR_SPRITE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        int i = 0;
        Integer hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        this.lastHovered = null;
        for (Map.Entry<T, class_2561> entry : this.options.entrySet()) {
            if (i >= this.method_25364() / 12) break;
            boolean hovered = Objects.equals(i, hoveredIndex);
            if (hovered) {
                this.lastHovered = entry.getKey();
            }
            int textColour = hovered ? TextColours.getSearchTermColour() : (entry.getKey().equals(this.highlight) ? TextColours.getSearchKeyColour() : TextColours.getTextColour());
            graphics.method_27535(class_310.method_1551().field_1772, entry.getValue(), this.method_46426() + 2 + (hovered ? 6 : 0), this.method_46427() + 2 + 12 * i, textColour);
            ++i;
        }
    }

    public void method_25348(class_11909 event, boolean isDoubleClick) {
        System.out.println("StringSelectorWidget");
        if (this.lastHovered != null) {
            this.onSelect.accept(this.lastHovered);
        }
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }
}

