/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.servers.hypixel;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import red.jackf.chesttracker.api.ClientBlockSource;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryBank;
import red.jackf.chesttracker.api.memory.MemoryBankAccess;
import red.jackf.chesttracker.api.providers.InteractionTracker;
import red.jackf.chesttracker.api.providers.MemoryBuilder;
import red.jackf.chesttracker.api.providers.MemoryKeyIcon;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.api.providers.context.ScreenCloseContext;
import red.jackf.chesttracker.api.providers.context.ScreenOpenContext;
import red.jackf.chesttracker.api.providers.defaults.DefaultProvider;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.compat.servers.hypixel.SMP;
import red.jackf.chesttracker.impl.compat.servers.hypixel.Skyblock;
import red.jackf.jackfredlib.client.api.gps.Coordinate;
import red.jackf.jackfredlib.client.api.gps.ScoreboardSnapshot;
import red.jackf.whereisit.api.search.ConnectedBlocksGrabber;

@Environment(value=EnvType.CLIENT)
public class HypixelProvider
extends ServerProvider {
    public static final class_2960 SKYBLOCK_PRIVATE_ISLAND = class_2960.method_60655((String)"hypixel", (String)"skyblock_private");
    public static final class_2960 SKYBLOCK_ENDER_CHEST = class_2960.method_60655((String)"hypixel", (String)"skyblock_ender_chest");
    public static final class_2960 SKYBLOCK_BACKBACKS = class_2960.method_60655((String)"hypixel", (String)"skyblock_backpacks");
    public static final class_2960 SKYBLOCK_SACKS = class_2960.method_60655((String)"hypixel", (String)"skyblock_sacks");
    public static final class_2960 SKYBLOCK_VAULT = class_2960.method_60655((String)"hypixel", (String)"skyblock_vault");
    private static final List<MemoryKeyIcon> ICONS = Streams.concat((Stream[])new Stream[]{Stream.of(new MemoryKeyIcon(SKYBLOCK_PRIVATE_ISLAND, class_1802.field_17535.method_7854()), new MemoryKeyIcon(SKYBLOCK_ENDER_CHEST, class_1802.field_8466.method_7854()), new MemoryKeyIcon(SKYBLOCK_BACKBACKS, class_1802.field_8545.method_7854()), new MemoryKeyIcon(SKYBLOCK_SACKS, class_1802.field_27023.method_7854()), new MemoryKeyIcon(SKYBLOCK_VAULT, class_1802.field_8594.method_7854())), ProviderUtils.getDefaultIcons().stream()}).toList();
    private boolean isOnSMP = false;

    @Override
    public class_2960 id() {
        return ChestTracker.id("hypixel");
    }

    @Override
    public boolean appliesTo(Coordinate coordinate) {
        Coordinate.Multiplayer multi;
        return coordinate instanceof Coordinate.Multiplayer && (multi = (Coordinate.Multiplayer)coordinate).address().contains("hypixel.net");
    }

    @Override
    public List<MemoryKeyIcon> getMemoryKeyIcons() {
        return ICONS;
    }

    @Override
    public void onGameMessageReceived(class_2561 message, boolean isOverlay) {
        if (SMP.isSMPJoinMessage(message)) {
            this.isOnSMP = true;
        }
    }

    @Override
    public void onRespawn(class_5321<class_1937> from, class_5321<class_1937> to) {
        Optional scoreboard = ScoreboardSnapshot.take();
        if (scoreboard.isEmpty()) {
            return;
        }
        Optional lastRow = ((ScoreboardSnapshot)scoreboard.get()).entryFromBottom(0);
        if (lastRow.isEmpty()) {
            return;
        }
        if (((class_2561)((Pair)lastRow.get()).getFirst()).getString().contains("www.hypixel.net")) {
            this.isOnSMP = false;
        }
    }

    @Override
    public void onDisconnect() {
        this.isOnSMP = false;
    }

    @Override
    public void onScreenOpen(ScreenOpenContext context) {
        InteractionTracker.INSTANCE.getLastBlockSource().flatMap(this::getMemoryLocation).ifPresent(context::setMemoryLocation);
    }

    @Override
    public void onScreenClose(ScreenCloseContext context) {
        MemoryBank bank = MemoryBankAccess.INSTANCE.getLoaded().orElse(null);
        if (bank == null) {
            return;
        }
        if (Skyblock.isPlayerOn()) {
            Memory memory;
            List<class_1799> items;
            Optional<Integer> page;
            Optional<MemoryLocation> location;
            Optional<ClientBlockSource> cbs;
            if (Skyblock.isOnPrivateIsland() && (cbs = InteractionTracker.INSTANCE.getLastBlockSource()).isPresent() && (location = this.getMemoryLocation(cbs.get())).isPresent() && (cbs.get().blockState().method_27852(class_2246.field_10034) || cbs.get().blockState().method_27852(class_2246.field_10380))) {
                List connectedBlocks = ConnectedBlocksGrabber.getConnected((class_1937)cbs.get().level(), (class_2680)cbs.get().blockState(), (class_2338)cbs.get().pos());
                class_2338 rootPos = (class_2338)connectedBlocks.get(0);
                Memory memory2 = MemoryBuilder.create(context.getItemsMatching(stack -> !stack.method_7964().getString().isBlank())).inContainer(cbs.get().blockState().method_26204()).otherPositions(connectedBlocks.stream().skip(1L).toList()).build();
                bank.addMemory(location.get().memoryKey(), rootPos, memory2);
                return;
            }
            if (context.getTitle().getString().startsWith("Ender Chest") && (page = Skyblock.getEnderChestPage(context.getTitle())).isPresent()) {
                items = Skyblock.getEnderChestItems(context);
                memory = MemoryBuilder.create(items).inContainer(class_2246.field_10443).build();
                bank.addMemory(SKYBLOCK_ENDER_CHEST, new class_2338(page.get().intValue(), 0, 0), memory);
            }
            if (context.getTitle().getString().contains("Backpack") && (page = Skyblock.getBackPackSlot(context.getTitle())).isPresent()) {
                items = Skyblock.getBackPackItems(context);
                memory = MemoryBuilder.create(items).inContainer(class_2246.field_10603).build();
                bank.addMemory(SKYBLOCK_BACKBACKS, new class_2338(page.get().intValue(), 0, 0), memory);
            }
            if (context.getTitle().getString().contains("Sack")) {
                if (context.getTitle().getString().contains("Sack of Sacks")) {
                    return;
                }
                class_2338 fakePosition = Skyblock.getFakePosForSackType(context.getTitle());
                items = Skyblock.getSackItems(context);
                memory = MemoryBuilder.create(items).inContainer(class_2248.method_9503((class_1792)class_1802.field_27023)).build();
                bank.addMemory(SKYBLOCK_SACKS, fakePosition, memory);
            }
            if (context.getTitle().getString().contains("Personal Vault") && (page = Skyblock.getPersonalVault(context.getTitle())).isPresent()) {
                items = Skyblock.getPersonalVaultItems(context);
                memory = MemoryBuilder.create(items).inContainer(class_2248.method_9503((class_1792)class_1802.field_8594)).build();
                bank.addMemory(SKYBLOCK_VAULT, new class_2338(page.get().intValue(), 0, 0), memory);
            }
        } else if (this.isOnSMP) {
            DefaultProvider.INSTANCE.onScreenClose(context);
        }
    }

    @Override
    public Optional<MemoryLocation> getMemoryLocation(ClientBlockSource cbs) {
        if (Skyblock.isOnPrivateIsland()) {
            return Optional.of(MemoryLocation.inWorld(SKYBLOCK_PRIVATE_ISLAND, cbs.pos()));
        }
        if (this.isOnSMP) {
            return DefaultProvider.INSTANCE.getMemoryLocation(cbs);
        }
        return Optional.empty();
    }

    @Override
    public Optional<class_2960> getPlayersCurrentKey(class_1937 level, class_746 player) {
        if (Skyblock.isOnPrivateIsland()) {
            return Optional.of(SKYBLOCK_PRIVATE_ISLAND);
        }
        if (this.isOnSMP) {
            return DefaultProvider.INSTANCE.getPlayersCurrentKey(level, player);
        }
        return Optional.empty();
    }

    @Override
    public void addDebugInformation(Consumer<String> reciever) {
        if (Skyblock.isPlayerOn()) {
            reciever.accept("On Skyblock");
            reciever.accept("Area: " + Skyblock.getArea().orElse("<unknown>"));
        } else if (this.isOnSMP) {
            reciever.accept("On SMP");
        }
    }
}

