/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.FileBasedBackend;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class JsonBackend
extends FileBasedBackend {
    private static final Logger LOGGER = LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/JSON"));

    @Override
    public String extension() {
        return ".json";
    }

    @Override
    @Nullable
    public MemoryBankImpl load(String id, @Nullable class_7225.class_7874 registries) {
        JsonOps ops = registries == null ? JsonOps.INSTANCE : registries.method_57093((DynamicOps)JsonOps.INSTANCE);
        Optional<Metadata> metadata = this.loadMetadata(id);
        if (metadata.isEmpty()) {
            return null;
        }
        Path dataPath = Constants.STORAGE_DIR.resolve(id + this.extension());
        Pair<Map, Long> result = Misc.time(() -> JsonBackend.lambda$load$0(dataPath, (DynamicOps)ops));
        HashMap<class_2960, MemoryKeyImpl> data = result.getFirst() == null ? new HashMap() : (Map)result.getFirst();
        LOGGER.debug("Loaded {} in {}ns", (Object)dataPath, result.getSecond());
        return new MemoryBankImpl(metadata.get(), data);
    }

    @Override
    public boolean save(MemoryBankImpl memoryBank, @Nullable class_7225.class_7874 registries) {
        LOGGER.debug("Saving {}", (Object)memoryBank.getId());
        JsonOps ops = registries == null ? JsonOps.INSTANCE : registries.method_57093((DynamicOps)JsonOps.INSTANCE);
        memoryBank.getMetadata().updateModified();
        boolean metaSaveSuccess = this.saveMetadata(memoryBank.getId(), memoryBank.getMetadata());
        if (!metaSaveSuccess) {
            return false;
        }
        Path path = Constants.STORAGE_DIR.resolve(memoryBank.getId() + this.extension());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Optional memoryJson = MemoryBankImpl.DATA_CODEC.encodeStart((DynamicOps)ops, memoryBank.getMemories()).resultOrPartial(class_156.method_29188((String)"Error encoding memories", arg_0 -> ((Logger)LOGGER).error(arg_0)));
            if (memoryJson.isPresent()) {
                FileUtils.write((File)path.toFile(), (CharSequence)FileUtil.gson().toJson((JsonElement)memoryJson.get()), (Charset)StandardCharsets.UTF_8);
                return true;
            }
            LOGGER.error("Unknown error encoding memories");
        }
        catch (IOException ex) {
            LOGGER.error("Error saving memories", (Throwable)ex);
        }
        return false;
    }

    private static /* synthetic */ Map lambda$load$0(Path dataPath, DynamicOps ops) {
        if (Files.isRegularFile(dataPath, new LinkOption[0])) {
            try {
                String str = FileUtils.readFileToString((File)dataPath.toFile(), (Charset)StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)FileUtil.gson().fromJson(str, JsonElement.class);
                DataResult decoded = MemoryBankImpl.DATA_CODEC.decode(ops, (Object)json);
                if (decoded.isError()) {
                    throw new IOException("Invalid Memories JSON: %s".formatted(((DataResult.Error)decoded.error().get()).message()));
                }
                return (Map)((Pair)decoded.result().get()).getFirst();
            }
            catch (JsonParseException | IOException ex) {
                LOGGER.error("Error loading %s".formatted(dataPath), ex);
                FileUtil.tryMove(dataPath, dataPath.resolveSibling(String.valueOf(dataPath.getFileName()) + ".corrupt"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return null;
    }
}

