/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.CommandLoggerPlugin;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/commands/BanIpCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "clp", "Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nBanIpCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BanIpCommand.kt\npl/syntaxdevteam/punisher/commands/BanIpCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n4244#3:129\n4344#3,2:130\n1869#4,2:132\n1869#4,2:134\n1869#4,2:136\n774#4:138\n865#4,2:139\n1869#4,2:141\n1563#4:143\n1634#4,3:144\n*S KotlinDebug\n*F\n+ 1 BanIpCommand.kt\npl/syntaxdevteam/punisher/commands/BanIpCommand\n*L\n57#1:129\n57#1:130,2\n68#1:132,2\n89#1:134,2\n98#1:136,2\n100#1:138\n100#1:139,2\n101#1:141,2\n109#1:143\n109#1:144,3\n*E\n"})
public final class BanIpCommand
implements BasicCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final CommandLoggerPlugin clp;
    @NotNull
    private static final Regex IP_REGEX = new Regex("\\d+\\.\\d+\\.\\d+\\.\\d+");
    @NotNull
    private static final Regex UUID_REGEX = new Regex("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");

    public BanIpCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.clp = this.plugin.getCommandLoggerPlugin();
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        void $this$filterTo$iv$iv;
        Long l;
        Long l2;
        String timeArg;
        void $this$filterNotTo$iv$iv;
        Player targetPlayer;
        UUID targetUUID;
        UUID uUID;
        Object it;
        Object it2;
        Object object2;
        List<String> playerIPs;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.BANIP)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no_permission", null, (int)4, null));
            return;
        }
        if (args.length < 2) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"banip", (String)"usage", null, (int)4, null));
            return;
        }
        String rawTarget = args[0];
        boolean isForce = ArraysKt.contains(args, "--force");
        if (IP_REGEX.matches(rawTarget)) {
            v1 = CollectionsKt.listOf(rawTarget);
        } else if (UUID_REGEX.matches(rawTarget)) {
            v1 = this.plugin.getPlayerIPManager().getPlayerIPsByUUID(rawTarget);
        } else {
            PlayerIPManager playerIPManager = this.plugin.getPlayerIPManager();
            String string = rawTarget.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            v1 = playerIPs = playerIPManager.getPlayerIPsByName(string);
        }
        if (playerIPs.isEmpty()) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"banip", (String)"not_found", null, (int)4, null));
            return;
        }
        if (IP_REGEX.matches(rawTarget)) {
            Object v4;
            block32: {
                Iterable iterable = this.plugin.getPlayerIPManager().getAllDecryptedRecords();
                for (Object object2 : iterable) {
                    it2 = (PlayerIPManager.PlayerInfo)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(((PlayerIPManager.PlayerInfo)it2).getPlayerIP(), rawTarget)) continue;
                    v4 = object2;
                    break block32;
                }
                v4 = null;
            }
            PlayerIPManager.PlayerInfo playerInfo = v4;
            if (playerInfo != null) {
                it = playerInfo;
                boolean bl = false;
                uUID = UUID.fromString(((PlayerIPManager.PlayerInfo)it).getPlayerUUID());
            } else {
                uUID = null;
            }
        } else {
            uUID = this.plugin.resolvePlayerUuid(rawTarget);
        }
        UUID uUID2 = targetUUID = uUID;
        if (uUID2 != null) {
            it = uUID2;
            boolean bl = false;
            v7 = Bukkit.getPlayer((UUID)it);
        } else {
            v7 = targetPlayer = null;
        }
        if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_BANIP)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", rawTarget))));
            return;
        }
        String[] $this$filterNot$iv = args;
        boolean $i$f$filterNot = false;
        object2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it3 = element$iv$iv = $this$filterNotTo$iv$iv[i];
            boolean bl = false;
            if (Intrinsics.areEqual(it3, "--force")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        String string = timeArg = (String)CollectionsKt.getOrNull(filtered, 1);
        if (string != null) {
            Long l3;
            it2 = string;
            boolean bl = false;
            try {
                l3 = this.plugin.getTimeHandler().parseTime((String)it2);
            }
            catch (Exception exception) {
                l3 = null;
            }
            l2 = l3;
        } else {
            l2 = null;
        }
        Long durationSec = l2;
        String reason = durationSec != null ? CollectionsKt.joinToString$default(CollectionsKt.drop(filtered, 2), " ", null, null, 0, null, null, 62, null) : CollectionsKt.joinToString$default(CollectionsKt.drop(filtered, 1), " ", null, null, 0, null, null, 62, null);
        long start = System.currentTimeMillis();
        Long l4 = durationSec;
        if (l4 != null) {
            long it4 = ((Number)l4).longValue();
            boolean bl = false;
            l = start + it4 * (long)1000;
        } else {
            l = null;
        }
        Long end = l;
        boolean dbError = false;
        Iterable $this$forEach$iv = playerIPs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String ip = (String)element$iv;
            boolean bl = false;
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string2 = stack.getSender().getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            Long l5 = end;
            boolean success = databaseHandler.addPunishment(rawTarget, ip, reason, string2, "BANIP", start, l5 != null ? l5 : -1L);
            if (!success) {
                this.plugin.getLogger().err("DB error ban-ip " + (String)ip);
                dbError = true;
                Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)("ban-ip " + (String)ip));
            }
            DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
            String string3 = stack.getSender().getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            Long l6 = end;
            databaseHandler2.addPunishmentHistory(rawTarget, ip, reason, string3, "BANIP", start, l6 != null ? l6 : -1L);
        }
        String string4 = stack.getSender().getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        this.clp.logCommand(string4, "BANIP", rawTarget, reason);
        if (dbError) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"db_error", null, (int)4, null));
        }
        if (targetPlayer != null) {
            Pair[] $i$f$forEach2 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(timeArg))};
            List lines = this.plugin.getMessageHandler().getSmartMessage("banip", "kick_message", MapsKt.mapOf($i$f$forEach2));
            TextComponent.Builder builder = Component.text();
            Intrinsics.checkNotNullExpressionValue(builder, "text(...)");
            TextComponent.Builder builder2 = builder;
            Iterable $this$forEach$iv2 = lines;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Component it5 = (Component)element$iv;
                boolean bl = false;
                ((TextComponent.Builder)builder2.append(it5)).append((Component)Component.newline());
            }
            targetPlayer.kick((Component)builder2.build());
        }
        Pair[] builder2 = new Pair[]{TuplesKt.to("player", rawTarget), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(timeArg))};
        List msgLines = this.plugin.getMessageHandler().getSmartMessage("banip", "ban", MapsKt.mapOf(builder2));
        Iterable $this$forEach$iv3 = msgLines;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Component it6 = (Component)element$iv;
            boolean bl = false;
            stack.getSender().sendMessage(it6);
        }
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable $i$f$forEach3 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it7 = (Player)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it7);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)it7, PermissionChecker.PermissionKey.SEE_BANIP)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv4 = msgLines;
            boolean $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv4) {
                Component it8 = (Component)element$iv2;
                boolean bl2 = false;
                player.sendMessage(it8);
            }
        }
        if (isForce) {
            this.plugin.getLogger().warning("Force by " + stack.getSender().getName() + " on " + rawTarget);
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        if (!PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)((Player)commandSender), PermissionChecker.PermissionKey.BANIP)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-BanIpCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getReasons("banip", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lpl/syntaxdevteam/punisher/commands/BanIpCommand$Companion;", "", "<init>", "()V", "IP_REGEX", "Lkotlin/text/Regex;", "UUID_REGEX", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

