/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.core.messaging.MessageHandler;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/commands/HistoryCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nHistoryCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryCommand.kt\npl/syntaxdevteam/punisher/commands/HistoryCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1869#2,2:113\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 HistoryCommand.kt\npl/syntaxdevteam/punisher/commands/HistoryCommand\n*L\n83#1:113,2\n107#1:115\n107#1:116,3\n*E\n"})
public final class HistoryCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final PlayerIPManager playerIPManager;
    @NotNull
    private final SimpleDateFormat dateFormat;

    public HistoryCommand(@NotNull PunisherX plugin, @NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(playerIPManager, "playerIPManager");
        this.plugin = plugin;
        this.playerIPManager = playerIPManager;
        this.dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        block12: {
            block10: {
                Object object;
                String playerIP;
                String title;
                String times;
                String reasons;
                String types;
                String id;
                List<PunishmentData> punishments;
                String targetPlayer;
                UUID uuid;
                int page;
                String player;
                block14: {
                    block13: {
                        block11: {
                            String string;
                            int n;
                            block9: {
                                Intrinsics.checkNotNullParameter(stack, "stack");
                                Intrinsics.checkNotNullParameter(args, "args");
                                if (args.length == 0) {
                                    stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"usage", null, (int)4, null));
                                    return;
                                }
                                player = args[0];
                                if (StringsKt.equals(player, stack.getSender().getName(), true)) break block9;
                                CommandSender commandSender = stack.getSender();
                                Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
                                if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.HISTORY)) break block10;
                            }
                            if (args.length > 1) {
                                Integer n2 = StringsKt.toIntOrNull(args[1]);
                                n = n2 != null ? n2 : 1;
                            } else {
                                n = 1;
                            }
                            page = n;
                            int limit = 10;
                            int offset = (page - 1) * limit;
                            uuid = this.plugin.resolvePlayerUuid(player);
                            Player player2 = Bukkit.getPlayer((String)player);
                            if ((player2 != null ? player2.getName() : null) == null) {
                                string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                            } else {
                                Player player3 = Bukkit.getPlayer((String)player);
                                string = player3 != null ? player3.getName() : null;
                            }
                            targetPlayer = string;
                            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                            String string2 = uuid.toString();
                            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                            punishments = databaseHandler.getPunishmentHistory(string2, limit, offset);
                            if (!punishments.isEmpty()) break block11;
                            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("history", "no_punishments", MapsKt.mapOf(TuplesKt.to("player", player))));
                            break block12;
                        }
                        id = MessageHandler.getCleanMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"id", null, (int)4, null);
                        types = MessageHandler.getCleanMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"type", null, (int)4, null);
                        reasons = MessageHandler.getCleanMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"reason", null, (int)4, null);
                        times = MessageHandler.getCleanMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"time", null, (int)4, null);
                        title = MessageHandler.getCleanMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"title", null, (int)4, null);
                        playerIP = this.playerIPManager.getPlayerIPByName(player);
                        this.plugin.getLogger().debug("Player IP: " + playerIP);
                        object = playerIP;
                        if (object == null) break block13;
                        String ip = object;
                        boolean bl = false;
                        String country = this.playerIPManager.getGeoIPHandler().getCountry(ip);
                        String city = this.playerIPManager.getGeoIPHandler().getCity(ip);
                        this.plugin.getLogger().debug("Country: " + country + ", City: " + city);
                        String string = city + ", " + country;
                        object = string;
                        if (string != null) break block14;
                    }
                    object = "Unknown location";
                }
                String geoLocation = object;
                this.plugin.getLogger().debug("GeoLocation: " + geoLocation);
                String fullGeoLocation = stack.getSender().hasPermission("punisherx.view_ip") ? playerIP + " (" + geoLocation + ")" : geoLocation;
                String gamer = Intrinsics.areEqual(stack.getSender().getName(), "CONSOLE") ? "<gold>" + targetPlayer + " <gray>[" + uuid + ", " + fullGeoLocation + "]</gray>:</gold>" : "<gold><hover:show_text:'[<white>" + uuid + ", " + fullGeoLocation + "</white>]'>" + targetPlayer + ":</gold>";
                MessageHandler mh = this.plugin.getMessageHandler();
                Component topHeader = mh.miniMessageFormat("<blue>--------------------------------------------------</blue>");
                Component header = mh.miniMessageFormat("<blue>|    " + title + " " + gamer + "</blue>");
                Component tableHeader = mh.miniMessageFormat("<blue>|   " + id + "  |  " + types + "  |  " + reasons + "  |  " + times + "</blue>");
                Component br = mh.miniMessageFormat("<blue> </blue>");
                Component hr = mh.miniMessageFormat("<blue>|</blue>");
                stack.getSender().sendMessage(br);
                stack.getSender().sendMessage(header);
                stack.getSender().sendMessage(topHeader);
                stack.getSender().sendMessage(tableHeader);
                stack.getSender().sendMessage(hr);
                Iterable $this$forEach$iv = punishments;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PunishmentData punishment = (PunishmentData)element$iv;
                    boolean bl = false;
                    String formattedDate = this.dateFormat.format(new Date(punishment.getStart()));
                    Component punishmentMessage = mh.miniMessageFormat("<blue>|   <white>#" + punishment.getId() + "</white> <blue>|</blue> <white>" + punishment.getType() + "</white> <blue>|</blue> <white>" + punishment.getReason() + "</white> <blue>|</blue> <white>" + formattedDate + "</blue>");
                    stack.getSender().sendMessage(punishmentMessage);
                }
                stack.getSender().sendMessage(hr);
                int nextPage = page + 1;
                int prevPage = page > 1 ? page - 1 : 1;
                Component navigation = mh.miniMessageFormat("<blue>| <click:run_command:'/history " + player + " " + prevPage + "'>[Previous]</click>   <click:run_command:'/history " + player + " " + nextPage + "'>[Next]</click> </blue>");
                stack.getSender().sendMessage(navigation);
                break block12;
            }
            stack.getSender().sendMessage(MessageHandler.getMessage$default((MessageHandler)this.plugin.getMessageHandler(), (String)"history", (String)"no_permission", null, (int)4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.HISTORY)) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

