/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ4\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lpl/syntaxdevteam/punisher/common/TeleportUtils;", "", "<init>", "()V", "isFolia", "", "runAsync", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "task", "Ljava/lang/Runnable;", "runSync", "runSyncLater", "delayTicks", "", "teleportSafely", "player", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "callback", "Lkotlin/Function1;", "isLocationSafe", "isSafeBodyBlock", "block", "Lorg/bukkit/block/Block;", "allowSolid", "isSafeFloor", "PunisherX"})
public final class TeleportUtils {
    @NotNull
    public static final TeleportUtils INSTANCE = new TeleportUtils();

    private TeleportUtils() {
    }

    public final boolean isFolia() {
        String string = Bukkit.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.contains((CharSequence)string, "Folia", true);
    }

    public final void runAsync(@NotNull Plugin plugin, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.isFolia()) {
            Bukkit.getServer().getGlobalRegionScheduler().execute(plugin, task);
        } else {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskAsynchronously(plugin, task);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    public final void runSync(@NotNull Plugin plugin, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.isFolia()) {
            Bukkit.getServer().getGlobalRegionScheduler().execute(plugin, () -> TeleportUtils.runSync$lambda$0(task));
        } else {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTask(plugin, task);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    public final void runSyncLater(@NotNull Plugin plugin, long delayTicks, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.isFolia()) {
            ScheduledTask scheduledTask = Bukkit.getServer().getGlobalRegionScheduler().runDelayed(plugin, arg_0 -> TeleportUtils.runSyncLater$lambda$0(task, arg_0), delayTicks);
            Intrinsics.checkNotNull(scheduledTask);
        } else {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater(plugin, task, delayTicks);
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    public final void teleportSafely(@NotNull Plugin plugin, @NotNull Player player, @NotNull Location location, @NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(callback, "callback");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location target = location2;
        if (this.isFolia()) {
            Bukkit.getServer().getRegionScheduler().execute(plugin, target, () -> TeleportUtils.teleportSafely$lambda$1(target, plugin, callback, player));
        } else {
            this.runSync(plugin, () -> TeleportUtils.teleportSafely$lambda$2(target, callback, player));
        }
    }

    public static /* synthetic */ void teleportSafely$default(TeleportUtils teleportUtils, Plugin plugin, Player player, Location location, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = TeleportUtils::teleportSafely$lambda$0;
        }
        teleportUtils.teleportSafely(plugin, player, location, function1);
    }

    private final boolean isLocationSafe(Location location) {
        boolean allowSolidFeet;
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        World world2 = world;
        Block block = world2.getBlockAt(location);
        Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
        Block feetBlock = block;
        Block block2 = feetBlock.getRelative(BlockFace.UP);
        Intrinsics.checkNotNullExpressionValue(block2, "getRelative(...)");
        Block headBlock = block2;
        Block block3 = feetBlock.getRelative(BlockFace.DOWN);
        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
        Block belowBlock = block3;
        double yOffset = location.getY() - (double)location.getBlockY();
        boolean bl = allowSolidFeet = Math.abs(yOffset) < 0.001;
        if (!this.isSafeBodyBlock(feetBlock, allowSolidFeet) || !this.isSafeBodyBlock(headBlock, false)) {
            return false;
        }
        return this.isSafeFloor(belowBlock);
    }

    private final boolean isSafeBodyBlock(Block block, boolean allowSolid) {
        Material material = block.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material type = material;
        if (type == Material.LAVA || type == Material.FIRE || type == Material.CACTUS || type == Material.SWEET_BERRY_BUSH || type == Material.CAMPFIRE || type == Material.SOUL_CAMPFIRE || type == Material.MAGMA_BLOCK || type == Material.WATER || type == Material.BUBBLE_COLUMN || type == Material.POWDER_SNOW) {
            return false;
        }
        if (block.isPassable() || type == Material.AIR) {
            return true;
        }
        return allowSolid && type.isSolid();
    }

    private final boolean isSafeFloor(Block block) {
        Material material = block.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material type = material;
        if (type == Material.AIR || !type.isSolid()) {
            return false;
        }
        return type != Material.LAVA && type != Material.FIRE && type != Material.WATER && type != Material.MAGMA_BLOCK && type != Material.CAMPFIRE && type != Material.SOUL_CAMPFIRE;
    }

    private static final void runSync$lambda$0(Runnable $task) {
        $task.run();
    }

    private static final void runSyncLater$lambda$0(Runnable $task, ScheduledTask it) {
        $task.run();
    }

    private static final Unit teleportSafely$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final void teleportSafely$lambda$1(Location $target, Plugin $plugin, Function1 $callback, Player $player) {
        if (!$target.getChunk().isLoaded()) {
            $target.getChunk().load();
        }
        if (!INSTANCE.isLocationSafe($target)) {
            Bukkit.getServer().getGlobalRegionScheduler().execute($plugin, () -> TeleportUtils.teleportSafely$lambda$1$0($callback));
            return;
        }
        Bukkit.getServer().getGlobalRegionScheduler().execute($plugin, () -> TeleportUtils.teleportSafely$lambda$1$1($player, $target, $callback));
    }

    private static final void teleportSafely$lambda$1$0(Function1 $callback) {
        $callback.invoke(false);
    }

    private static final void teleportSafely$lambda$1$1(Player $player, Location $target, Function1 $callback) {
        ((CompletableFuture)$player.teleportAsync($target).thenAccept(arg_0 -> TeleportUtils.teleportSafely$lambda$1$1$1(arg_0 -> TeleportUtils.teleportSafely$lambda$1$1$0($callback, arg_0), arg_0))).exceptionally(arg_0 -> TeleportUtils.teleportSafely$lambda$1$1$2($callback, arg_0));
    }

    private static final Unit teleportSafely$lambda$1$1$0(Function1 $callback, Boolean result) {
        Intrinsics.checkNotNull(result);
        $callback.invoke(result);
        return Unit.INSTANCE;
    }

    private static final void teleportSafely$lambda$1$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void teleportSafely$lambda$1$1$2(Function1 $callback, Throwable it) {
        $callback.invoke(false);
        return null;
    }

    private static final void teleportSafely$lambda$2(Location $target, Function1 $callback, Player $player) {
        if (!$target.getChunk().isLoaded()) {
            $target.getChunk().load();
        }
        if (!INSTANCE.isLocationSafe($target)) {
            $callback.invoke(false);
            return;
        }
        boolean result = $player.teleport($target);
        $callback.invoke(result);
    }
}

