/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.listeners;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.connection.PlayerLoginConnection;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "decisionTtl", "", "pendingDecisions", "", "", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$PendingDecision;", "onPreLogin", "", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onValidateLogin", "Lio/papermc/paper/event/connection/PlayerConnectionValidateLoginEvent;", "cleanupDecisions", "evaluatePunishments", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction;", "uuid", "Ljava/util/UUID;", "playerName", "ip", "PendingDecision", "LoginAction", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nModernLoginListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModernLoginListener.kt\npl/syntaxdevteam/punisher/listeners/ModernLoginListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n1869#3:162\n1869#3,2:163\n1870#3:165\n*S KotlinDebug\n*F\n+ 1 ModernLoginListener.kt\npl/syntaxdevteam/punisher/listeners/ModernLoginListener\n*L\n113#1:162\n137#1:163,2\n113#1:165\n*E\n"})
public final class ModernLoginListener
implements Listener {
    @NotNull
    private final PunisherX plugin;
    private final long decisionTtl;
    @NotNull
    private final Map<String, PendingDecision> pendingDecisions;

    public ModernLoginListener(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.decisionTtl = Duration.ofSeconds(30L).toMillis();
        this.pendingDecisions = new ConcurrentHashMap();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPreLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        block6: {
            Intrinsics.checkNotNullParameter(event, "event");
            this.cleanupDecisions();
            if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                this.plugin.getLogger().debug("ModernLogin(pre): existing login result " + event.getLoginResult() + " for " + event.getName() + " \u2192 keep as is");
                return;
            }
            String string = event.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String playerName = string;
            String ip = event.getAddress().getHostAddress();
            CharSequence charSequence = ip;
            if (charSequence == null || StringsKt.isBlank(charSequence)) {
                this.plugin.getLogger().debug("ModernLogin(pre): brak adresu IP dla " + playerName + " \u2192 leaving result " + event.getLoginResult());
                return;
            }
            try {
                UUID uuid = this.plugin.resolvePlayerUuid(playerName);
                LoginAction action = this.evaluatePunishments(uuid, playerName, ip);
                if (action instanceof LoginAction.Allow) {
                    String string2 = playerName;
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                    this.pendingDecisions.remove(string3);
                    break block6;
                }
                if (action instanceof LoginAction.Deny) {
                    String string4 = playerName;
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                    String string5 = string4.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                    String cacheKey = string5;
                    this.pendingDecisions.put(cacheKey, new PendingDecision(((LoginAction.Deny)action).getMessage(), System.currentTimeMillis() + this.decisionTtl));
                    event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, ((LoginAction.Deny)action).getMessage());
                    break block6;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Error during async login check for " + playerName + ": " + ex.getMessage());
                ex.printStackTrace();
                this.plugin.getLogger().debug("ModernLogin(pre): exception encountered \u2192 leaving result " + event.getLoginResult());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onValidateLogin(@NotNull PlayerConnectionValidateLoginEvent event) {
        PendingDecision decision;
        String playerName;
        PlayerProfile profile;
        Intrinsics.checkNotNullParameter(event, "event");
        this.cleanupDecisions();
        Object object = event.getConnection();
        PlayerLoginConnection playerLoginConnection = object instanceof PlayerLoginConnection ? (PlayerLoginConnection)object : null;
        if (playerLoginConnection == null) {
            ModernLoginListener $this$onValidateLogin_u24lambda_u240 = this;
            boolean bl = false;
            $this$onValidateLogin_u24lambda_u240.plugin.getLogger().debug("ModernLogin: brak PlayerLoginConnection \u2192 leaving existing decision");
            return;
        }
        PlayerLoginConnection loginConn = playerLoginConnection;
        PlayerProfile playerProfile = loginConn.getUnsafeProfile();
        if (playerProfile == null) {
            playerProfile = loginConn.getAuthenticatedProfile();
        }
        PlayerProfile playerProfile2 = profile = playerProfile;
        object = playerProfile2 != null ? playerProfile2.getName() : null;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            this.plugin.getLogger().debug("ModernLogin: brak nazwy profilu \u2192 leaving existing decision");
            return;
        }
        String string = profile.getName();
        Intrinsics.checkNotNull(string);
        String bl = playerName = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = bl.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String cacheKey = string2;
        PendingDecision pendingDecision = this.pendingDecisions.remove(cacheKey);
        if (pendingDecision != null) {
            PendingDecision pendingDecision2;
            PendingDecision it = pendingDecision2 = pendingDecision;
            boolean bl2 = false;
            v7 = !it.isExpired(System.currentTimeMillis()) ? pendingDecision2 : null;
        } else {
            v7 = decision = null;
        }
        if (decision != null) {
            event.kickMessage(decision.getMessage());
            event.getConnection().disconnect(decision.getMessage());
            return;
        }
        this.plugin.getLogger().debug("ModernLogin(validate): no cached decision for " + playerName + " \u2192 leaving existing result");
    }

    private final void cleanupDecisions() {
        long now = System.currentTimeMillis();
        this.pendingDecisions.entrySet().removeIf(arg_0 -> ModernLoginListener.cleanupDecisions$lambda$1(arg_0 -> ModernLoginListener.cleanupDecisions$lambda$0(now, arg_0), arg_0));
    }

    private final LoginAction evaluatePunishments(UUID uuid, String playerName, String ip) {
        this.plugin.getLogger().debug("Checking punishment for player: " + playerName);
        DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        List punishments = CollectionsKt.plus((Collection)DatabaseHandler.getPunishments$default(databaseHandler, string, null, null, 6, null), (Iterable)this.plugin.getDatabaseHandler().getPunishmentsByIP(ip));
        if (punishments.isEmpty()) {
            this.plugin.getLogger().debug("No punishments found for player: " + playerName);
            return LoginAction.Allow.INSTANCE;
        }
        Iterable $this$forEach$iv = punishments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PunishmentData punishment = (PunishmentData)element$iv;
            boolean bl = false;
            if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                TextComponent.Builder builder;
                List list;
                if (!Intrinsics.areEqual(punishment.getType(), "BAN") && !Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                long endTime = punishment.getEnd();
                long remainingSecs = endTime == -1L ? -1L : (endTime - System.currentTimeMillis()) / (long)1000;
                String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingSecs));
                String reason = punishment.getReason();
                String string2 = punishment.getType();
                if (Intrinsics.areEqual(string2, "BAN")) {
                    var18_16 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                    list = this.plugin.getMessageHandler().getSmartMessage("ban", "kick_message", MapsKt.mapOf(var18_16));
                } else if (Intrinsics.areEqual(string2, "BANIP")) {
                    var18_16 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                    list = this.plugin.getMessageHandler().getSmartMessage("banip", "kick_message", MapsKt.mapOf(var18_16));
                } else {
                    list = CollectionsKt.emptyList();
                }
                List kickLines = list;
                TextComponent.Builder builder2 = builder = Component.text();
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = kickLines;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Component line = (Component)element$iv2;
                    boolean bl3 = false;
                    ((TextComponent.Builder)builder2.append(line)).append((Component)Component.newline());
                }
                BuildableComponent buildableComponent = builder.build();
                Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
                TextComponent kickMessage = (TextComponent)buildableComponent;
                this.plugin.getLogger().debug("Player " + playerName + " was kicked for: " + reason);
                return new LoginAction.Deny((Component)kickMessage);
            }
            DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
            String string3 = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            databaseHandler2.removePunishment(string3, punishment.getType(), true);
            this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
        }
        return LoginAction.Allow.INSTANCE;
    }

    private static final boolean cleanupDecisions$lambda$0(long $now, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((PendingDecision)it.getValue()).isExpired($now);
    }

    private static final boolean cleanupDecisions$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction;", "", "Allow", "Deny", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction$Allow;", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction$Deny;", "PunisherX"})
    private static sealed interface LoginAction {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction$Allow;", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "PunisherX"})
        public static final class Allow
        implements LoginAction {
            @NotNull
            public static final Allow INSTANCE = new Allow();

            private Allow() {
            }

            @NotNull
            public String toString() {
                return "Allow";
            }

            public int hashCode() {
                return 574537760;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Allow)) {
                    return false;
                }
                Allow cfr_ignored_0 = (Allow)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction$Deny;", "Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$LoginAction;", "message", "Lnet/kyori/adventure/text/Component;", "<init>", "(Lnet/kyori/adventure/text/Component;)V", "getMessage", "()Lnet/kyori/adventure/text/Component;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "PunisherX"})
        public static final class Deny
        implements LoginAction {
            @NotNull
            private final Component message;

            public Deny(@NotNull Component message) {
                Intrinsics.checkNotNullParameter(message, "message");
                this.message = message;
            }

            @NotNull
            public final Component getMessage() {
                return this.message;
            }

            @NotNull
            public final Component component1() {
                return this.message;
            }

            @NotNull
            public final Deny copy(@NotNull Component message) {
                Intrinsics.checkNotNullParameter(message, "message");
                return new Deny(message);
            }

            public static /* synthetic */ Deny copy$default(Deny deny, Component component, int n, Object object) {
                if ((n & 1) != 0) {
                    component = deny.message;
                }
                return deny.copy(component);
            }

            @NotNull
            public String toString() {
                return "Deny(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deny)) {
                    return false;
                }
                Deny deny = (Deny)other;
                return Intrinsics.areEqual(this.message, deny.message);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener$PendingDecision;", "", "message", "Lnet/kyori/adventure/text/Component;", "expiresAt", "", "<init>", "(Lnet/kyori/adventure/text/Component;J)V", "getMessage", "()Lnet/kyori/adventure/text/Component;", "getExpiresAt", "()J", "isExpired", "", "now", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "PunisherX"})
    private static final class PendingDecision {
        @NotNull
        private final Component message;
        private final long expiresAt;

        public PendingDecision(@NotNull Component message, long expiresAt) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.message = message;
            this.expiresAt = expiresAt;
        }

        @NotNull
        public final Component getMessage() {
            return this.message;
        }

        public final long getExpiresAt() {
            return this.expiresAt;
        }

        public final boolean isExpired(long now) {
            return now > this.expiresAt;
        }

        @NotNull
        public final Component component1() {
            return this.message;
        }

        public final long component2() {
            return this.expiresAt;
        }

        @NotNull
        public final PendingDecision copy(@NotNull Component message, long expiresAt) {
            Intrinsics.checkNotNullParameter(message, "message");
            return new PendingDecision(message, expiresAt);
        }

        public static /* synthetic */ PendingDecision copy$default(PendingDecision pendingDecision, Component component, long l, int n, Object object) {
            if ((n & 1) != 0) {
                component = pendingDecision.message;
            }
            if ((n & 2) != 0) {
                l = pendingDecision.expiresAt;
            }
            return pendingDecision.copy(component, l);
        }

        @NotNull
        public String toString() {
            return "PendingDecision(message=" + this.message + ", expiresAt=" + this.expiresAt + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + Long.hashCode(this.expiresAt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PendingDecision)) {
                return false;
            }
            PendingDecision pendingDecision = (PendingDecision)other;
            if (!Intrinsics.areEqual(this.message, pendingDecision.message)) {
                return false;
            }
            return this.expiresAt == pendingDecision.expiresAt;
        }
    }
}

