/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.permissions;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lpl/syntaxdevteam/punisher/permissions/PermissionChecker;", "", "<init>", "()V", "AUTHOR_UUID", "Ljava/util/UUID;", "displayName", "", "key", "Lpl/syntaxdevteam/punisher/permissions/PermissionChecker$PermissionKey;", "has", "", "sender", "Lorg/bukkit/command/CommandSender;", "hasWithBypass", "hasWithManage", "hasWithSee", "hasPermissionStartingWith", "prefix", "isAuthor", "uuid", "canBypass", "player", "Lorg/bukkit/entity/Player;", "canManage", "canSee", "legacyToNew", "", "hasWithLegacy", "PermissionKey", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPermissionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionChecker.kt\npl/syntaxdevteam/punisher/permissions/PermissionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,237:1\n1761#2,3:238\n504#3,7:241\n*S KotlinDebug\n*F\n+ 1 PermissionChecker.kt\npl/syntaxdevteam/punisher/permissions/PermissionChecker\n*L\n158#1:238,3\n215#1:241,7\n*E\n"})
public final class PermissionChecker {
    @NotNull
    public static final PermissionChecker INSTANCE = new PermissionChecker();
    @NotNull
    private static final UUID AUTHOR_UUID;
    @NotNull
    private static final Map<String, String> legacyToNew;

    private PermissionChecker() {
    }

    @NotNull
    public final String displayName(@NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        return switch (WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1 -> "Allows using the All PunisherX commands.";
            case 2 -> "Allows banning a player, preventing them from joining the server.";
            case 3 -> "Enables banning a player's IP address, blocking access from that address.";
            case 4 -> "Allows unbanning a player or IP address.";
            case 5 -> "Displays a list of all banned players.";
            case 6 -> "Allows changing the reason for a punishment.";
            case 7 -> "Checks the punishments of a player.";
            case 8 -> "Enables clearing all active penalties for a given player.";
            case 9 -> "Enables checking the entire penalty history of a given player. Not required if the player checks themselves.";
            case 10 -> "Allows jailing a player in a specified location for a set duration.";
            case 11 -> "Enables kicking a player from the server with a specified reason.";
            case 12 -> "Allows muting a player, preventing them from sending messages.";
            case 13 -> "Allows releasing a player from jail.";
            case 14 -> "Allows unmuting a player, restoring their ability to send messages.";
            case 15 -> "Allows warning a player with a specified reason.";
            case 16 -> "Allows removing a warning from a player.";
            case 17 -> "Allows bypassing all punishments.";
            case 18 -> "Allows bypassing warnings.";
            case 19 -> "Allows bypassing mutes.";
            case 20 -> "Allows bypassing bans.";
            case 21 -> "Allows bypassing IP bans.";
            case 22 -> "Allows bypassing jail sentences.";
            case 23 -> "Allows bypassing kicks.";
            case 24 -> "Allows managing the plugin, including setting spawn and jail locations.";
            case 25 -> "Allows you to set your respawn location after serving your prison sentence.";
            case 26 -> "Allows setting the jail location.";
            case 27 -> "Allows viewing all punishments.";
            case 28 -> "Allows viewing ban punishments.";
            case 29 -> "Allows viewing IP ban punishments.";
            case 30 -> "Allows viewing unban punishments.";
            case 31 -> "Allows viewing jail punishments.";
            case 32 -> "Allows viewing unjail punishments.";
            case 33 -> "Allows viewing mute punishments.";
            case 34 -> "Allows viewing unmute punishments.";
            case 35 -> "Allows viewing warn punishments.";
            case 36 -> "Allows viewing unwarn punishments.";
            case 37 -> "Allows viewing kick punishments.";
            case 38 -> "Allows viewing update notifications.";
            case 39 -> "Allows using the /punisherx and /prx command.";
            case 40 -> "Allows using the /panel command to open the PunisherX GUI.";
            case 41 -> "Allows viewing the player's IP in the /check and /history command.";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean has(@NotNull CommandSender sender, @NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)key, "key");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("*") || sender.hasPermission("punisherx.*") || sender.hasPermission(PermissionKey.OWNER.getNode())) {
            return true;
        }
        return sender.hasPermission(key.getNode());
    }

    public final boolean hasWithBypass(@NotNull CommandSender sender, @NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)key, "key");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player && Intrinsics.areEqual(((Player)sender).getUniqueId(), AUTHOR_UUID)) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("*") || sender.hasPermission("punisherx.cmd.*")) {
            return true;
        }
        if (sender instanceof Player && this.canBypass((Player)sender)) {
            return true;
        }
        return this.has(sender, key);
    }

    public final boolean hasWithManage(@NotNull CommandSender sender, @NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)key, "key");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player && Intrinsics.areEqual(((Player)sender).getUniqueId(), AUTHOR_UUID)) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("*") || sender.hasPermission("punisherx.manage.*")) {
            return true;
        }
        if (sender instanceof Player && this.canManage((Player)sender)) {
            return true;
        }
        return this.has(sender, key);
    }

    public final boolean hasWithSee(@NotNull CommandSender sender, @NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)key, "key");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player && Intrinsics.areEqual(((Player)sender).getUniqueId(), AUTHOR_UUID)) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("*") || sender.hasPermission("punisherx.see.*")) {
            return true;
        }
        if (sender instanceof Player && this.canSee((Player)sender)) {
            return true;
        }
        return this.has(sender, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasPermissionStartingWith(@NotNull CommandSender sender, @NotNull String prefix) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission(prefix)) return true;
        if (sender.hasPermission(prefix + ".*")) {
            return true;
        }
        if (!(sender instanceof Player)) return false;
        Set set = ((Player)sender).getEffectivePermissions();
        Intrinsics.checkNotNullExpressionValue(set, "getEffectivePermissions(...)");
        Iterable $this$any$iv = set;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            PermissionAttachmentInfo it = (PermissionAttachmentInfo)element$iv;
            boolean bl2 = false;
            if (it.getValue()) {
                String string = it.getPermission();
                Intrinsics.checkNotNullExpressionValue(string, "getPermission(...)");
                if (StringsKt.startsWith$default(string, prefix, false, 2, null)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean isAuthor(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return Intrinsics.areEqual(uuid, AUTHOR_UUID);
    }

    public final boolean canBypass(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.has((CommandSender)player, PermissionKey.BYPASS);
    }

    public final boolean canManage(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.has((CommandSender)player, PermissionKey.MANAGE);
    }

    public final boolean canSee(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.has((CommandSender)player, PermissionKey.SEE);
    }

    public final boolean hasWithLegacy(@NotNull CommandSender sender, @NotNull PermissionKey key) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter((Object)key, "key");
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player && Intrinsics.areEqual(((Player)sender).getUniqueId(), AUTHOR_UUID)) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("*") || sender.hasPermission("punisherx.*")) {
            return true;
        }
        Map<String, String> $this$filterValues$iv = legacyToNew;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterValues$iv.entrySet()) {
            String it = entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual(it, key.getNode())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set legacyKeys = ((Map)result$iv).keySet();
        for (String oldNode : legacyKeys) {
            if (!sender.hasPermission(oldNode)) continue;
            if (sender.hasPermission(key.getNode())) {
                return true;
            }
            if (!StringsKt.startsWith$default(key.getNode(), "punisherx.see", false, 2, null)) {
                String urlTag = "<click:OPEN_URL:https://github.com/SyntaxDevTeam/PunisherX/wiki><blue><u>Click here to view the documentation</u></blue></click>";
                sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)("<yellow>[PunisherX]</yellow> <red>Detected deprecated permission: <gray>" + oldNode + "</gray>\nPlease add the new permission: <hover:show_text:'" + this.displayName(key) + "'><yellow>" + key.getNode() + "</yellow></hover>.\nDeprecated permissions will be removed in version 2.0.\n" + urlTag)));
            }
            return true;
        }
        return this.hasWithBypass(sender, key);
    }

    static {
        UUID uUID = UUID.fromString("248e508c-28de-4a8f-a284-2c73cf917d15");
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        AUTHOR_UUID = uUID;
        Pair[] pairArray = new Pair[]{TuplesKt.to("punisherx.warn", PermissionKey.WARN.getNode()), TuplesKt.to("punisherx.unwarn", PermissionKey.UNWARN.getNode()), TuplesKt.to("punisherx.mute", PermissionKey.MUTE.getNode()), TuplesKt.to("punisherx.unmute", PermissionKey.UNMUTE.getNode()), TuplesKt.to("punisherx.ban", PermissionKey.BAN.getNode()), TuplesKt.to("punisherx.banip", PermissionKey.BANIP.getNode()), TuplesKt.to("punisherx.unban", PermissionKey.UNBAN.getNode()), TuplesKt.to("punisherx.clearall", PermissionKey.CLEAR_ALL.getNode()), TuplesKt.to("punisherx.jail", PermissionKey.JAIL.getNode()), TuplesKt.to("punisherx.unjail", PermissionKey.UNJAIL.getNode()), TuplesKt.to("punisherx.setjail", PermissionKey.MANAGE_SET_JAIL.getNode()), TuplesKt.to("punisherx.kick", PermissionKey.KICK.getNode()), TuplesKt.to("punisherx.check", PermissionKey.CHECK.getNode()), TuplesKt.to("punisherx.view_ip", PermissionKey.VIEW_IP.getNode()), TuplesKt.to("punisherx.history", PermissionKey.HISTORY.getNode()), TuplesKt.to("punisherx.banlist", PermissionKey.BAN_LIST.getNode()), TuplesKt.to("punisherx.prx", PermissionKey.PUNISHERX_COMMAND.getNode()), TuplesKt.to("punisherx.version", PermissionKey.PUNISHERX_COMMAND.getNode()), TuplesKt.to("punisherx.reload", PermissionKey.PUNISHERX_COMMAND.getNode()), TuplesKt.to("punisherx.see.ban", PermissionKey.SEE_BAN.getNode()), TuplesKt.to("punisherx.see.banip", PermissionKey.SEE_BANIP.getNode()), TuplesKt.to("punisherx.see.unban", PermissionKey.SEE_UNBAN.getNode()), TuplesKt.to("punisherx.see.jail", PermissionKey.SEE_JAIL.getNode()), TuplesKt.to("punisherx.see.unjail", PermissionKey.SEE_UNJAIL.getNode()), TuplesKt.to("punisherx.see.mute", PermissionKey.SEE_MUTE.getNode()), TuplesKt.to("punisherx.see.warns", PermissionKey.SEE_WARN.getNode()), TuplesKt.to("punisherx.see.kick", PermissionKey.SEE_KICK.getNode()), TuplesKt.to("punisherx.update.notify", PermissionKey.SEE_UPDATE.getNode()), TuplesKt.to("punisherx.bypass.warn", PermissionKey.BYPASS_WARN.getNode()), TuplesKt.to("punisherx.bypass.mute", PermissionKey.BYPASS_MUTE.getNode()), TuplesKt.to("punisherx.bypass.jail", PermissionKey.BYPASS_JAIL.getNode()), TuplesKt.to("punisherx.bypass.ban", PermissionKey.BYPASS_BAN.getNode()), TuplesKt.to("punisherx.bypass.banip", PermissionKey.BYPASS_BANIP.getNode())};
        legacyToNew = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b/\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00101\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0\u00a8\u00062"}, d2={"Lpl/syntaxdevteam/punisher/permissions/PermissionChecker$PermissionKey;", "", "node", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getNode", "()Ljava/lang/String;", "OWNER", "BAN", "BANIP", "UNBAN", "JAIL", "UNJAIL", "KICK", "MUTE", "UNMUTE", "WARN", "UNWARN", "CHANGE_REASON", "BAN_LIST", "CHECK", "HISTORY", "CLEAR_ALL", "BYPASS", "BYPASS_WARN", "BYPASS_MUTE", "BYPASS_BAN", "BYPASS_BANIP", "BYPASS_JAIL", "BYPASS_KICK", "MANAGE", "MANAGE_SET_SPAWN", "MANAGE_SET_JAIL", "PUNISHERX_COMMAND", "PANELS_COMMAND", "SEE", "SEE_BAN", "SEE_BANIP", "SEE_UNBAN", "SEE_JAIL", "SEE_UNJAIL", "SEE_MUTE", "SEE_UNMUTE", "SEE_WARN", "SEE_UNWARN", "SEE_KICK", "SEE_UPDATE", "VIEW_IP", "toString", "PunisherX"})
    public static final class PermissionKey
    extends Enum<PermissionKey> {
        @NotNull
        private final String node;
        public static final /* enum */ PermissionKey OWNER = new PermissionKey("punisherx.owner");
        public static final /* enum */ PermissionKey BAN = new PermissionKey("punisherx.cmd.ban");
        public static final /* enum */ PermissionKey BANIP = new PermissionKey("punisherx.cmd.banip");
        public static final /* enum */ PermissionKey UNBAN = new PermissionKey("punisherx.cmd.unban");
        public static final /* enum */ PermissionKey JAIL = new PermissionKey("punisherx.cmd.jail");
        public static final /* enum */ PermissionKey UNJAIL = new PermissionKey("punisherx.cmd.unjail");
        public static final /* enum */ PermissionKey KICK = new PermissionKey("punisherx.cmd.kick");
        public static final /* enum */ PermissionKey MUTE = new PermissionKey("punisherx.cmd.mute");
        public static final /* enum */ PermissionKey UNMUTE = new PermissionKey("punisherx.cmd.unmute");
        public static final /* enum */ PermissionKey WARN = new PermissionKey("punisherx.cmd.warn");
        public static final /* enum */ PermissionKey UNWARN = new PermissionKey("punisherx.cmd.unwarn");
        public static final /* enum */ PermissionKey CHANGE_REASON = new PermissionKey("punisherx.cmd.change_reason");
        public static final /* enum */ PermissionKey BAN_LIST = new PermissionKey("punisherx.cmd.banlist");
        public static final /* enum */ PermissionKey CHECK = new PermissionKey("punisherx.cmd.check");
        public static final /* enum */ PermissionKey HISTORY = new PermissionKey("punisherx.cmd.history");
        public static final /* enum */ PermissionKey CLEAR_ALL = new PermissionKey("punisherx.cmd.clear_all");
        public static final /* enum */ PermissionKey BYPASS = new PermissionKey("punisherx.bypass");
        public static final /* enum */ PermissionKey BYPASS_WARN = new PermissionKey("punisherx.bypass.warn");
        public static final /* enum */ PermissionKey BYPASS_MUTE = new PermissionKey("punisherx.bypass.mute");
        public static final /* enum */ PermissionKey BYPASS_BAN = new PermissionKey("punisherx.bypass.ban");
        public static final /* enum */ PermissionKey BYPASS_BANIP = new PermissionKey("punisherx.bypass.banip");
        public static final /* enum */ PermissionKey BYPASS_JAIL = new PermissionKey("punisherx.bypass.jail");
        public static final /* enum */ PermissionKey BYPASS_KICK = new PermissionKey("punisherx.bypass.kick");
        public static final /* enum */ PermissionKey MANAGE = new PermissionKey("punisherx.manage");
        public static final /* enum */ PermissionKey MANAGE_SET_SPAWN = new PermissionKey("punisherx.manage.set_spawn");
        public static final /* enum */ PermissionKey MANAGE_SET_JAIL = new PermissionKey("punisherx.manage.set_jail");
        public static final /* enum */ PermissionKey PUNISHERX_COMMAND = new PermissionKey("punisherx.cmd.prx");
        public static final /* enum */ PermissionKey PANELS_COMMAND = new PermissionKey("punisherx.cmd.panel");
        public static final /* enum */ PermissionKey SEE = new PermissionKey("punisherx.see");
        public static final /* enum */ PermissionKey SEE_BAN = new PermissionKey("punisherx.see.ban");
        public static final /* enum */ PermissionKey SEE_BANIP = new PermissionKey("punisherx.see.banip");
        public static final /* enum */ PermissionKey SEE_UNBAN = new PermissionKey("punisherx.see.unban");
        public static final /* enum */ PermissionKey SEE_JAIL = new PermissionKey("punisherx.see.jail");
        public static final /* enum */ PermissionKey SEE_UNJAIL = new PermissionKey("punisherx.see.unjail");
        public static final /* enum */ PermissionKey SEE_MUTE = new PermissionKey("punisherx.see.mute");
        public static final /* enum */ PermissionKey SEE_UNMUTE = new PermissionKey("punisherx.see.unmute");
        public static final /* enum */ PermissionKey SEE_WARN = new PermissionKey("punisherx.see.warn");
        public static final /* enum */ PermissionKey SEE_UNWARN = new PermissionKey("punisherx.see.unwarn");
        public static final /* enum */ PermissionKey SEE_KICK = new PermissionKey("punisherx.see.kick");
        public static final /* enum */ PermissionKey SEE_UPDATE = new PermissionKey("punisherx.see.update");
        public static final /* enum */ PermissionKey VIEW_IP = new PermissionKey("punisherx.view_ip");
        private static final /* synthetic */ PermissionKey[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PermissionKey(String node) {
            this.node = node;
        }

        @NotNull
        public final String getNode() {
            return this.node;
        }

        @NotNull
        public String toString() {
            return this.node;
        }

        public static PermissionKey[] values() {
            return (PermissionKey[])$VALUES.clone();
        }

        public static PermissionKey valueOf(String value) {
            return Enum.valueOf(PermissionKey.class, value);
        }

        @NotNull
        public static EnumEntries<PermissionKey> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = permissionKeyArray = new PermissionKey[]{PermissionKey.OWNER, PermissionKey.BAN, PermissionKey.BANIP, PermissionKey.UNBAN, PermissionKey.JAIL, PermissionKey.UNJAIL, PermissionKey.KICK, PermissionKey.MUTE, PermissionKey.UNMUTE, PermissionKey.WARN, PermissionKey.UNWARN, PermissionKey.CHANGE_REASON, PermissionKey.BAN_LIST, PermissionKey.CHECK, PermissionKey.HISTORY, PermissionKey.CLEAR_ALL, PermissionKey.BYPASS, PermissionKey.BYPASS_WARN, PermissionKey.BYPASS_MUTE, PermissionKey.BYPASS_BAN, PermissionKey.BYPASS_BANIP, PermissionKey.BYPASS_JAIL, PermissionKey.BYPASS_KICK, PermissionKey.MANAGE, PermissionKey.MANAGE_SET_SPAWN, PermissionKey.MANAGE_SET_JAIL, PermissionKey.PUNISHERX_COMMAND, PermissionKey.PANELS_COMMAND, PermissionKey.SEE, PermissionKey.SEE_BAN, PermissionKey.SEE_BANIP, PermissionKey.SEE_UNBAN, PermissionKey.SEE_JAIL, PermissionKey.SEE_UNJAIL, PermissionKey.SEE_MUTE, PermissionKey.SEE_UNMUTE, PermissionKey.SEE_WARN, PermissionKey.SEE_UNWARN, PermissionKey.SEE_KICK, PermissionKey.SEE_UPDATE, PermissionKey.VIEW_IP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionKey.values().length];
            try {
                nArray[PermissionKey.OWNER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BANIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.UNBAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BAN_LIST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.CHANGE_REASON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.CHECK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.CLEAR_ALL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.HISTORY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.JAIL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.KICK.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.MUTE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.UNJAIL.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.UNMUTE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.WARN.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.UNWARN.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_WARN.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_MUTE.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_BAN.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_BANIP.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_JAIL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.BYPASS_KICK.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.MANAGE.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.MANAGE_SET_SPAWN.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.MANAGE_SET_JAIL.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_BAN.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_BANIP.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_UNBAN.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_JAIL.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_UNJAIL.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_MUTE.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_UNMUTE.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_WARN.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_UNWARN.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_KICK.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.SEE_UPDATE.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.PUNISHERX_COMMAND.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.PANELS_COMMAND.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionKey.VIEW_IP.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

