/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.players;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.players.CryptoUtilsKt;
import pl.syntaxdevteam.punisher.players.GeoIPHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J0\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0013H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%J\u0010\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u0013J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010\u001a\u001a\u00020\u0013J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010\u001b\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020+J\"\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190%2\u0006\u0010.\u001a\u00020\u0013J\u0012\u0010/\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020\u0013H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130%H\u0002J\u0010\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0013H\u0002J\u0016\u00104\u001a\u00020\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00130%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "geoIPHandler", "Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;Lpl/syntaxdevteam/punisher/players/GeoIPHandler;)V", "getGeoIPHandler", "()Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "cacheFile", "Ljava/io/File;", "secretKey", "Ljava/security/Key;", "dateFormat", "Ljava/text/SimpleDateFormat;", "useDatabase", "", "separator", "", "handlePlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "getPlayerInfo", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager$PlayerInfo;", "playerName", "playerUUID", "playerIP", "savePlayerInfo", "geoLocation", "lastUpdated", "generateKey", "encrypt", "data", "decrypt", "getAllDecryptedRecords", "", "getPlayerIPByName", "getPlayerIPByUUID", "getPlayerIPsByName", "getPlayerIPsByUUID", "deletePlayerInfo", "Ljava/util/UUID;", "searchCache", "getPlayersByIP", "targetIP", "parsePlayerInfo", "decryptedLine", "readLines", "appendLine", "encryptedData", "overwriteLines", "lines", "PlayerInfo", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPlayerIPManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerIPManager.kt\npl/syntaxdevteam/punisher/players/PlayerIPManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1#2:220\n1#2:231\n1617#3,9:221\n1869#3:230\n1870#3:232\n1626#3:233\n774#3:234\n865#3,2:235\n1563#3:237\n1634#3,3:238\n774#3:241\n865#3,2:242\n1563#3:244\n1634#3,3:245\n774#3:248\n865#3,2:249\n1869#3,2:251\n774#3:253\n865#3,2:254\n1563#3:256\n1634#3,3:257\n1869#3,2:260\n*S KotlinDebug\n*F\n+ 1 PlayerIPManager.kt\npl/syntaxdevteam/punisher/players/PlayerIPManager\n*L\n107#1:231\n107#1:221,9\n107#1:230\n107#1:232\n107#1:233\n137#1:234\n137#1:235,2\n138#1:237\n138#1:238,3\n145#1:241\n145#1:242,2\n146#1:244\n146#1:245,3\n152#1:248\n152#1:249,2\n157#1:251,2\n184#1:253\n184#1:254,2\n188#1:256\n188#1:257,3\n215#1:260,2\n*E\n"})
public final class PlayerIPManager {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final GeoIPHandler geoIPHandler;
    @NotNull
    private final File cacheFile;
    @NotNull
    private final Key secretKey;
    @NotNull
    private final SimpleDateFormat dateFormat;
    private final boolean useDatabase;
    @NotNull
    private final String separator;

    public PlayerIPManager(@NotNull PunisherX plugin, @NotNull GeoIPHandler geoIPHandler) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(geoIPHandler, "geoIPHandler");
        this.plugin = plugin;
        this.geoIPHandler = geoIPHandler;
        this.cacheFile = new File(this.plugin.getDataFolder(), "cache");
        this.secretKey = this.generateKey();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = this.plugin.getConfig().getString("playerCache.storage");
        this.useDatabase = string != null ? StringsKt.equals(string, "database", true) : false;
        this.separator = "|";
        if (!this.useDatabase && !this.cacheFile.exists()) {
            this.cacheFile.getParentFile().mkdirs();
            this.cacheFile.createNewFile();
        }
    }

    @NotNull
    public final GeoIPHandler getGeoIPHandler() {
        return this.geoIPHandler;
    }

    public final void handlePlayerJoin(@NotNull PlayerJoinEvent event) {
        String playerIP;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        String string2 = player2.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String playerUUID = string2;
        Serializable serializable = player2.getAddress();
        String string3 = serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : (playerIP = null);
        if (playerIP != null) {
            String country = this.geoIPHandler.getCountry(playerIP);
            String city = this.geoIPHandler.getCity(playerIP);
            String geoLocation = city + ", " + country;
            String lastUpdated = this.dateFormat.format(new Date());
            if (this.getPlayerInfo(playerName, playerUUID, playerIP) == null) {
                Intrinsics.checkNotNull(lastUpdated);
                this.savePlayerInfo(playerName, playerUUID, playerIP, geoLocation, lastUpdated);
                this.plugin.getLogger().debug("Saved player info -> playerName: " + playerName + ", playerUUID: " + playerUUID + ", playerIP: " + playerIP + ", geoLocation: " + geoLocation + ", lastUpdated: " + lastUpdated);
            } else {
                this.plugin.getLogger().debug("Player info already exists -> playerName: " + playerName + ", playerUUID: " + playerUUID + ", playerIP: " + playerIP + ", geoLocation: " + geoLocation + ", lastUpdated: " + lastUpdated);
            }
        }
    }

    private final PlayerInfo getPlayerInfo(String playerName, String playerUUID, String playerIP) {
        return this.searchCache(playerName, playerUUID, playerIP);
    }

    private final void savePlayerInfo(String playerName, String playerUUID, String playerIP, String geoLocation, String lastUpdated) {
        String dataLine = playerName + this.separator + playerUUID + this.separator + playerIP + this.separator + geoLocation + this.separator + lastUpdated;
        String encryptedData = this.encrypt(dataLine);
        this.appendLine(encryptedData);
        this.plugin.getLogger().debug("Encrypted data saved -> " + dataLine);
    }

    private final Key generateKey() {
        String keyString;
        String string = System.getenv("AES_KEY");
        if (string == null) {
            string = "1234567890ABCDEF";
        }
        if (!((keyString = string).length() == 16)) {
            boolean bl = false;
            String string2 = "AES key must be exactly 16 characters long";
            throw new IllegalArgumentException(string2.toString());
        }
        byte[] byArray = keyString.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return new SecretKeySpec(byArray, "AES");
    }

    private final String encrypt(String data) {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.secretKey);
        byte[] byArray = data.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return CryptoUtilsKt.toHexString(byArray2);
    }

    private final String decrypt(String data) {
        String string;
        if (StringsKt.isBlank(data)) {
            return "";
        }
        if (data.length() % 2 != 0) {
            this.plugin.getLogger().err("Failed to decrypt data: invalid hex length -> " + data);
            return "";
        }
        try {
            byte[] bytes = CryptoUtilsKt.hexStringToByteArray(data);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, this.secretKey);
            byte[] byArray = cipher.doFinal(bytes);
            Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            string = new String(byArray2, charset);
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Failed to decrypt data: " + data + " -> " + e);
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerInfo> getAllDecryptedRecords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.readLines();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PlayerInfo it$iv$iv;
            PlayerInfo playerInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                String decrypted = this.decrypt(line);
                playerInfo = this.parsePlayerInfo(decrypted);
            }
            catch (Exception e) {
                this.plugin.getLogger().err("Error decrypting line: " + line + " -> " + e);
                playerInfo = null;
            }
            if (playerInfo == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getPlayerIPByName(@NotNull String playerName) {
        PlayerInfo info;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        this.plugin.getLogger().debug("Fetching IP for player: " + playerName);
        PlayerInfo playerInfo = info = this.searchCache(playerName, "", "");
        String ip = playerInfo != null ? playerInfo.getPlayerIP() : null;
        this.plugin.getLogger().debug("Found IP for player " + playerName + ": " + ip);
        return ip;
    }

    @Nullable
    public final String getPlayerIPByUUID(@NotNull String playerUUID) {
        PlayerInfo info;
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        this.plugin.getLogger().debug("Fetching IP for UUID: " + playerUUID);
        PlayerInfo playerInfo = info = this.searchCache("", playerUUID, "");
        String ip = playerInfo != null ? playerInfo.getPlayerIP() : null;
        this.plugin.getLogger().debug("Found IP for UUID " + playerUUID + ": " + ip);
        return ip;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPlayerIPsByName(@NotNull String playerName) {
        List list;
        void $this$mapTo$iv$iv;
        PlayerInfo it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        this.plugin.getLogger().debug("Fetching all IPs for player: " + playerName);
        Iterable $this$filter$iv = this.getAllDecryptedRecords();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PlayerInfo)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals(it.getPlayerName(), playerName, true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PlayerInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPlayerIP());
        }
        List it2 = list = (List)destination$iv$iv;
        boolean bl = false;
        this.plugin.getLogger().debug("Found IPs for player " + playerName + ": " + it2);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPlayerIPsByUUID(@NotNull String playerUUID) {
        List list;
        void $this$mapTo$iv$iv;
        PlayerInfo it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        this.plugin.getLogger().debug("Fetching all IPs for UUID: " + playerUUID);
        Iterable $this$filter$iv = this.getAllDecryptedRecords();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PlayerInfo)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals(it.getPlayerUUID(), playerUUID, true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PlayerInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPlayerIP());
        }
        List it2 = list = (List)destination$iv$iv;
        boolean bl = false;
        this.plugin.getLogger().debug("Found IPs for UUID " + playerUUID + ": " + it2);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void deletePlayerInfo(@NotNull UUID playerUUID) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
        List<String> lines = this.readLines();
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerInfo info;
            String line = (String)element$iv$iv;
            boolean bl = false;
            PlayerInfo playerInfo = info = this.parsePlayerInfo(this.decrypt(line));
            if (!(!Intrinsics.areEqual(playerInfo != null ? playerInfo.getPlayerUUID() : null, playerUUID.toString()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        FilesKt.writeText$default(this.cacheFile, "", null, 2, null);
        Iterable $this$forEach$iv = filtered;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            FilesKt.appendText$default(this.cacheFile, it + "\n", null, 2, null);
        }
        this.plugin.getLogger().debug("Removed player info for UUID: " + playerUUID);
    }

    private final PlayerInfo searchCache(String playerName, String playerUUID, String playerIP) {
        this.plugin.getLogger().debug("Searching cache");
        List<String> lines = this.readLines();
        this.plugin.getLogger().debug("Number of lines in cache: " + lines.size());
        for (String line : lines) {
            String decryptedLine = this.decrypt(line);
            this.plugin.getLogger().debug("Decrypted line: " + decryptedLine);
            PlayerInfo info = this.parsePlayerInfo(decryptedLine);
            if (info == null || !(((CharSequence)playerName).length() == 0) && !StringsKt.equals(info.getPlayerName(), playerName, true) || !(((CharSequence)playerUUID).length() == 0) && !StringsKt.equals(info.getPlayerUUID(), playerUUID, true) || !(((CharSequence)playerIP).length() == 0) && !StringsKt.equals(info.getPlayerIP(), playerIP, true)) continue;
            this.plugin.getLogger().debug("Match found: " + decryptedLine);
            return info;
        }
        this.plugin.getLogger().debug("No match found in cache");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerInfo> getPlayersByIP(@NotNull String targetIP) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(targetIP, "targetIP");
        Iterable $this$filter$iv = this.getAllDecryptedRecords();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerInfo it = (PlayerInfo)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals(it.getPlayerIP(), targetIP, true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PlayerInfo parsePlayerInfo(String decryptedLine) {
        PlayerInfo playerInfo;
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{this.separator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)decryptedLine, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() >= 5) {
            playerInfo = new PlayerInfo((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), (String)parts.get(3), (String)parts.get(4));
        } else {
            this.plugin.getLogger().err("Invalid record format: " + decryptedLine);
            playerInfo = null;
        }
        return playerInfo;
    }

    private final List<String> readLines() {
        return this.useDatabase ? this.plugin.getDatabaseHandler().getPlayerCacheLines() : FilesKt.readLines$default(this.cacheFile, null, 1, null);
    }

    private final void appendLine(String encryptedData) {
        if (this.useDatabase) {
            this.plugin.getDatabaseHandler().savePlayerCacheLine(encryptedData);
        } else {
            FilesKt.appendText$default(this.cacheFile, encryptedData + "\n", null, 2, null);
        }
    }

    private final void overwriteLines(List<String> lines) {
        if (this.useDatabase) {
            this.plugin.getDatabaseHandler().overwritePlayerCache(lines);
        } else {
            FilesKt.writeText$default(this.cacheFile, "", null, 2, null);
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                FilesKt.appendText$default(this.cacheFile, it + "\n", null, 2, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lpl/syntaxdevteam/punisher/players/PlayerIPManager$PlayerInfo;", "", "playerName", "", "playerUUID", "playerIP", "geoLocation", "lastUpdated", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPlayerName", "()Ljava/lang/String;", "getPlayerUUID", "getPlayerIP", "getGeoLocation", "getLastUpdated", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "PunisherX"})
    public static final class PlayerInfo {
        @NotNull
        private final String playerName;
        @NotNull
        private final String playerUUID;
        @NotNull
        private final String playerIP;
        @NotNull
        private final String geoLocation;
        @NotNull
        private final String lastUpdated;

        public PlayerInfo(@NotNull String playerName, @NotNull String playerUUID, @NotNull String playerIP, @NotNull String geoLocation, @NotNull String lastUpdated) {
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
            Intrinsics.checkNotNullParameter(playerIP, "playerIP");
            Intrinsics.checkNotNullParameter(geoLocation, "geoLocation");
            Intrinsics.checkNotNullParameter(lastUpdated, "lastUpdated");
            this.playerName = playerName;
            this.playerUUID = playerUUID;
            this.playerIP = playerIP;
            this.geoLocation = geoLocation;
            this.lastUpdated = lastUpdated;
        }

        @NotNull
        public final String getPlayerName() {
            return this.playerName;
        }

        @NotNull
        public final String getPlayerUUID() {
            return this.playerUUID;
        }

        @NotNull
        public final String getPlayerIP() {
            return this.playerIP;
        }

        @NotNull
        public final String getGeoLocation() {
            return this.geoLocation;
        }

        @NotNull
        public final String getLastUpdated() {
            return this.lastUpdated;
        }

        @NotNull
        public final String component1() {
            return this.playerName;
        }

        @NotNull
        public final String component2() {
            return this.playerUUID;
        }

        @NotNull
        public final String component3() {
            return this.playerIP;
        }

        @NotNull
        public final String component4() {
            return this.geoLocation;
        }

        @NotNull
        public final String component5() {
            return this.lastUpdated;
        }

        @NotNull
        public final PlayerInfo copy(@NotNull String playerName, @NotNull String playerUUID, @NotNull String playerIP, @NotNull String geoLocation, @NotNull String lastUpdated) {
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            Intrinsics.checkNotNullParameter(playerUUID, "playerUUID");
            Intrinsics.checkNotNullParameter(playerIP, "playerIP");
            Intrinsics.checkNotNullParameter(geoLocation, "geoLocation");
            Intrinsics.checkNotNullParameter(lastUpdated, "lastUpdated");
            return new PlayerInfo(playerName, playerUUID, playerIP, geoLocation, lastUpdated);
        }

        public static /* synthetic */ PlayerInfo copy$default(PlayerInfo playerInfo, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = playerInfo.playerName;
            }
            if ((n & 2) != 0) {
                string2 = playerInfo.playerUUID;
            }
            if ((n & 4) != 0) {
                string3 = playerInfo.playerIP;
            }
            if ((n & 8) != 0) {
                string4 = playerInfo.geoLocation;
            }
            if ((n & 0x10) != 0) {
                string5 = playerInfo.lastUpdated;
            }
            return playerInfo.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "PlayerInfo(playerName=" + this.playerName + ", playerUUID=" + this.playerUUID + ", playerIP=" + this.playerIP + ", geoLocation=" + this.geoLocation + ", lastUpdated=" + this.lastUpdated + ")";
        }

        public int hashCode() {
            int result = this.playerName.hashCode();
            result = result * 31 + this.playerUUID.hashCode();
            result = result * 31 + this.playerIP.hashCode();
            result = result * 31 + this.geoLocation.hashCode();
            result = result * 31 + this.lastUpdated.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerInfo)) {
                return false;
            }
            PlayerInfo playerInfo = (PlayerInfo)other;
            if (!Intrinsics.areEqual(this.playerName, playerInfo.playerName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.playerUUID, playerInfo.playerUUID)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.playerIP, playerInfo.playerIP)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.geoLocation, playerInfo.geoLocation)) {
                return false;
            }
            return Intrinsics.areEqual(this.lastUpdated, playerInfo.lastUpdated);
        }
    }
}

