/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.api.PunisherXApi;
import pl.syntaxdevteam.punisher.api.PunisherXApiImpl;
import pl.syntaxdevteam.punisher.basic.PunishmentCache;
import pl.syntaxdevteam.punisher.basic.PunishmentChecker;
import pl.syntaxdevteam.punisher.basic.PunishmentManager;
import pl.syntaxdevteam.punisher.basic.TimeHandler;
import pl.syntaxdevteam.punisher.commands.CommandManager;
import pl.syntaxdevteam.punisher.common.CommandLoggerPlugin;
import pl.syntaxdevteam.punisher.common.ConfigHandler;
import pl.syntaxdevteam.punisher.common.Logger;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.common.PluginManager;
import pl.syntaxdevteam.punisher.common.StatsCollector;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.common.UpdateChecker;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.hooks.DiscordWebhook;
import pl.syntaxdevteam.punisher.hooks.HookHandler;
import pl.syntaxdevteam.punisher.listeners.LegacyLoginListener;
import pl.syntaxdevteam.punisher.listeners.ModernLoginListener;
import pl.syntaxdevteam.punisher.loader.VersionChecker;
import pl.syntaxdevteam.punisher.placeholders.PlaceholderHandler;
import pl.syntaxdevteam.punisher.players.GeoIPHandler;
import pl.syntaxdevteam.punisher.players.PlayerIPManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020hH\u0016J\u0006\u0010j\u001a\u00020hJ\b\u0010k\u001a\u00020hH\u0016J\b\u0010l\u001a\u00020hH\u0002J\b\u0010m\u001a\u00020hH\u0002J\b\u0010n\u001a\u00020hH\u0002J\b\u0010o\u001a\u00020hH\u0002J\b\u0010p\u001a\u00020hH\u0002J\b\u0010q\u001a\u00020hH\u0002J\u0006\u0010r\u001a\u00020sJ\b\u0010t\u001a\u00020hH\u0002J\u0006\u0010u\u001a\u00020vJ\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00020y0x2\u0006\u0010z\u001a\u00020{H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u00020JX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020PX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010U\u001a\u00020VX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020\\X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\u001a\u0010a\u001a\u00020bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010f\u00a8\u0006|"}, d2={"Lpl/syntaxdevteam/punisher/PunisherX;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "logger", "Lpl/syntaxdevteam/punisher/common/Logger;", "getLogger", "()Lpl/syntaxdevteam/punisher/common/Logger;", "setLogger", "(Lpl/syntaxdevteam/punisher/common/Logger;)V", "pluginsManager", "Lpl/syntaxdevteam/punisher/common/PluginManager;", "getPluginsManager", "()Lpl/syntaxdevteam/punisher/common/PluginManager;", "setPluginsManager", "(Lpl/syntaxdevteam/punisher/common/PluginManager;)V", "statsCollector", "Lpl/syntaxdevteam/punisher/common/StatsCollector;", "databaseHandler", "Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "getDatabaseHandler", "()Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "setDatabaseHandler", "(Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;)V", "messageHandler", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "getMessageHandler", "()Lpl/syntaxdevteam/punisher/common/MessageHandler;", "setMessageHandler", "(Lpl/syntaxdevteam/punisher/common/MessageHandler;)V", "timeHandler", "Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "getTimeHandler", "()Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "setTimeHandler", "(Lpl/syntaxdevteam/punisher/basic/TimeHandler;)V", "punishmentManager", "Lpl/syntaxdevteam/punisher/basic/PunishmentManager;", "getPunishmentManager", "()Lpl/syntaxdevteam/punisher/basic/PunishmentManager;", "setPunishmentManager", "(Lpl/syntaxdevteam/punisher/basic/PunishmentManager;)V", "updateChecker", "Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "getUpdateChecker", "()Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "setUpdateChecker", "(Lpl/syntaxdevteam/punisher/common/UpdateChecker;)V", "geoIPHandler", "Lpl/syntaxdevteam/punisher/players/GeoIPHandler;", "playerIPManager", "Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "getPlayerIPManager", "()Lpl/syntaxdevteam/punisher/players/PlayerIPManager;", "setPlayerIPManager", "(Lpl/syntaxdevteam/punisher/players/PlayerIPManager;)V", "uuidManager", "Lpl/syntaxdevteam/punisher/common/UUIDManager;", "getUuidManager", "()Lpl/syntaxdevteam/punisher/common/UUIDManager;", "commandManager", "Lpl/syntaxdevteam/punisher/commands/CommandManager;", "cache", "Lpl/syntaxdevteam/punisher/basic/PunishmentCache;", "getCache", "()Lpl/syntaxdevteam/punisher/basic/PunishmentCache;", "setCache", "(Lpl/syntaxdevteam/punisher/basic/PunishmentCache;)V", "configHandler", "Lpl/syntaxdevteam/punisher/common/ConfigHandler;", "commandLoggerPlugin", "Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;", "getCommandLoggerPlugin", "()Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;", "setCommandLoggerPlugin", "(Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;)V", "punisherXApi", "Lpl/syntaxdevteam/punisher/api/PunisherXApi;", "getPunisherXApi", "()Lpl/syntaxdevteam/punisher/api/PunisherXApi;", "setPunisherXApi", "(Lpl/syntaxdevteam/punisher/api/PunisherXApi;)V", "discordWebhook", "Lpl/syntaxdevteam/punisher/hooks/DiscordWebhook;", "getDiscordWebhook", "()Lpl/syntaxdevteam/punisher/hooks/DiscordWebhook;", "setDiscordWebhook", "(Lpl/syntaxdevteam/punisher/hooks/DiscordWebhook;)V", "hookHandler", "Lpl/syntaxdevteam/punisher/hooks/HookHandler;", "getHookHandler", "()Lpl/syntaxdevteam/punisher/hooks/HookHandler;", "setHookHandler", "(Lpl/syntaxdevteam/punisher/hooks/HookHandler;)V", "versionChecker", "Lpl/syntaxdevteam/punisher/loader/VersionChecker;", "getVersionChecker", "()Lpl/syntaxdevteam/punisher/loader/VersionChecker;", "setVersionChecker", "(Lpl/syntaxdevteam/punisher/loader/VersionChecker;)V", "onLoad", "", "onEnable", "onReload", "onDisable", "setupConfig", "setupDatabase", "setupHandlers", "registerCommands", "registerEvents", "checkForUpdates", "getPluginFile", "Ljava/io/File;", "reloadMyConfig", "getServerName", "", "getPunishmentHistory", "", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "player", "Lorg/bukkit/entity/Player;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherX.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherX.kt\npl/syntaxdevteam/punisher/PunisherX\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class PunisherX
extends JavaPlugin
implements Listener {
    @NotNull
    private final FileConfiguration config;
    @NotNull
    private Logger logger;
    public PluginManager pluginsManager;
    private StatsCollector statsCollector;
    public DatabaseHandler databaseHandler;
    public MessageHandler messageHandler;
    public TimeHandler timeHandler;
    public PunishmentManager punishmentManager;
    public UpdateChecker updateChecker;
    @NotNull
    private GeoIPHandler geoIPHandler;
    @NotNull
    private PlayerIPManager playerIPManager;
    @NotNull
    private final UUIDManager uuidManager;
    private CommandManager commandManager;
    public PunishmentCache cache;
    @NotNull
    private ConfigHandler configHandler;
    public CommandLoggerPlugin commandLoggerPlugin;
    public PunisherXApi punisherXApi;
    public DiscordWebhook discordWebhook;
    public HookHandler hookHandler;
    public VersionChecker versionChecker;

    public PunisherX() {
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        this.logger = new Logger(this, this.config.getBoolean("debug"));
        this.geoIPHandler = new GeoIPHandler(this);
        this.playerIPManager = new PlayerIPManager(this, this.geoIPHandler);
        this.uuidManager = new UUIDManager(this);
        this.configHandler = new ConfigHandler(this);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "<set-?>");
        this.logger = logger;
    }

    @NotNull
    public final PluginManager getPluginsManager() {
        PluginManager pluginManager = this.pluginsManager;
        if (pluginManager != null) {
            return pluginManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pluginsManager");
        return null;
    }

    public final void setPluginsManager(@NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter(pluginManager, "<set-?>");
        this.pluginsManager = pluginManager;
    }

    @NotNull
    public final DatabaseHandler getDatabaseHandler() {
        DatabaseHandler databaseHandler = this.databaseHandler;
        if (databaseHandler != null) {
            return databaseHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("databaseHandler");
        return null;
    }

    public final void setDatabaseHandler(@NotNull DatabaseHandler databaseHandler) {
        Intrinsics.checkNotNullParameter(databaseHandler, "<set-?>");
        this.databaseHandler = databaseHandler;
    }

    @NotNull
    public final MessageHandler getMessageHandler() {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            return messageHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("messageHandler");
        return null;
    }

    public final void setMessageHandler(@NotNull MessageHandler messageHandler) {
        Intrinsics.checkNotNullParameter(messageHandler, "<set-?>");
        this.messageHandler = messageHandler;
    }

    @NotNull
    public final TimeHandler getTimeHandler() {
        TimeHandler timeHandler = this.timeHandler;
        if (timeHandler != null) {
            return timeHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("timeHandler");
        return null;
    }

    public final void setTimeHandler(@NotNull TimeHandler timeHandler) {
        Intrinsics.checkNotNullParameter(timeHandler, "<set-?>");
        this.timeHandler = timeHandler;
    }

    @NotNull
    public final PunishmentManager getPunishmentManager() {
        PunishmentManager punishmentManager = this.punishmentManager;
        if (punishmentManager != null) {
            return punishmentManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("punishmentManager");
        return null;
    }

    public final void setPunishmentManager(@NotNull PunishmentManager punishmentManager) {
        Intrinsics.checkNotNullParameter(punishmentManager, "<set-?>");
        this.punishmentManager = punishmentManager;
    }

    @NotNull
    public final UpdateChecker getUpdateChecker() {
        UpdateChecker updateChecker = this.updateChecker;
        if (updateChecker != null) {
            return updateChecker;
        }
        Intrinsics.throwUninitializedPropertyAccessException("updateChecker");
        return null;
    }

    public final void setUpdateChecker(@NotNull UpdateChecker updateChecker) {
        Intrinsics.checkNotNullParameter(updateChecker, "<set-?>");
        this.updateChecker = updateChecker;
    }

    @NotNull
    public final PlayerIPManager getPlayerIPManager() {
        return this.playerIPManager;
    }

    public final void setPlayerIPManager(@NotNull PlayerIPManager playerIPManager) {
        Intrinsics.checkNotNullParameter(playerIPManager, "<set-?>");
        this.playerIPManager = playerIPManager;
    }

    @NotNull
    public final UUIDManager getUuidManager() {
        return this.uuidManager;
    }

    @NotNull
    public final PunishmentCache getCache() {
        PunishmentCache punishmentCache = this.cache;
        if (punishmentCache != null) {
            return punishmentCache;
        }
        Intrinsics.throwUninitializedPropertyAccessException("cache");
        return null;
    }

    public final void setCache(@NotNull PunishmentCache punishmentCache) {
        Intrinsics.checkNotNullParameter(punishmentCache, "<set-?>");
        this.cache = punishmentCache;
    }

    @NotNull
    public final CommandLoggerPlugin getCommandLoggerPlugin() {
        CommandLoggerPlugin commandLoggerPlugin = this.commandLoggerPlugin;
        if (commandLoggerPlugin != null) {
            return commandLoggerPlugin;
        }
        Intrinsics.throwUninitializedPropertyAccessException("commandLoggerPlugin");
        return null;
    }

    public final void setCommandLoggerPlugin(@NotNull CommandLoggerPlugin commandLoggerPlugin) {
        Intrinsics.checkNotNullParameter(commandLoggerPlugin, "<set-?>");
        this.commandLoggerPlugin = commandLoggerPlugin;
    }

    @NotNull
    public final PunisherXApi getPunisherXApi() {
        PunisherXApi punisherXApi = this.punisherXApi;
        if (punisherXApi != null) {
            return punisherXApi;
        }
        Intrinsics.throwUninitializedPropertyAccessException("punisherXApi");
        return null;
    }

    public final void setPunisherXApi(@NotNull PunisherXApi punisherXApi) {
        Intrinsics.checkNotNullParameter(punisherXApi, "<set-?>");
        this.punisherXApi = punisherXApi;
    }

    @NotNull
    public final DiscordWebhook getDiscordWebhook() {
        DiscordWebhook discordWebhook = this.discordWebhook;
        if (discordWebhook != null) {
            return discordWebhook;
        }
        Intrinsics.throwUninitializedPropertyAccessException("discordWebhook");
        return null;
    }

    public final void setDiscordWebhook(@NotNull DiscordWebhook discordWebhook) {
        Intrinsics.checkNotNullParameter(discordWebhook, "<set-?>");
        this.discordWebhook = discordWebhook;
    }

    @NotNull
    public final HookHandler getHookHandler() {
        HookHandler hookHandler = this.hookHandler;
        if (hookHandler != null) {
            return hookHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("hookHandler");
        return null;
    }

    public final void setHookHandler(@NotNull HookHandler hookHandler) {
        Intrinsics.checkNotNullParameter(hookHandler, "<set-?>");
        this.hookHandler = hookHandler;
    }

    @NotNull
    public final VersionChecker getVersionChecker() {
        VersionChecker versionChecker = this.versionChecker;
        if (versionChecker != null) {
            return versionChecker;
        }
        Intrinsics.throwUninitializedPropertyAccessException("versionChecker");
        return null;
    }

    public final void setVersionChecker(@NotNull VersionChecker versionChecker) {
        Intrinsics.checkNotNullParameter(versionChecker, "<set-?>");
        this.versionChecker = versionChecker;
    }

    public void onLoad() {
        this.setVersionChecker(new VersionChecker(this));
        this.getVersionChecker().checkAndLog();
    }

    public void onEnable() {
        this.setupConfig();
        this.setupDatabase();
        this.setupHandlers();
        this.registerEvents();
        this.registerCommands();
        this.checkForUpdates();
    }

    public final void onReload() {
        this.reloadMyConfig();
    }

    public void onDisable() {
        this.getDatabaseHandler().closeConnection();
        HandlerList handlerList = AsyncChatEvent.getHandlerList();
        Intrinsics.checkNotNull((Object)this, "null cannot be cast to non-null type org.bukkit.plugin.Plugin");
        handlerList.unregister((Plugin)this);
        this.logger.err(this.getPluginMeta().getName() + " " + this.getPluginMeta().getVersion() + " has been disabled \u2639\ufe0f");
    }

    private final void setupConfig() {
        this.saveDefaultConfig();
        this.configHandler.verifyAndUpdateConfig();
    }

    private final void setupDatabase() {
        this.setDatabaseHandler(new DatabaseHandler(this));
        this.getDatabaseHandler().openConnection();
        this.getDatabaseHandler().createTables();
    }

    /*
     * WARNING - void declaration
     */
    private final void setupHandlers() {
        void $this$setupHandlers_u24lambda_u240;
        MessageHandler messageHandler;
        MessageHandler messageHandler2 = messageHandler = new MessageHandler(this);
        PunisherX punisherX = this;
        boolean bl = false;
        $this$setupHandlers_u24lambda_u240.initial();
        punisherX.setMessageHandler(messageHandler);
        this.setTimeHandler(new TimeHandler(this));
        this.setPunishmentManager(new PunishmentManager());
        this.geoIPHandler = new GeoIPHandler(this);
        this.setPluginsManager(new PluginManager(this));
        this.setCache(new PunishmentCache(this));
        this.setPunisherXApi(new PunisherXApiImpl(this.getDatabaseHandler()));
        this.setHookHandler(new HookHandler(this));
        this.setDiscordWebhook(new DiscordWebhook(this));
    }

    private final void registerCommands() {
        this.setCommandLoggerPlugin(new CommandLoggerPlugin(this));
        this.commandManager = new CommandManager(this);
        CommandManager commandManager = this.commandManager;
        if (commandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            commandManager = null;
        }
        commandManager.registerCommands();
    }

    private final void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.playerIPManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PunishmentChecker(this), (Plugin)this);
        if (this.getVersionChecker().isAtLeast("1.21.7")) {
            this.getServer().getPluginManager().registerEvents((Listener)new ModernLoginListener(this), (Plugin)this);
            this.logger.debug("Registered ModernLoginListener for 1.21.7+");
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new LegacyLoginListener(this), (Plugin)this);
            this.logger.debug("Registered LegacyLoginListener for pre-1.21.7");
        }
        this.getServer().getServicesManager().register(PunisherXApi.class, (Object)this.getPunisherXApi(), (Plugin)this, ServicePriority.Normal);
        if (this.getHookHandler().checkPlaceholderAPI()) {
            new PlaceholderHandler(this).register();
        }
    }

    private final void checkForUpdates() {
        this.statsCollector = new StatsCollector(this);
        this.setUpdateChecker(new UpdateChecker(this));
        this.getUpdateChecker().checkForUpdates();
    }

    @NotNull
    public final File getPluginFile() {
        File file = this.getFile();
        Intrinsics.checkNotNullExpressionValue(file, "getFile(...)");
        return file;
    }

    private final void reloadMyConfig() {
        this.getDatabaseHandler().closeConnection();
        try {
            this.getMessageHandler().reloadMessages();
        }
        catch (Exception e) {
            this.logger.err(MessageHandler.getMessage$default(this.getMessageHandler(), "error", "reload", null, 4, null) + " " + e.getMessage());
        }
        this.setDatabaseHandler(new DatabaseHandler(this));
        this.getDatabaseHandler().openConnection();
        this.getDatabaseHandler().createTables();
    }

    @NotNull
    public final String getServerName() {
        Properties properties = new Properties();
        File file = new File("server.properties");
        if (file.exists()) {
            properties.load(new FileInputStream(file));
            String serverName = properties.getProperty("server-name");
            if (serverName != null) {
                return serverName;
            }
            this.logger.debug("Property 'server-name' not found in server.properties file.");
        } else {
            this.logger.debug("The server.properties file does not exist.");
        }
        return "Unknown Server";
    }

    @Deprecated(message="Use PunisherXApi#getPunishmentHistory for improved async operations and filtering", replaceWith=@ReplaceWith(expression="punisherXApi.getPunishmentHistory(uuid.toString())", imports={"pl.syntaxdevteam.punisher.api.PunisherXApi"}), level=DeprecationLevel.WARNING)
    @NotNull
    public final List<PunishmentData> getPunishmentHistory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        UUID uuid = this.uuidManager.getUUID(string);
        DatabaseHandler databaseHandler = this.getDatabaseHandler();
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return databaseHandler.getLastTenPunishments(string2);
    }
}

