/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/syntaxdevteam/punisher/basic/TimeHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "parseTime", "", "time", "", "formatTime", "getLocalizedMessage", "unit", "amount", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nTimeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,66:1\n1069#2,2:67\n*S KotlinDebug\n*F\n+ 1 TimeHandler.kt\npl/syntaxdevteam/punisher/basic/TimeHandler\n*L\n23#1:67,2\n*E\n"})
public final class TimeHandler {
    @NotNull
    private final PunisherX plugin;

    public TimeHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final long parseTime(@NotNull String time) {
        Intrinsics.checkNotNullParameter(time, "time");
        String string = time.substring(0, time.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        long amount = Long.parseLong(string);
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount;
            case 'm' -> amount * (long)60;
            case 'h' -> amount * (long)60 * (long)60;
            case 'd' -> amount * (long)60 * (long)60 * (long)24;
            default -> 0L;
        };
    }

    @NotNull
    public final String formatTime(@Nullable String time) {
        boolean isNumeric;
        block13: {
            boolean bl;
            if (time == null) {
                return MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), "formatTime", "undefined", null, 4, null);
            }
            CharSequence $this$all$iv = time;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block13;
            }
            bl = isNumeric = true;
        }
        if (isNumeric) {
            long totalSeconds = Long.parseLong(time);
            long days = totalSeconds / (long)86400;
            long hours = totalSeconds % (long)86400 / (long)3600;
            long minutes = totalSeconds % (long)3600 / (long)60;
            long seconds = totalSeconds % (long)60;
            String dayMessage = this.getLocalizedMessage("day", days);
            String hourMessage = this.getLocalizedMessage("hour", hours);
            String minuteMessage = this.getLocalizedMessage("minute", minutes);
            String secondMessage = this.getLocalizedMessage("second", seconds);
            List timeComponents = new ArrayList();
            if (days > 0L) {
                timeComponents.add(days + " " + dayMessage);
            }
            if (hours > 0L) {
                timeComponents.add(hours + " " + hourMessage);
            }
            if (minutes > 0L) {
                timeComponents.add(minutes + " " + minuteMessage);
            }
            if (seconds > 0L) {
                timeComponents.add(seconds + " " + secondMessage);
            }
            return CollectionsKt.joinToString$default(timeComponents, ", ", null, null, 0, null, null, 62, null);
        }
        String string = time.substring(0, time.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        long amount = Long.parseLong(string);
        char unit = StringsKt.last(time);
        return switch (unit) {
            case 's' -> amount + " " + this.getLocalizedMessage("second", amount);
            case 'm' -> amount + " " + this.getLocalizedMessage("minute", amount);
            case 'h' -> amount + " " + this.getLocalizedMessage("hour", amount);
            case 'd' -> amount + " " + this.getLocalizedMessage("day", amount);
            default -> MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), "formatTime", "undefined", null, 4, null);
        };
    }

    private final String getLocalizedMessage(String unit, long amount) {
        String unitPath = "formatTime." + unit;
        long l = amount;
        return l == 1L ? MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), unitPath, "one", null, 4, null) : ((2L <= l ? l < 5L : false) ? MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), unitPath, "few", null, 4, null) : MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), unitPath, "many", null, 4, null));
    }
}

