/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/commands/JailCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nJailCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JailCommand.kt\npl/syntaxdevteam/punisher/commands/JailCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n827#2:154\n855#2,2:155\n827#2:157\n855#2,2:158\n1869#2:160\n1869#2,2:161\n1870#2:163\n1563#2:164\n1634#2,3:165\n1374#2:168\n1460#2,2:169\n1563#2:171\n1634#2,3:172\n1462#2,3:175\n*S KotlinDebug\n*F\n+ 1 JailCommand.kt\npl/syntaxdevteam/punisher/commands/JailCommand\n*L\n48#1:154\n48#1:155,2\n51#1:157\n51#1:158,2\n120#1:160\n122#1:161,2\n120#1:163\n141#1:164\n141#1:165,3\n150#1:168\n150#1:169,2\n150#1:171\n150#1:172,3\n150#1:175,3\n*E\n"})
public final class JailCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public JailCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Pair[] $this$execute_u24lambda_u247;
        Pair[] $i$f$filterNotTo3;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.JAIL)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
            return;
        }
        if (args.length == 0 || args.length < 2) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "jail", "usage", null, 4, null));
            return;
        }
        String playerName = args[0];
        UUID uuid = this.plugin.getUuidManager().getUUID(playerName);
        Pair[] targetPlayer = Bukkit.getPlayer((UUID)uuid);
        boolean isForce = ArraysKt.contains(args, "--force");
        if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithBypass((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_JAIL)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", playerName))));
            return;
        }
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (PermissionChecker.INSTANCE.isAuthor(uuid)) {
            stack.getSender().sendMessage(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(prefix + " <red>You can't punish the plugin author</red>"));
            return;
        }
        String gtime = null;
        String reason = null;
        try {
            void $this$filterNotTo$iv$iv;
            gtime = args[1];
            this.plugin.getTimeHandler().parseTime(gtime);
            Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(2, args.length));
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            for (Iterator element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)((Object)element$iv$iv);
                boolean bl = false;
                if (Intrinsics.areEqual(it, "--force")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            reason = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        }
        catch (NumberFormatException numberFormatException) {
            void $this$filterNotTo$iv$iv;
            gtime = null;
            Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(1, args.length));
            boolean $i$f$filterNot = false;
            destination$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo3 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it, "--force")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            reason = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
        }
        String punishmentType = "JAIL";
        long start = System.currentTimeMillis();
        Long end = gtime != null ? Long.valueOf(start + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location jailLocation = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        if (jailLocation == null) {
            this.plugin.getLogger().debug("<red>No jail location found! Teleportation aborted.</red>");
            return;
        }
        this.plugin.getLogger().debug("<yellow>Jail location: " + jailLocation + "</yellow>");
        if (targetPlayer != null) {
            $this$execute_u24lambda_u247 = $i$f$filterNotTo3 = targetPlayer;
            boolean bl = false;
            String string = this.plugin.getServer().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (StringsKt.contains$default((CharSequence)string, "Folia", false, 2, null)) {
                Bukkit.getServer().getRegionScheduler().execute((Plugin)this.plugin, jailLocation, () -> JailCommand.execute$lambda$7$lambda$6(jailLocation, this, (Player)$this$execute_u24lambda_u247));
            } else {
                if (!jailLocation.getChunk().isLoaded()) {
                    jailLocation.getChunk().load();
                }
                try {
                    $this$execute_u24lambda_u247.teleport(jailLocation);
                    this.plugin.getLogger().debug("<green>Player successfully teleported to jail.</green>");
                }
                catch (Exception e) {
                    this.plugin.getLogger().debug("<red>Error while teleporting player: " + e.getMessage() + "</red>");
                }
            }
            $this$execute_u24lambda_u247.setGameMode(GameMode.ADVENTURE);
            this.plugin.getLogger().debug("Changing gamemode (" + $this$execute_u24lambda_u247.getGameMode() + ") and teleporting " + $this$execute_u24lambda_u247.getName() + " to " + jailLocation);
        }
        DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = stack.getSender().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        Long l = end;
        databaseHandler.addPunishment(playerName, string, reason, string2, punishmentType, start, l != null ? l : -1L);
        DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
        String string3 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        String string4 = stack.getSender().getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        Long l2 = end;
        databaseHandler2.addPunishmentHistory(playerName, string3, reason, string4, punishmentType, start, l2 != null ? l2 : -1L);
        Long l3 = end;
        this.plugin.getCache().addOrUpdatePunishment(uuid, l3 != null ? l3 : -1L);
        if (targetPlayer != null) {
            $i$f$filterNotTo3 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
            targetPlayer.sendMessage(this.plugin.getMessageHandler().getMessage("jail", "jail_message", MapsKt.mapOf($i$f$filterNotTo3)));
        }
        $this$execute_u24lambda_u247 = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
        List<Component> broadcastMessages = this.plugin.getMessageHandler().getSmartMessage("jail", "broadcast", MapsKt.mapOf($this$execute_u24lambda_u247));
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(onlinePlayer);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_JAIL)) continue;
            Iterable $this$forEach$iv2 = broadcastMessages;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Component message = (Component)element$iv2;
                boolean bl2 = false;
                onlinePlayer.sendMessage(message);
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("jail", "jail", MapsKt.mapOf(pairArray)));
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.JAIL)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-JailCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getReasons("jail", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateTimeSuggestions() {
        void $this$flatMapTo$iv$iv;
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        Iterable $this$flatMap$iv = new IntRange(1, 999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            int element$iv$iv;
            int i = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$map$iv = units;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void unit;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(i + (String)unit);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit execute$lambda$7$lambda$6$lambda$5$lambda$2(JailCommand this$0, Boolean success) {
        if (success.booleanValue()) {
            this$0.plugin.getLogger().debug("<green>Player successfully teleported to jail.</green>");
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport player to jail.</red>");
        }
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$7$lambda$6$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void execute$lambda$7$lambda$6$lambda$5$lambda$4(JailCommand this$0, Throwable throwable) {
        this$0.plugin.getLogger().debug("<red>Teleportation error: " + throwable.getMessage() + "</red>");
        return null;
    }

    private static final void execute$lambda$7$lambda$6$lambda$5(Player $this_apply, Location $jailLocation, JailCommand this$0) {
        ((CompletableFuture)$this_apply.teleportAsync($jailLocation).thenAccept(arg_0 -> JailCommand.execute$lambda$7$lambda$6$lambda$5$lambda$3(arg_0 -> JailCommand.execute$lambda$7$lambda$6$lambda$5$lambda$2(this$0, arg_0), arg_0))).exceptionally(arg_0 -> JailCommand.execute$lambda$7$lambda$6$lambda$5$lambda$4(this$0, arg_0));
    }

    private static final void execute$lambda$7$lambda$6(Location $jailLocation, JailCommand this$0, Player $this_apply) {
        try {
            if (!$jailLocation.getChunk().isLoaded()) {
                $jailLocation.getChunk().load();
            }
            Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)this$0.plugin, () -> JailCommand.execute$lambda$7$lambda$6$lambda$5($this_apply, $jailLocation, this$0));
        }
        catch (Exception e) {
            this$0.plugin.getLogger().debug("<red>Error in regionScheduler execution: " + e.getMessage() + "</red>");
        }
    }
}

